/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation;

import com.f708.anothergunmod.client.animation.WeaponAnimator;
import com.f708.anothergunmod.client.animation.WeaponAnimatorFactory;
import com.f708.anothergunmod.client.animation.WeaponRenderContext;
import com.f708.anothergunmod.core.WeaponAnimationManager;
import com.f708.anothergunmod.core.interfaces.IMeleeGun;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WeaponAnimationHandler {
    private static boolean blocking = false;
    private static boolean playerAction;

    public static void handle(PoseStack poseStack, WeaponRenderContext context) {
        WeaponAnimationManager.WeaponAnimationData animData = WeaponAnimationManager.getAnimation(context.getPlayer(), context.getHand());
        WeaponAnimator animator = WeaponAnimatorFactory.getAnimator(context.getGunItem().weaponType(), context.isFirstPerson());
        if (context.getPlayer().isSprinting() && !context.getPlayer().isShiftKeyDown() || context.getPlayer().isSwimming() && context.getPlayer().isSprinting() || playerAction || AbstractGunItem.holdingInnaporatedItem(context.getPlayer())) {
            animator.applyRunningPose(poseStack, context.isLeftHand());
        } else if (((Boolean)context.getPlayer().getItemInHand(context.getHand()).getOrDefault(ModDataComponents.BLOCKED_ATTACK, (Object)false)).booleanValue()) {
            animator.applyBlockPose(poseStack, context.isLeftHand());
        } else if (((Boolean)context.getPlayer().getItemInHand(context.getHand()).getOrDefault(ModDataComponents.IS_SUPPORTED, (Object)false)).booleanValue() && context.getPlayer().getItemInHand(context.getHand()).getItem() instanceof IMeleeGun || context.getPlayer().getItemInHand(context.getHand()).is(ModItems.RIFLEWITHSPYGLASS.get()) && context.getPlayer().isShiftKeyDown()) {
            animator.applySupportedPose(poseStack, context.isLeftHand());
        } else {
            animator.applyDefaultPose(poseStack, context.isLeftHand());
        }
        if (animData != null) {
            WeaponAnimationHandler.applyAnimation(poseStack, animator, animData, context.isLeftHand());
        }
    }

    private static void applyAnimation(PoseStack poseStack, WeaponAnimator animator, WeaponAnimationManager.WeaponAnimationData data, boolean leftHand) {
        float progress = data.getProgress();
        switch (data.animationType) {
            case SHOOT: {
                animator.animateShoot(poseStack, progress, leftHand);
                break;
            }
            case RELOAD: {
                animator.animateReload(poseStack, progress, leftHand);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)data.animationType));
            }
        }
    }

    public static void setPlayerAction(boolean playerAction) {
        WeaponAnimationHandler.playerAction = playerAction;
    }
}

