/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation.body;

import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BodyAnimationContext {
    private final Player player;
    private final HumanoidModel<?> model;
    private final ItemStack mainHandItem;
    private final ItemStack offHandItem;
    private final AbstractGunItem mainGun;
    private final AbstractGunItem offGun;

    public BodyAnimationContext(Player player, HumanoidModel<?> model) {
        AbstractGunItem g;
        this.player = player;
        this.model = model;
        this.mainHandItem = player.getMainHandItem();
        this.offHandItem = player.getOffhandItem();
        Item item = this.mainHandItem.getItem();
        this.mainGun = item instanceof AbstractGunItem ? (g = (AbstractGunItem)item) : null;
        item = this.offHandItem.getItem();
        this.offGun = item instanceof AbstractGunItem ? (g = (AbstractGunItem)item) : null;
    }

    public boolean hasAnyWeapon() {
        return this.mainGun != null || this.offGun != null;
    }

    public boolean hasWeapon(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? this.mainGun != null : this.offGun != null;
    }

    public AbstractGunItem getGun(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? this.mainGun : this.offGun;
    }

    public ItemStack getItem(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? this.mainHandItem : this.offHandItem;
    }

    public Player getPlayer() {
        return this.player;
    }

    public HumanoidModel<?> getModel() {
        return this.model;
    }
}

