/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation.body;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;

public interface BodyAnimator {
    public void animateShoot(BodyParts var1, float var2);

    public void animateReload(BodyParts var1, float var2);

    public void applyHoldingPose(BodyParts var1);

    default public void applySupportedPose(BodyParts parts) {
    }

    default public void applyRunningPose(BodyParts parts) {
    }

    public void applyBlockingPose(BodyParts var1);

    public static class BodyParts {
        public final ModelPart head;
        public final ModelPart body;
        public final ModelPart rightArm;
        public final ModelPart leftArm;
        public final ModelPart rightLeg;
        public final ModelPart leftLeg;
        public final boolean isMainHand;

        public BodyParts(HumanoidModel<?> model, boolean isMainHand) {
            this.head = model.head;
            this.body = model.body;
            this.rightArm = model.rightArm;
            this.leftArm = model.leftArm;
            this.rightLeg = model.rightLeg;
            this.leftLeg = model.leftLeg;
            this.isMainHand = isMainHand;
        }

        public ModelPart getActiveArm() {
            return this.isMainHand ? this.rightArm : this.leftArm;
        }

        public ModelPart getInactiveArm() {
            return this.isMainHand ? this.leftArm : this.rightArm;
        }
    }
}

