/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation.body;

import com.f708.anothergunmod.client.animation.body.AutomaticGunsBodyAnimator;
import com.f708.anothergunmod.client.animation.body.BodyAnimator;
import com.f708.anothergunmod.client.animation.body.DefaultBodyAnimator;
import com.f708.anothergunmod.client.animation.body.FlameThrowerBodyAnimator;
import com.f708.anothergunmod.client.animation.body.RevolverBodyAnimator;
import com.f708.anothergunmod.client.animation.body.RifleBodyAnimator;
import com.f708.anothergunmod.client.animation.body.RifleSpyglassBodyAnimator;
import com.f708.anothergunmod.client.animation.body.ShotgunBodyAnimator;
import com.f708.anothergunmod.core.enums.WeaponType;
import java.util.HashMap;
import java.util.Map;

public class BodyAnimatorFactory {
    private static final Map<String, BodyAnimator> ANIMATORS = new HashMap<String, BodyAnimator>();
    private static final BodyAnimator DEFAULT_ANIMATOR = new DefaultBodyAnimator();

    public static BodyAnimator getAnimator(WeaponType type) {
        if (type == null) {
            System.err.println("WeaponType is null! Using default animator");
            return DEFAULT_ANIMATOR;
        }
        BodyAnimator animator = ANIMATORS.get(type.name());
        if (animator == null) {
            System.out.println("No animator found for weapon type: " + type.name() + ". Using default.");
            return DEFAULT_ANIMATOR;
        }
        return animator;
    }

    static {
        ANIMATORS.put("REVOLVER", new RevolverBodyAnimator());
        ANIMATORS.put("RIFLE", new RifleBodyAnimator());
        ANIMATORS.put("RIFLE_SPYGLASS", new RifleSpyglassBodyAnimator());
        ANIMATORS.put("SHOTGUN", new ShotgunBodyAnimator());
        ANIMATORS.put("AUTOGUN", new AutomaticGunsBodyAnimator());
        ANIMATORS.put("MACHINEGUN", new AutomaticGunsBodyAnimator());
        ANIMATORS.put("FLAMETHROWER", new FlameThrowerBodyAnimator());
    }
}

