/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation.body;

import com.f708.anothergunmod.client.animation.body.BodyAnimator;
import net.minecraft.client.model.geom.ModelPart;

public class RevolverBodyAnimator
implements BodyAnimator {
    @Override
    public void animateShoot(BodyAnimator.BodyParts parts, float progress) {
        ModelPart activeArm = parts.getActiveArm();
        float recoilAmount = (float)Math.sin(Math.PI * (double)progress) * 0.3f;
        activeArm.xRot -= recoilAmount;
        activeArm.zRot += recoilAmount * 0.5f;
    }

    @Override
    public void animateReload(BodyAnimator.BodyParts parts, float progress) {
        ModelPart activeArm = parts.getActiveArm();
        int sideSign = parts.isMainHand ? 1 : -1;
        float recoilUp = (float)Math.toRadians(Math.sin(Math.PI * (double)progress) * 15.0);
        float recoilSide = (float)Math.toRadians(Math.sin(Math.PI * (double)progress) * (double)sideSign * 15.0);
        activeArm.xRot -= recoilUp;
        activeArm.yRot += recoilSide;
    }

    @Override
    public void applyHoldingPose(BodyAnimator.BodyParts parts) {
        ModelPart activeArm = parts.getActiveArm();
        activeArm.yRot = parts.head.yRot * 0.9f;
        activeArm.xRot = parts.head.xRot - 1.5f;
    }

    @Override
    public void applyBlockingPose(BodyAnimator.BodyParts parts) {
    }
}

