/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.config;

import com.f708.anothergunmod.AnotherGunMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.fml.loading.FMLPaths;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("anothergunmod.json");
    private static ConfigData data = new ConfigData();

    public static int getRevolverDamage() {
        return ModConfig.data.revolver.damage;
    }

    public static int getRevolverReloadTime() {
        return ModConfig.data.revolver.reloadTime;
    }

    public static int getRevolverRecoil() {
        return ModConfig.data.revolver.recoil;
    }

    public static int getRevolverFireRate() {
        return ModConfig.data.revolver.fireRate;
    }

    public static int getRifleDamage() {
        return ModConfig.data.rifle.damage;
    }

    public static int getRifleReloadTime() {
        return ModConfig.data.rifle.reloadTime;
    }

    public static int getRifleRecoil() {
        return ModConfig.data.rifle.recoil;
    }

    public static int getRifleFireRate() {
        return ModConfig.data.rifle.fireRate;
    }

    public static int getRifleSpyglassDamage() {
        return ModConfig.data.rifleSpyglass.damage;
    }

    public static int getRifleSpyglassReloadTime() {
        return ModConfig.data.rifleSpyglass.reloadTime;
    }

    public static int getRifleSpyglassRecoil() {
        return ModConfig.data.rifleSpyglass.recoil;
    }

    public static int getRifleSpyglassFireRate() {
        return ModConfig.data.rifleSpyglass.fireRate;
    }

    public static int getShotgunDamage() {
        return ModConfig.data.shotgun.damage;
    }

    public static int getShotgunReloadTime() {
        return ModConfig.data.shotgun.reloadTime;
    }

    public static int getShotgunRecoil() {
        return ModConfig.data.shotgun.recoil;
    }

    public static int getShotgunFireRate() {
        return ModConfig.data.shotgun.fireRate;
    }

    public static int getShotgunPelletCount() {
        return ModConfig.data.shotgun.pelletCount;
    }

    public static int getAutogunDamage() {
        return ModConfig.data.autogun.damage;
    }

    public static int getAutogunReloadTime() {
        return ModConfig.data.autogun.reloadTime;
    }

    public static int getAutogunRecoil() {
        return ModConfig.data.autogun.recoil;
    }

    public static int getAutogunFireRate() {
        return ModConfig.data.autogun.fireRate;
    }

    public static int getMachinegunDamage() {
        return ModConfig.data.machinegun.damage;
    }

    public static int getMachinegunReloadTime() {
        return ModConfig.data.machinegun.reloadTime;
    }

    public static int getMachinegunRecoil() {
        return ModConfig.data.machinegun.recoil;
    }

    public static int getMachinegunFireRate() {
        return ModConfig.data.machinegun.fireRate;
    }

    public static int getFlamethrowerDamage() {
        return ModConfig.data.flamethrower.damage;
    }

    public static int getFlamethrowerReloadTime() {
        return ModConfig.data.flamethrower.reloadTime;
    }

    public static boolean getGunsAttractMobs() {
        return ModConfig.data.misc.gunsAttractMobs;
    }

    public static int getMagazineReloadTime() {
        return ModConfig.data.misc.magazineReloadTime;
    }

    public static int getDistantSoundRange() {
        return ModConfig.data.misc.distantSoundRange;
    }

    public static void load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                ConfigData loaded = (ConfigData)GSON.fromJson(json, ConfigData.class);
                if (loaded != null) {
                    data = loaded;
                } else {
                    AnotherGunMod.LOGGER.warn("Config file is empty, using defaults");
                    ModConfig.save();
                }
            } else {
                AnotherGunMod.LOGGER.info("Config file not found, creating default");
                ModConfig.save();
            }
            AnotherGunMod.LOGGER.info("Config loaded successfully from: {}", (Object)CONFIG_PATH);
        }
        catch (IOException e) {
            AnotherGunMod.LOGGER.error("Failed to load config", (Throwable)e);
            data = new ConfigData();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)data);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            AnotherGunMod.LOGGER.info("Config saved to: {}", (Object)CONFIG_PATH);
        }
        catch (IOException e) {
            AnotherGunMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static ConfigData getData() {
        return data;
    }

    public static void setData(ConfigData newData) {
        data = newData;
        ModConfig.save();
    }

    public static class ConfigData {
        public WeaponStats revolver = new WeaponStats(6, 15, 15, 15);
        public WeaponStats rifle = new WeaponStats(12, 20, 20, 25);
        public WeaponStats rifleSpyglass = new WeaponStats(16, 25, 30, 35);
        public WeaponStats shotgun = new WeaponStats(4, 16, 20, 20, 5);
        public WeaponStats autogun = new WeaponStats(4, 20, 5, 5);
        public WeaponStats machinegun = new WeaponStats(6, 24, 15, 3);
        public FlamethrowerStats flamethrower = new FlamethrowerStats(1, 20);
        public MiscStats misc = new MiscStats();
    }

    public static class WeaponStats {
        public int damage;
        public int reloadTime;
        public int recoil;
        public int fireRate;
        public int pelletCount = 1;

        public WeaponStats() {
        }

        public WeaponStats(int damage, int reloadTime, int recoil, int fireRate) {
            this.damage = damage;
            this.reloadTime = reloadTime;
            this.recoil = recoil;
            this.fireRate = fireRate;
        }

        public WeaponStats(int damage, int reloadTime, int recoil, int fireRate, int pelletCount) {
            this(damage, reloadTime, recoil, fireRate);
            this.pelletCount = pelletCount;
        }
    }

    public static class FlamethrowerStats {
        public int damage;
        public int reloadTime;

        public FlamethrowerStats() {
        }

        public FlamethrowerStats(int damage, int reloadTime) {
            this.damage = damage;
            this.reloadTime = reloadTime;
        }
    }

    public static class MiscStats {
        public boolean gunsAttractMobs = true;
        public int magazineReloadTime = 3;
        public int distantSoundRange = 64;
    }
}

