/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.core;

import com.f708.anothergunmod.core.enums.AmmoType;
import com.f708.anothergunmod.registry.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public final class AmmoContainer {
    private final List<ItemStack> ammo;
    private final int capacity;

    public AmmoContainer(int capacity) {
        this.ammo = new ArrayList<ItemStack>(capacity);
        this.capacity = capacity;
    }

    public AmmoContainer(int capacity, List<ItemStack> list) {
        this.ammo = list;
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public List<ItemStack> getAmmo() {
        return this.ammo;
    }

    public List<ItemStack> getBullets() {
        return this.ammo;
    }

    public boolean isFull() {
        return this.ammo.size() >= this.capacity;
    }

    public AmmoType peekAmmoType(int pos) {
        if (!this.ammo.get(pos).isEmpty()) {
            Item item = this.ammo.get(pos).getItem();
            if (item == ModItems.SMALLBULLET) {
                return AmmoType.BULLET;
            }
            if (item == ModItems.BIGBULLET) {
                return AmmoType.BIG_BULLET;
            }
            if (item == ModItems.SHELL) {
                return AmmoType.SHELL;
            }
            if (item == Items.BLAZE_ROD) {
                return AmmoType.BLAZEROD;
            }
        }
        return null;
    }

    public AmmoType peekAmmoType() {
        if (!this.ammo.getFirst().isEmpty()) {
            Item item = this.ammo.getFirst().getItem();
            if (item == ModItems.SMALLBULLET) {
                return AmmoType.BULLET;
            }
            if (item == ModItems.BIGBULLET) {
                return AmmoType.BIG_BULLET;
            }
            if (item == ModItems.SHELL) {
                return AmmoType.SHELL;
            }
            if (item == Items.BLAZE_ROD) {
                return AmmoType.BLAZEROD;
            }
        }
        return null;
    }

    public ItemStack peekAmmo(int pos) {
        return this.ammo.get(pos);
    }

    public ItemStack peekAmmo() {
        return this.ammo.getFirst();
    }

    public void addAmmo(ItemStack bullet) {
        this.ammo.addFirst(bullet);
    }

    public boolean isEmpty() {
        return this.ammo.isEmpty();
    }

    public int size() {
        return this.ammo.size();
    }
}

