/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.core;

import com.f708.anothergunmod.core.AmmoContainer;
import com.f708.anothergunmod.core.enums.AmmoType;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.ModItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public record AmmoContainerRecord(AmmoContainer container) {
    public static final Codec<AmmoContainerRecord> RECORD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ItemStack.OPTIONAL_CODEC).fieldOf("list").forGetter(AmmoContainerRecord::getList), (App)Codec.INT.fieldOf("capacity").forGetter(AmmoContainerRecord::getCapacity)).apply((Applicative)instance, (list, integer) -> new AmmoContainerRecord(new AmmoContainer((int)integer, (List<ItemStack>)list))));

    public List<ItemStack> getList() {
        return this.container.getBullets();
    }

    public int size() {
        return this.container.size();
    }

    public AmmoContainerRecord addNewBullet(ItemStack bullet) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>(this.container.getAmmo());
        if (newList.size() < this.container.getCapacity()) {
            ItemStack singleBullet = new ItemStack((ItemLike)bullet.getItem(), 1);
            newList.addFirst(singleBullet);
        }
        AmmoContainer newContainer = new AmmoContainer(this.container.getCapacity(), newList);
        return new AmmoContainerRecord(newContainer);
    }

    public AmmoContainerRecord addNewBullet(ItemStack bullet, int amount) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>(this.container.getAmmo());
        if (newList.size() < this.container.getCapacity()) {
            ItemStack singleBullet = new ItemStack((ItemLike)bullet.getItem(), 1);
            for (int i = 0; i < amount; ++i) {
                newList.addFirst(singleBullet);
            }
        }
        AmmoContainer newContainer = new AmmoContainer(this.container.getCapacity(), newList);
        return new AmmoContainerRecord(newContainer);
    }

    public AmmoContainerRecord removeBullet() {
        if (this.container.isEmpty()) {
            return this;
        }
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>(this.container.getAmmo());
        newList.remove(0);
        return new AmmoContainerRecord(new AmmoContainer(this.container.getCapacity(), newList));
    }

    public ItemStack getBullet(int num) {
        if (this.container.isEmpty()) {
            return new ItemStack((ItemLike)ModItems.SMALLBULLET.get());
        }
        return this.getList().get(num);
    }

    public AmmoType peekAmmoType(int num) {
        List<ItemStack> list = this.getList();
        ItemStack stack = list.getFirst();
        if (stack.is(ModItems.SMALLBULLET.get())) {
            return AmmoType.BULLET;
        }
        if (stack.is(ModItems.BIGBULLET.get())) {
            return AmmoType.BIG_BULLET;
        }
        if (stack.is(ModItems.SHELL.get())) {
            return AmmoType.SHELL;
        }
        if (stack.is(Items.BLAZE_ROD)) {
            return AmmoType.BLAZEROD;
        }
        return null;
    }

    public int getCapacity() {
        return this.container.getCapacity();
    }

    public boolean isFull() {
        return this.container.isFull();
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public AmmoContainerRecord clear() {
        return new AmmoContainerRecord(new AmmoContainer(this.getCapacity()));
    }

    public static AmmoContainerRecord getContainerFromComponent(ItemStack container) {
        return (AmmoContainerRecord)container.getOrDefault(ModDataComponents.AMMO_CONTAINER, (Object)new AmmoContainerRecord(new AmmoContainer(32)));
    }

    public static AmmoContainerRecord getBigContainerFromComponent(ItemStack container) {
        return (AmmoContainerRecord)container.getOrDefault(ModDataComponents.AMMO_CONTAINER, (Object)new AmmoContainerRecord(new AmmoContainer(64)));
    }

    public static void setContainerToComponent(ItemStack container, AmmoContainerRecord ammoContainerRecord) {
        container.set(ModDataComponents.AMMO_CONTAINER, (Object)ammoContainerRecord);
    }
}

