/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.core;

import com.f708.anothergunmod.core.enums.AnimationType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.events.game.WeaponReloadEvent;
import com.f708.anothergunmod.core.events.game.WeaponShootEvent;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="anothergunmod", value={Dist.CLIENT})
public class WeaponAnimationManager {
    private static final Map<UUID, EnumMap<InteractionHand, WeaponAnimationData>> playerAnimations = new HashMap<UUID, EnumMap<InteractionHand, WeaponAnimationData>>();

    private static EnumMap<InteractionHand, WeaponAnimationData> ensurePlayerMap(UUID uuid) {
        return playerAnimations.computeIfAbsent(uuid, u -> new EnumMap(InteractionHand.class));
    }

    public static void startAnimation(Player player, WeaponType weaponType, AnimationType animationType, int durationMs, Item weaponItem, InteractionHand hand) {
        if (player == null || hand == null) {
            return;
        }
        WeaponAnimationData animData = new WeaponAnimationData(durationMs, weaponType, animationType, weaponItem, player.getUUID(), hand);
        WeaponAnimationManager.ensurePlayerMap(player.getUUID()).put(hand, animData);
    }

    public static void startAnimation(Player player, WeaponType weaponType, AnimationType animationType, int durationMs, InteractionHand hand) {
        WeaponAnimationManager.startAnimation(player, weaponType, animationType, durationMs, null, hand);
    }

    public static WeaponAnimationData getAnimation(Player player, InteractionHand hand) {
        if (player == null || hand == null) {
            return null;
        }
        EnumMap<InteractionHand, WeaponAnimationData> map = playerAnimations.get(player.getUUID());
        if (map == null) {
            return null;
        }
        WeaponAnimationData data = map.get(hand);
        if (data != null && data.isFinished()) {
            map.remove(hand);
            if (map.isEmpty()) {
                playerAnimations.remove(player.getUUID());
            }
            return null;
        }
        return data;
    }

    private static void cleanup() {
        Iterator<Map.Entry<UUID, EnumMap<InteractionHand, WeaponAnimationData>>> it = playerAnimations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, EnumMap<InteractionHand, WeaponAnimationData>> e = it.next();
            e.getValue().entrySet().removeIf(en -> ((WeaponAnimationData)en.getValue()).isFinished());
            if (!e.getValue().isEmpty()) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        WeaponAnimationManager.cleanup();
    }

    public static class WeaponAnimationData {
        public long startTimeMs = System.currentTimeMillis();
        public int animationDurationMs;
        public boolean isAnimating;
        public WeaponType weaponType;
        public AnimationType animationType;
        public Item weaponItem;
        public UUID playerUUID;
        public InteractionHand hand;

        public WeaponAnimationData(int durationMs, WeaponType weaponType, AnimationType animationType, Item weaponItem, UUID playerUUID, InteractionHand hand) {
            this.animationDurationMs = durationMs;
            this.weaponType = weaponType;
            this.animationType = animationType;
            this.weaponItem = weaponItem;
            this.isAnimating = true;
            this.playerUUID = playerUUID;
            this.hand = hand;
        }

        public float getProgress() {
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - this.startTimeMs;
            if (elapsed >= (long)this.animationDurationMs) {
                this.isAnimating = false;
                return 1.0f;
            }
            return (float)elapsed / (float)this.animationDurationMs;
        }

        public boolean isFinished() {
            return !this.isAnimating || this.getProgress() >= 1.0f;
        }
    }

    @EventBusSubscriber(modid="anothergunmod", value={Dist.CLIENT})
    public static class WeaponEventAnimationHandler {
        @SubscribeEvent
        public static void onWeaponShoot(WeaponShootEvent event) {
            WeaponAnimationManager.startAnimation(event.getPlayer(), event.getWeaponType(), AnimationType.SHOOT, event.getAnimationDuration(), event.getHand());
        }

        @SubscribeEvent
        public static void onWeaponReload(WeaponReloadEvent event) {
            WeaponAnimationManager.startAnimation(event.getPlayer(), event.getWeaponType(), AnimationType.RELOAD, event.getAnimationDuration(), event.getHand());
        }
    }
}

