/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.core.events.core;

import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.core.WeaponAnimationManager;
import com.f708.anothergunmod.core.enums.AnimationType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.events.game.WeaponReloadEvent;
import com.f708.anothergunmod.core.events.game.WeaponShootEvent;
import com.f708.anothergunmod.data.ModDataAttachments;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.nami.MamiRifleData;
import com.f708.anothergunmod.nami.MamiRifleEntity;
import com.f708.anothergunmod.nami.MamiRifleItem;
import com.f708.anothergunmod.nami.MamiRifleLimit;
import com.f708.anothergunmod.nami.MamiRifleShootEvent;
import com.f708.anothergunmod.network.packets.C2S_PacketSendReloadAction;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.registry.item.custom.Revolver;
import com.f708.anothergunmod.registry.item.custom.mechanics.DualWieldRevolverState;
import com.f708.anothergunmod.registry.particle.ModParticleTypes;
import com.f708.anothergunmod.registry.particle.ammo.AmmoParticleBuilder;
import com.f708.anothergunmod.registry.particle.smoke.MuzzleSmokeEmitter;
import com.f708.anothergunmod.sounds.ModSounds;
import com.f708.anothergunmod.sounds.SoundUtil;
import com.f708.anothergunmod.utils.CameraUtils;
import com.f708.anothergunmod.utils.GunUtils;
import com.f708.anothergunmod.utils.TickScheduler;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="anothergunmod", value={Dist.CLIENT})
public class ClientEventHandler {
    private static final double NEAR_RADIUS = 64.0;
    public static final KeyMapping RELOAD_MAPPING = new KeyMapping("key.anothergunmod.reload", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 82, "key.categories.gameplay");

    @SubscribeEvent
    public static void onWeaponShoot(WeaponShootEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        double baseSpeed = 0.15;
        double fromEyes = 1.0;
        if (event.getWeaponType() == WeaponType.FLAMETHROWER) {
            GunUtils.spawnFlameParticles((Level)mc.level, (LivingEntity)event.getPlayer());
            if (event.player == mc.player) {
                CameraUtils.triggerCameraShake(5, 0.5f, 1, 1.0f);
            }
        } else {
            MuzzleSmokeEmitter.spawnBurst(event.getPlayer(), (ParticleOptions)ModParticleTypes.MUZZLE_SMOKE.get(), baseSpeed, fromEyes, event.getHand());
        }
        if (event.getWeaponType() != WeaponType.FLAMETHROWER && event.getWeaponType() != WeaponType.REVOLVER) {
            if (event.getWeaponType() == WeaponType.RIFLE || event.getWeaponType() == WeaponType.RIFLE_SPYGLASS) {
                TickScheduler.schedule(() -> AmmoParticleBuilder.spawn(event.player, event.getHand(), 1.0, (ParticleOptions)ModParticleTypes.CASING_BIG.get()), 13);
            } else if (event.getWeaponType() == WeaponType.SHOTGUN) {
                TickScheduler.schedule(() -> AmmoParticleBuilder.spawn(event.player, event.getHand(), 1.0, (ParticleOptions)ModParticleTypes.CASING_SHELL.get()), 8);
            } else {
                AmmoParticleBuilder.spawn(event.player, event.getHand(), 1.0, (ParticleOptions)ModParticleTypes.CASING_SMALL.get());
            }
        }
        WeaponAnimationManager.startAnimation(event.getPlayer(), event.getWeaponType(), AnimationType.SHOOT, event.getAnimationDuration(), event.getHand());
        Runnable work = () -> {
            LocalPlayer local = mc.player;
            Player shooter = event.getPlayer();
            if (local == shooter) {
                ClientEventHandler.playFirstPersonShoot(event);
            } else if (event.getWeaponType() != WeaponType.FLAMETHROWER) {
                ClientEventHandler.playThirdPersonShoot(mc, (Player)local, shooter, event);
            }
        };
        if (!mc.isSameThread()) {
            mc.execute(work);
        } else {
            work.run();
        }
    }

    @SubscribeEvent
    public static void onWeaponReload(WeaponReloadEvent event) {
        Revolver rev;
        ItemStack revolver;
        Item item;
        WeaponAnimationManager.startAnimation(event.getPlayer(), event.getWeaponType(), AnimationType.RELOAD, event.getAnimationDuration(), event.getHand());
        if (event.player == Minecraft.getInstance().player) {
            switch (event.getWeaponType()) {
                case REVOLVER: {
                    CameraUtils.triggerReloadSway(WeaponType.REVOLVER, event.getAnimationDuration() / 50);
                    break;
                }
                case RIFLE: 
                case RIFLE_SPYGLASS: {
                    CameraUtils.triggerReloadSway(WeaponType.RIFLE, event.getAnimationDuration() / 50);
                    break;
                }
                case SHOTGUN: {
                    CameraUtils.triggerReloadSway(WeaponType.SHOTGUN, event.getAnimationDuration() / 50);
                    break;
                }
                case AUTOGUN: {
                    CameraUtils.triggerReloadSway(WeaponType.AUTOGUN, event.getAnimationDuration() / 50);
                    break;
                }
                case MACHINEGUN: {
                    CameraUtils.triggerReloadSway(WeaponType.MACHINEGUN, event.getAnimationDuration() / 50);
                    break;
                }
                case FLAMETHROWER: {
                    CameraUtils.triggerReloadSway(WeaponType.FLAMETHROWER, event.getAnimationDuration() / 50);
                }
            }
        }
        if (event.getWeaponType() == WeaponType.REVOLVER && (item = (revolver = event.player.getItemInHand(event.getHand())).getItem()) instanceof Revolver && !(rev = (Revolver)item).gotEmptyAmmo(revolver)) {
            AmmoParticleBuilder.spawn(event.player, event.getHand(), 1.0, (ParticleOptions)ModParticleTypes.CASING_SMALL.get());
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer local = mc.player;
        if (local == null || mc.level == null) {
            return;
        }
        Runnable work = () -> ClientEventHandler.lambda$onWeaponReload$3(event, (Player)local, mc);
        if (!mc.isSameThread()) {
            mc.execute(work);
        } else {
            work.run();
        }
    }

    @SubscribeEvent
    public static void onFOVModifier(ComputeFovModifierEvent event) {
        ItemStack useItem;
        Player player = event.getPlayer();
        if (((Boolean)player.getData(ModDataAttachments.SCOPING.get())).booleanValue()) {
            event.setNewFovModifier(0.1f);
        }
        if (player.isUsingItem() && (useItem = player.getUseItem()).is(ModItems.FLAMETHROWER.get())) {
            event.setNewFovModifier(1.3f);
        }
    }

    @SubscribeEvent
    private static void onSpyglassZoom(CalculatePlayerTurnEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        event.setCinematicCameraEnabled(((Boolean)player.getData(ModDataAttachments.SCOPING.get())).booleanValue());
    }

    private static void playFirstPersonShoot(WeaponShootEvent event) {
        Player player = event.getPlayer();
        switch (event.getWeaponType()) {
            case REVOLVER: {
                SoundUtil.playFirstPerson(ModSounds.REVOLVER_SHOOT.get(), 0.5f, SoundUtil.randPitch(0.9f, 1.1f));
                break;
            }
            case RIFLE: 
            case RIFLE_SPYGLASS: {
                SoundUtil.playFirstPerson(ModSounds.RIFLE_SHOT.get(), 0.5f, SoundUtil.randPitch(0.9f, 1.1f));
                TickScheduler.schedule(() -> SoundUtil.playFirstPerson(ModSounds.RIFLE_AFTERSHOT.get(), 0.5f, 1.0f), 4);
                break;
            }
            case SHOTGUN: {
                SoundUtil.playFirstPerson(ModSounds.SHOTGUN_SHOT.get(), 0.5f, 1.0f);
                TickScheduler.schedule(() -> SoundUtil.playFirstPerson(ModSounds.SHOTGUN_RELOAD.get(), 0.5f, SoundUtil.randPitch(0.9f, 1.1f)), 5);
                break;
            }
            case AUTOGUN: {
                SoundUtil.playFirstPerson(ModSounds.AUTOGUN_SHOT.get(), 0.5f, SoundUtil.randPitch(0.9f, 1.1f));
                break;
            }
            case MACHINEGUN: {
                SoundUtil.playFirstPerson(ModSounds.MACHINEGUN_SHOT.get(), 0.5f, SoundUtil.randPitch(0.9f, 1.1f));
                break;
            }
            case FLAMETHROWER: {
                if (player.isEyeInFluidType(Fluids.WATER.getFluidType())) {
                    SoundUtil.playFirstPerson(SoundEvents.BUBBLE_COLUMN_UPWARDS_INSIDE, 0.3f, SoundUtil.randPitch(0.9f, 1.1f));
                    break;
                }
                SoundUtil.playFirstPerson(ModSounds.FLAMETHROWER_SHOOT.get(), 1.0f, SoundUtil.randPitch(0.9f, 1.1f));
            }
        }
    }

    private static void playThirdPersonShoot(Minecraft mc, Player listener, Player shooter, WeaponShootEvent event) {
        double d2 = listener.distanceToSqr((Entity)shooter);
        double FAR_START = ModConfig.getDistantSoundRange();
        double FAR_END = ModConfig.getDistantSoundRange() * 2;
        if (d2 <= 4096.0) {
            SoundEvent near = switch (event.getWeaponType()) {
                default -> throw new MatchException(null, null);
                case WeaponType.REVOLVER -> ModSounds.REVOLVER_SHOOT.get();
                case WeaponType.RIFLE, WeaponType.RIFLE_SPYGLASS -> {
                    SoundUtil.playFirstPerson(ModSounds.RIFLE_AFTERSHOT.get(), 0.5f, 1.0f);
                    yield ModSounds.RIFLE_SHOT.get();
                }
                case WeaponType.SHOTGUN -> ModSounds.SHOTGUN_SHOT.get();
                case WeaponType.AUTOGUN -> ModSounds.AUTOGUN_SHOT.get();
                case WeaponType.MACHINEGUN -> ModSounds.MACHINEGUN_SHOT.get();
                case WeaponType.FLAMETHROWER -> shooter.isEyeInFluidType(Fluids.WATER.getFluidType()) ? SoundEvents.BUBBLE_COLUMN_UPWARDS_INSIDE : ModSounds.FLAMETHROWER_SHOOT.get();
            };
            float vol = SoundUtil.fadeByDistanceSqr(d2, 0.0, 4096.0);
            SoundUtil.playAtPlayer3D(mc, shooter, near, Math.max(0.1f, vol), 1.0f);
            if (event.getWeaponType() == WeaponType.SHOTGUN) {
                TickScheduler.schedule(() -> SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.SHOTGUN_RELOAD.get(), Math.max(0.1f, vol), SoundUtil.randPitch(0.9f, 1.1f)), 5);
            }
            return;
        }
        if (d2 <= FAR_END * FAR_END) {
            float vol = SoundUtil.fadeByDistanceSqr(d2, FAR_START * FAR_START, FAR_END * FAR_END);
            mc.level.playLocalSound(shooter.getX(), shooter.getY(), shooter.getZ(), ModSounds.FAR_GUN_SHOT.get(), SoundSource.PLAYERS, Math.max(0.1f, vol), 1.0f, false);
        }
    }

    private static void runLightEvent(WeaponShootEvent event) {
        Player player = event.getPlayer();
        BlockPos pos = player.blockPosition().offset(0, 1, 0);
        BlockState blockState = player.level().getBlockState(pos);
        LocalPlayer client = Minecraft.getInstance().player;
        if (player.level().getBlockState(pos).isEmpty()) {
            client.level().setBlock(pos, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15)), 0);
            TickScheduler.scheduleClient(() -> ClientEventHandler.lambda$runLightEvent$7((Player)client, pos, blockState), 1);
        }
    }

    private static void playFirstPersonReload(WeaponReloadEvent event) {
        switch (event.getWeaponType()) {
            case REVOLVER: {
                TickScheduler.schedule(() -> SoundUtil.playFirstPerson(ModSounds.REVOLVER_SPIN.get(), 0.5f, 0.6f), 0);
                TickScheduler.schedule(() -> SoundUtil.playFirstPerson(ModSounds.REVOLVER_SPIN.get(), 0.5f, 0.6f), 3);
                TickScheduler.schedule(() -> SoundUtil.playFirstPerson(ModSounds.REVOLVER_SPIN.get(), 0.5f, 0.6f), 6);
                TickScheduler.schedule(() -> SoundUtil.playFirstPerson(ModSounds.REVOLVER_SPIN.get(), 0.5f, 0.6f), 9);
                break;
            }
            case RIFLE: 
            case RIFLE_SPYGLASS: {
                TickScheduler.schedule(() -> SoundUtil.playFirstPerson(ModSounds.RIFLE_INSERT.get(), 0.5f, 1.0f), 5);
                break;
            }
            case SHOTGUN: {
                TickScheduler.schedule(() -> SoundUtil.playFirstPerson(ModSounds.SHOTGUN_INSERT.get(), 0.5f, SoundUtil.randPitch(0.9f, 1.1f)), 1);
                break;
            }
            case AUTOGUN: 
            case MACHINEGUN: {
                SoundUtil.playFirstPerson(ModSounds.MAGAZINE_RELOAD.get(), 0.5f, SoundUtil.randPitch(0.9f, 1.1f));
                break;
            }
            case FLAMETHROWER: {
                SoundUtil.playFirstPerson(ModSounds.FLAMETHROWER_RELOAD.get(), 0.2f, SoundUtil.randPitch(0.9f, 1.1f));
            }
        }
    }

    private static void playReloadForOthers(Minecraft mc, Player listener, Player shooter, WeaponReloadEvent event) {
        double d2 = listener.distanceToSqr((Entity)shooter);
        double R1 = 8.0;
        double R2 = 16.0;
        float vol = SoundUtil.fadeByDistanceSqr(d2, 64.0, 256.0);
        if (vol <= 0.0f) {
            return;
        }
        switch (event.getWeaponType()) {
            case REVOLVER: {
                TickScheduler.schedule(() -> SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.REVOLVER_SPIN.get(), vol, 0.6f), 0);
                TickScheduler.schedule(() -> SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.REVOLVER_SPIN.get(), vol, 0.6f), 3);
                TickScheduler.schedule(() -> SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.REVOLVER_SPIN.get(), vol, 0.6f), 6);
                TickScheduler.schedule(() -> SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.REVOLVER_SPIN.get(), vol, 0.6f), 9);
                break;
            }
            case RIFLE: 
            case RIFLE_SPYGLASS: {
                TickScheduler.schedule(() -> SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.RIFLE_AFTERSHOT.get(), vol, 1.0f), 4);
                TickScheduler.schedule(() -> SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.RIFLE_INSERT.get(), vol, 1.0f), 5);
                break;
            }
            case SHOTGUN: {
                TickScheduler.schedule(() -> SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.SHOTGUN_INSERT.get(), vol, SoundUtil.randPitch(0.9f, 1.1f)), 1);
                break;
            }
            case AUTOGUN: 
            case MACHINEGUN: {
                SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.MAGAZINE_RELOAD.get(), vol, SoundUtil.randPitch(0.9f, 1.1f));
                break;
            }
            case FLAMETHROWER: {
                SoundUtil.playAtPlayer3D(mc, shooter, ModSounds.FLAMETHROWER_RELOAD.get(), 0.2f, SoundUtil.randPitch(0.9f, 1.1f));
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        while (RELOAD_MAPPING.consumeClick()) {
            AbstractGunItem og;
            AbstractGunItem mg;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) continue;
            ItemStack main = player.getMainHandItem();
            ItemStack off = player.getOffhandItem();
            boolean mainIsGun = main.getItem() instanceof AbstractGunItem;
            boolean offIsGun = off.getItem() instanceof AbstractGunItem;
            if (!mainIsGun && !offIsGun) continue;
            Item item = main.getItem();
            boolean bothRevolvers = item instanceof AbstractGunItem && (mg = (AbstractGunItem)item).weaponType() == WeaponType.REVOLVER && (item = off.getItem()) instanceof AbstractGunItem && (og = (AbstractGunItem)item).weaponType() == WeaponType.REVOLVER;
            InteractionHand hand = null;
            if (bothRevolvers) {
                hand = DualWieldRevolverState.pickHandToReload((Player)player, main, off);
                if (hand == null) {
                    hand = DualWieldRevolverState.getNextReloadHand((Player)player) == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                }
            } else {
                InteractionHand other;
                AbstractGunItem ag;
                hand = mainIsGun ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                ItemStack gun = player.getItemInHand(hand);
                Item item2 = gun.getItem();
                if (item2 instanceof AbstractGunItem && (ag = (AbstractGunItem)item2).weaponType() != WeaponType.REVOLVER && !player.getItemInHand(other = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND).isEmpty()) continue;
            }
            if (hand == null) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new C2S_PacketSendReloadAction(hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static boolean canReload(Player player, InteractionHand hand) {
        ItemStack gun = player.getItemInHand(hand);
        Item item = gun.getItem();
        if (!(item instanceof AbstractGunItem)) {
            return false;
        }
        AbstractGunItem ag = (AbstractGunItem)item;
        if (player.getCooldowns().isOnCooldown(gun.getItem())) {
            return false;
        }
        WeaponType type = ag.weaponType();
        switch (type) {
            case REVOLVER: {
                return !ag.isMaxAmmo(gun) && GunUtils.containItem(player, ModItems.SMALLBULLET.get());
            }
            case RIFLE: {
                return !ag.isMaxAmmo(gun) && GunUtils.containItem(player, ModItems.BIGBULLET.get());
            }
            case SHOTGUN: {
                return !ag.isMaxAmmo(gun) && GunUtils.containItem(player, ModItems.SHELL.get());
            }
            case AUTOGUN: 
            case MACHINEGUN: {
                if (ag.magazineAttached(gun)) {
                    return true;
                }
                return GunUtils.containItem(player, ModItems.SMALL_MAGAZINE.get());
            }
            case FLAMETHROWER: {
                return !ag.isMaxAmmo(gun) && GunUtils.containItem(player, Items.BLAZE_ROD);
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onMamiRifleShoot(MamiRifleShootEvent event) {
        boolean playSound;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        MamiRifleEntity rifle = event.getRifle();
        Player owner = event.getPlayer();
        ItemStack weaponStack = owner.getMainHandItem();
        if (!(weaponStack.getItem() instanceof MamiRifleItem)) {
            return;
        }
        String limitStr = (String)weaponStack.getOrDefault(ModDataComponents.MAMI_LIMIT, (Object)"TEN");
        MamiRifleLimit limit = MamiRifleLimit.valueOf(limitStr);
        MamiRifleData data = (MamiRifleData)owner.getData(ModDataAttachments.MAMI_RIFLES.get());
        ++data.clientShotCounter;
        int soundInterval = limit.getSoundInterval();
        int particleCount = limit.getParticleCount();
        boolean bl = playSound = data.clientShotCounter % soundInterval == 0;
        if (particleCount > 0) {
            ClientEventHandler.spawnMuzzleParticles(mc, rifle, particleCount);
        }
        if (playSound) {
            Vec3 direction = rifle.getLookAngle();
            TickScheduler.schedule(() -> AmmoParticleBuilder.spawnFromEntity(rifle, direction, (ParticleOptions)ModParticleTypes.CASING_BIG.get()), 2);
            ClientEventHandler.playMamiRifleSound(mc, owner, rifle);
        }
    }

    private static void spawnMuzzleParticles(Minecraft mc, MamiRifleEntity rifle, int count) {
        Vec3 muzzlePos = rifle.position();
        Vec3 direction = rifle.getLookAngle();
        for (int i = 0; i < count; ++i) {
            double offsetX = direction.x * 0.5 + (mc.level.random.nextDouble() - 0.5) * 0.2;
            double offsetY = direction.y * 0.5 + (mc.level.random.nextDouble() - 0.5) * 0.2;
            double offsetZ = direction.z * 0.5 + (mc.level.random.nextDouble() - 0.5) * 0.2;
            mc.level.addParticle((ParticleOptions)ModParticleTypes.MUZZLE_SMOKE.get(), muzzlePos.x + offsetX, muzzlePos.y + offsetY, muzzlePos.z + offsetZ, direction.x * 0.1, direction.y * 0.1, direction.z * 0.1);
        }
    }

    private static void playMamiRifleSound(Minecraft mc, Player owner, MamiRifleEntity rifle) {
        LocalPlayer local = mc.player;
        if (local == null) {
            return;
        }
        double d2 = local.distanceToSqr(rifle.position());
        if (d2 <= 4096.0) {
            float vol = SoundUtil.fadeByDistanceSqr(d2, 0.0, 4096.0);
            mc.level.playLocalSound(rifle.getX(), rifle.getY(), rifle.getZ(), ModSounds.RIFLE_SHOT.get(), SoundSource.PLAYERS, Math.max(0.1f, vol * 0.5f), SoundUtil.randPitch(0.9f, 1.1f), false);
        } else {
            double FAR_START = ModConfig.getDistantSoundRange();
            double FAR_END = ModConfig.getDistantSoundRange() * 2;
            if (d2 <= FAR_END * FAR_END) {
                float vol = SoundUtil.fadeByDistanceSqr(d2, FAR_START * FAR_START, FAR_END * FAR_END);
                mc.level.playLocalSound(rifle.getX(), rifle.getY(), rifle.getZ(), ModSounds.FAR_GUN_SHOT.get(), SoundSource.PLAYERS, Math.max(0.1f, vol), 1.0f, false);
            }
        }
    }

    @SubscribeEvent
    public static void cancelLeftClick(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (event.isAttack() && player != null) {
            for (InteractionHand hand : InteractionHand.values()) {
                Item item = player.getItemInHand(hand).getItem();
                if (!(item instanceof AbstractGunItem)) continue;
                AbstractGunItem abstractGunItem = (AbstractGunItem)item;
                if (!player.getCooldowns().isOnCooldown((Item)abstractGunItem) && !player.isSprinting() && abstractGunItem.weaponType() != WeaponType.FLAMETHROWER) continue;
                event.setCanceled(true);
                event.setSwingHand(false);
            }
        }
    }

    private static /* synthetic */ void lambda$runLightEvent$7(Player client, BlockPos pos, BlockState blockState) {
        client.level().setBlock(pos, blockState, 0);
    }

    private static /* synthetic */ void lambda$onWeaponReload$3(WeaponReloadEvent event, Player local, Minecraft mc) {
        Player shooter = event.getPlayer();
        if (local == shooter) {
            ClientEventHandler.playFirstPersonReload(event);
        } else {
            ClientEventHandler.playReloadForOthers(mc, local, shooter, event);
        }
    }
}

