/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.core.events.core;

import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.nami.MamiRifleItem;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="anothergunmod")
public class ServerEventHandler {
    @SubscribeEvent
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof MamiRifleItem)) {
            return;
        }
        String formation = (String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE");
        if (formation.equals("CIRCLE")) {
            return;
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        String newName = event.getName();
        if (!(left.getItem() instanceof AbstractGunItem)) {
            return;
        }
        if (newName == null || newName.isEmpty() || !right.isEmpty()) {
            return;
        }
        ItemStack result = left.copy();
        int kills = (Integer)result.getOrDefault(ModDataComponents.KILL_COUNTER, (Object)0);
        ChatFormatting color = ServerEventHandler.getColorByKills(kills);
        MutableComponent formattedName = Component.literal((String)newName).withStyle(color);
        if (kills >= 1000) {
            formattedName = formattedName.copy().withStyle(ChatFormatting.BOLD);
        }
        result.set(DataComponents.CUSTOM_NAME, (Object)formattedName);
        event.setOutput(result);
        event.setCost((long)ServerEventHandler.costMultupler(kills));
        event.setMaterialCost(0);
    }

    private static ChatFormatting getColorByKills(int kills) {
        if (kills >= 1000) {
            return ChatFormatting.RED;
        }
        if (kills >= 500) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (kills >= 100) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.WHITE;
    }

    private static int costMultupler(int kills) {
        if (kills >= 1000) {
            return 30;
        }
        if (kills >= 500) {
            return 15;
        }
        if (kills >= 100) {
            return 5;
        }
        return 1;
    }
}

