/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.core.events.game;

import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.events.game.WeaponEvent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="anothergunmod")
public class WeaponShootEvent
extends WeaponEvent {
    public WeaponShootEvent(Player player, WeaponType weaponType, InteractionHand hand) {
        super(player, weaponType, hand);
    }

    @Override
    public WeaponType getWeaponType() {
        return super.getWeaponType();
    }

    public int getAnimationDuration() {
        return switch (this.getWeaponType()) {
            default -> throw new MatchException(null, null);
            case WeaponType.REVOLVER -> 750;
            case WeaponType.RIFLE -> 1250;
            case WeaponType.RIFLE_SPYGLASS -> 1750;
            case WeaponType.SHOTGUN -> 1000;
            case WeaponType.AUTOGUN -> 250;
            case WeaponType.MACHINEGUN, WeaponType.FLAMETHROWER -> 150;
        };
    }

    @SubscribeEvent
    public static void messageMobs(WeaponShootEvent event) {
        if (!ModConfig.getGunsAttractMobs()) {
            return;
        }
        Player player = event.getPlayer();
        if (player != null) {
            final BlockPos pos = player.blockPosition();
            AABB hitboxOfSound = new AABB(player.getX() - 20.0, player.getY() - 20.0, player.getZ() - 20.0, player.getX() + 20.0, player.getY() + 20.0, player.getZ() + 20.0);
            List monsterList = player.level().getEntitiesOfClass(Monster.class, hitboxOfSound);
            for (Monster monster : monsterList) {
                double distance = monster.blockPosition().distSqr((Vec3i)pos);
                int searchRange = (int)Math.sqrt(distance) + 7;
                MoveToBlockGoal existingGoal = null;
                for (WrappedGoal g : monster.goalSelector.getAvailableGoals()) {
                    MoveToBlockGoal mtbg;
                    Goal goal = g.getGoal();
                    if (!(goal instanceof MoveToBlockGoal)) continue;
                    existingGoal = mtbg = (MoveToBlockGoal)goal;
                    break;
                }
                if (existingGoal == null) {
                    monster.goalSelector.addGoal(3, (Goal)new MoveToBlockGoal((PathfinderMob)monster, 0.9, searchRange){

                        protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
                            return blockPos.distSqr((Vec3i)pos) <= 9.0;
                        }

                        public boolean canContinueToUse() {
                            double distanceToTarget = this.mob.blockPosition().distSqr((Vec3i)pos);
                            if (distanceToTarget <= 16.0) {
                                return false;
                            }
                            return super.canContinueToUse();
                        }

                        public double acceptedDistance() {
                            return 3.0;
                        }
                    });
                    continue;
                }
                monster.getNavigation().moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.9);
            }
        }
    }
}

