/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.nami.MamiRifleEntity;
import com.f708.anothergunmod.nami.MamiRifleShootEvent;
import com.f708.anothergunmod.nami.S2C_MamiRifleBatchShootPacket;
import com.f708.anothergunmod.nami.S2C_MamiRifleShootPacket;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class MamiEventSynchronizer {
    public static void syncShootEvent(MamiRifleShootEvent event, double radius) {
        Player sourcePlayer = event.getPlayer();
        MamiRifleEntity rifle = event.getRifle();
        Level level = sourcePlayer.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UUID uuid = sourcePlayer.getUUID();
            S2C_MamiRifleShootPacket packet = new S2C_MamiRifleShootPacket(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), rifle.getId());
            for (ServerPlayer nearbyPlayer : serverLevel.players()) {
                if (!(nearbyPlayer.distanceToSqr(rifle.position()) <= radius * radius)) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)nearbyPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void syncBatchShootEvent(Player owner, List<MamiRifleEntity> rifles, double radius) {
        Level level;
        if (rifles.isEmpty() || !((level = owner.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int[] rifleIds = rifles.stream().mapToInt(Entity::getId).toArray();
        UUID uuid = owner.getUUID();
        S2C_MamiRifleBatchShootPacket packet = new S2C_MamiRifleBatchShootPacket(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), rifleIds);
        Vec3 centerPos = rifles.get(0).position();
        for (ServerPlayer nearbyPlayer : serverLevel.players()) {
            if (!(nearbyPlayer.distanceToSqr(centerPos) <= radius * radius)) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)nearbyPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

