/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.nami.C2S_MamiConfigPacket;
import com.f708.anothergunmod.nami.MamiFormation;
import com.f708.anothergunmod.nami.MamiRifleLimit;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class MamiRifleConfigScreen
extends Screen {
    private static final int BUTTON_WIDTH = 120;
    private static final int BUTTON_HEIGHT = 20;
    private final ItemStack stack;
    private MamiFormation selectedFormation;
    private MamiRifleLimit selectedLimit;

    public MamiRifleConfigScreen(ItemStack stack) {
        super((Component)Component.translatable((String)"gui.anothergunmod.mami_config"));
        this.stack = stack;
        this.selectedFormation = MamiFormation.valueOf((String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE"));
        this.selectedLimit = MamiRifleLimit.valueOf((String)stack.getOrDefault(ModDataComponents.MAMI_LIMIT, (Object)"TEN"));
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int startY = this.height / 2 - 80;
        int formationX = centerX - 120 - 5;
        this.addFormationButton(formationX, startY, MamiFormation.CIRCLE);
        this.addFormationButton(formationX, startY + 25, MamiFormation.LINE_BACK);
        this.addFormationButton(formationX, startY + 50, MamiFormation.SIDES);
        this.addFormationButton(formationX, startY + 75, MamiFormation.GATE_OF_BABYLON);
        int limitX = centerX + 5;
        this.addLimitButton(limitX, startY, MamiRifleLimit.TEN, false);
        this.addLimitButton(limitX, startY + 25, MamiRifleLimit.TWENTY, false);
        this.addLimitButton(limitX, startY + 50, MamiRifleLimit.FIFTY, false);
        this.addLimitButton(limitX, startY + 75, MamiRifleLimit.HUNDRED, true);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), btn -> this.onClose()).bounds(centerX - 50, this.height - 30, 100, 20).build());
    }

    private void addFormationButton(int x, int y, MamiFormation formation) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)("gui.anothergunmod.formation." + formation.name().toLowerCase())), btn -> {
            this.selectedFormation = formation;
            this.syncToServer();
        }).bounds(x, y, 120, 20).build());
    }

    private void addLimitButton(int x, int y, MamiRifleLimit limit, boolean laggy) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)String.valueOf(limit.getCount() + (laggy ? " (LAGGY)" : ""))), btn -> {
            this.selectedLimit = limit;
            this.syncToServer();
        }).bounds(x, y, 120, 20).build());
    }

    private void syncToServer() {
        PacketDistributor.sendToServer((CustomPacketPayload)new C2S_MamiConfigPacket(this.selectedFormation, this.selectedLimit), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        int centerX = this.width / 2;
        int titleY = this.height / 2 - 100;
        graphics.drawCenteredString(this.font, this.title, centerX, titleY, -1);
        this.highlightSelected(graphics, centerX, this.height / 2 - 80);
    }

    private void highlightSelected(GuiGraphics graphics, int centerX, int startY) {
        int formationIndex = this.selectedFormation.ordinal();
        int formationX = centerX - 120 - 5;
        int formationY = startY + formationIndex * 25;
        graphics.fill(formationX - 2, formationY - 2, formationX + 120 + 2, formationY + 20 + 2, -2136342273);
        int limitIndex = this.selectedLimit.ordinal();
        int limitX = centerX + 5;
        int limitY = startY + limitIndex * 25;
        graphics.fill(limitX - 2, limitY - 2, limitX + 120 + 2, limitY + 20 + 2, -2136342273);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

