/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.core.enums.BulletType;
import com.f708.anothergunmod.data.ModDataAttachments;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.nami.FormationStrategy;
import com.f708.anothergunmod.nami.MamiEventSynchronizer;
import com.f708.anothergunmod.nami.MamiFormation;
import com.f708.anothergunmod.nami.MamiRifleData;
import com.f708.anothergunmod.nami.MamiRifleItem;
import com.f708.anothergunmod.nami.MamiRifleShootEvent;
import com.f708.anothergunmod.registry.entity.ModEntities;
import com.f708.anothergunmod.registry.entity.bullet.BulletBuilder;
import com.f708.anothergunmod.registry.item.ModItems;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MamiRifleEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(MamiRifleEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> INDEX = SynchedEntityData.defineId(MamiRifleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPAWN_TICKS = SynchedEntityData.defineId(MamiRifleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHOOT_DELAY = SynchedEntityData.defineId(MamiRifleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SHOULD_SHOOT = SynchedEntityData.defineId(MamiRifleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_MASS_SHOOT = SynchedEntityData.defineId(MamiRifleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Vec3 targetPos = null;
    private int recoilTicks = 0;
    private static final int MAX_LIFETIME = 6000;
    private int lifetime = 0;
    private int spawnTicks;
    private static final int MAX_SPAWN_TICKS = 10;

    public MamiRifleEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.spawnTicks = 0;
    }

    public MamiRifleEntity(Level level, Player owner, int index, int totalCount) {
        this(ModEntities.MAMI_RIFLE.get(), level);
        this.setOwner(owner.getUUID());
        this.entityData.set(INDEX, (Object)index);
        ItemStack stack = owner.getMainHandItem();
        MamiFormation formation = MamiFormation.valueOf((String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE"));
        Vec3 spawnPos = FormationStrategy.getPosition(formation, owner, index, totalCount);
        this.setPos(spawnPos);
        this.spawnTicks = 0;
    }

    public void setOwner(UUID uuid) {
        this.entityData.set(OWNER_UUID, Optional.of(uuid));
    }

    public int getIndex() {
        return (Integer)this.entityData.get(INDEX);
    }

    public int getSpawnTicks() {
        return (Integer)this.entityData.get(SPAWN_TICKS);
    }

    public int getRecoilTicks() {
        return this.recoilTicks;
    }

    public void tick() {
        super.tick();
        if (this.getBlockStateOn().isSuffocating((BlockGetter)this.level(), this.getOnPos())) {
            this.discard();
            return;
        }
        if (this.spawnTicks < 10) {
            ++this.spawnTicks;
        }
        if (!this.level().isClientSide) {
            ++this.lifetime;
            if ((Integer)this.entityData.get(SPAWN_TICKS) < 5) {
                this.entityData.set(SPAWN_TICKS, (Object)((Integer)this.entityData.get(SPAWN_TICKS) + 1));
            }
            Player owner = this.getOwnerPlayer();
            if (this.lifetime > 6000 || !this.isOwnerValid(owner)) {
                this.destroy(false);
                return;
            }
            this.updatePosition(owner);
            if (((Boolean)this.entityData.get(SHOULD_SHOOT)).booleanValue()) {
                int delay = (Integer)this.entityData.get(SHOOT_DELAY);
                if (delay > 0) {
                    this.entityData.set(SHOOT_DELAY, (Object)(delay - 1));
                    this.updateRotationToTarget(delay);
                } else {
                    this.performShoot(owner);
                }
            }
            if (this.recoilTicks > 0) {
                --this.recoilTicks;
            }
        } else {
            this.spawnParticles();
        }
    }

    public boolean isSpawned() {
        return (Integer)this.entityData.get(SPAWN_TICKS) >= 5;
    }

    public float getSpawnProgress(float partialTick) {
        float currentTicks = (float)this.spawnTicks + partialTick;
        float progress = currentTicks / 10.0f;
        return Math.min(progress, 1.0f);
    }

    public Player getOwnerPlayer() {
        Optional uuid = (Optional)this.entityData.get(OWNER_UUID);
        if (uuid.isEmpty()) {
            return null;
        }
        return this.level().getPlayerByUUID((UUID)uuid.get());
    }

    private boolean isOwnerValid(Player owner) {
        if (owner == null || !owner.isAlive()) {
            return false;
        }
        ItemStack mainHand = owner.getMainHandItem();
        if (!(mainHand.getItem() instanceof MamiRifleItem)) {
            return false;
        }
        MamiRifleData data = (MamiRifleData)owner.getData(ModDataAttachments.MAMI_RIFLES.get());
        return data.riflesByIndex.containsValue(this.getId());
    }

    private void updatePosition(Player owner) {
        if (owner == null) {
            return;
        }
        ItemStack stack = owner.getMainHandItem();
        MamiFormation formation = MamiFormation.valueOf((String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE"));
        MamiRifleData data = (MamiRifleData)owner.getData(ModDataAttachments.MAMI_RIFLES.get());
        int totalCount = data.riflesByIndex.size();
        Vec3 target = FormationStrategy.getPosition(formation, owner, this.getIndex(), totalCount);
        float lerpSpeed = (Integer)this.entityData.get(SPAWN_TICKS) < 5 ? 0.15f : 0.3f;
        this.setPos(this.position().lerp(target, (double)lerpSpeed));
        if (!((Boolean)this.entityData.get(SHOULD_SHOOT)).booleanValue()) {
            this.updateRotationDefault(owner);
        }
    }

    private void updateRotationDefault(Player owner) {
        Vec3 direction;
        ItemStack stack = owner.getMainHandItem();
        MamiFormation formation = MamiFormation.valueOf((String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE"));
        if (formation == MamiFormation.GATE_OF_BABYLON) {
            Vec3 direction2 = owner.getLookAngle();
            float yaw = (float)Math.toDegrees(Math.atan2(direction2.z, direction2.x)) - 90.0f;
            float pitch = (float)Math.toDegrees(Math.asin(-direction2.y));
            this.setYRot(yaw);
            this.setXRot(pitch);
            return;
        }
        Vec3 targetPos = this.calculateTargetPos(owner);
        int totalRifles = ((MamiRifleData)owner.getData(ModDataAttachments.MAMI_RIFLES.get())).riflesByIndex.size();
        if (totalRifles < 5) {
            direction = targetPos.subtract(this.position()).normalize();
        } else if (totalRifles <= 10) {
            float t = (float)(totalRifles - 5) / 5.0f;
            Vec3 toTarget = targetPos.subtract(this.position()).normalize();
            Vec3 parallel = owner.getLookAngle();
            direction = toTarget.lerp(parallel, (double)t);
        } else {
            direction = owner.getLookAngle();
        }
        float yaw = (float)Math.toDegrees(Math.atan2(direction.z, direction.x)) - 90.0f;
        float pitch = (float)Math.toDegrees(Math.asin(-direction.y));
        this.setYRot(yaw);
        this.setXRot(pitch);
    }

    private void updateRotationToTarget(int remainingDelay) {
        if (this.targetPos == null) {
            return;
        }
        Player owner = this.getOwnerPlayer();
        if (owner == null) {
            return;
        }
        Vec3 direction = this.targetPos.subtract(this.position()).normalize();
        float targetYaw = (float)Math.toDegrees(Math.atan2(direction.z, direction.x)) - 90.0f;
        float targetPitch = (float)Math.toDegrees(Math.asin(-direction.y));
        float t = 1.0f - (float)remainingDelay / 5.0f;
        this.setYRot(Mth.lerp((float)t, (float)this.getYRot(), (float)targetYaw));
        this.setXRot(Mth.lerp((float)t, (float)this.getXRot(), (float)targetPitch));
    }

    public void shootSingle() {
        Player owner = this.getOwnerPlayer();
        if (owner == null) {
            return;
        }
        this.targetPos = this.calculateTargetPos(owner);
        this.entityData.set(SHOOT_DELAY, (Object)5);
        this.entityData.set(SHOULD_SHOOT, (Object)true);
        this.entityData.set(IS_MASS_SHOOT, (Object)false);
    }

    public void shootMass() {
        Player owner = this.getOwnerPlayer();
        if (owner == null) {
            return;
        }
        this.targetPos = null;
        this.entityData.set(SHOOT_DELAY, (Object)0);
        this.entityData.set(SHOULD_SHOOT, (Object)true);
        this.entityData.set(IS_MASS_SHOOT, (Object)true);
    }

    private Vec3 calculateTargetPos(Player owner) {
        Vec3 start = owner.getEyePosition();
        Vec3 direction = owner.getLookAngle();
        Vec3 end = start.add(direction.scale(100.0));
        ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)owner);
        BlockHitResult result = this.level().clip(context);
        if (result.getType() != HitResult.Type.MISS) {
            return result.getLocation();
        }
        return end;
    }

    private void performShoot(Player owner) {
        if (owner == null) {
            return;
        }
        float yawRad = (float)Math.toRadians(this.getYRot());
        float pitchRad = (float)Math.toRadians(this.getXRot());
        Vec3 direction = new Vec3(-Math.sin(yawRad) * Math.cos(pitchRad), -Math.sin(pitchRad), Math.cos(yawRad) * Math.cos(pitchRad)).normalize();
        ItemStack fakeRifle = new ItemStack((ItemLike)ModItems.RIFLE.get());
        Vec3 muzzlePos = this.position().add(direction.scale(0.5));
        new BulletBuilder(ModEntities.BULLET.get(), this.level(), (LivingEntity)owner, fakeRifle, new ArrayList<BulletType>()).position(muzzlePos).direction(direction).speed(4.0f).lifetime(100).spread(0.02f, 0.02f, 0.02f).damage(12).spawn();
        this.recoilTicks = 5;
        this.entityData.set(SHOULD_SHOOT, (Object)false);
        boolean isMassShoot = (Boolean)this.entityData.get(IS_MASS_SHOOT);
        if (!isMassShoot && this.level() instanceof ServerLevel) {
            MamiRifleShootEvent event = new MamiRifleShootEvent(owner, this);
            MamiEventSynchronizer.syncShootEvent(event, 64.0);
        }
        int savedIndex = this.getIndex();
        this.destroy(false);
        if (isMassShoot) {
            Level level;
            MamiRifleData data = (MamiRifleData)owner.getData(ModDataAttachments.MAMI_RIFLES.get());
            if (data.limitReached && (level = this.level()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.getServer().tell((Runnable)new TickTask(server.getServer().getTickCount() + 20, () -> this.respawnRifle(owner, savedIndex)));
            }
        }
    }

    private void respawnRifle(Player owner, int index) {
        if (owner == null || !owner.isAlive()) {
            return;
        }
        if (!(owner.getMainHandItem().getItem() instanceof MamiRifleItem)) {
            return;
        }
        MamiRifleData data = (MamiRifleData)owner.getData(ModDataAttachments.MAMI_RIFLES.get());
        if (data.riflesByIndex.containsKey(index)) {
            return;
        }
        int totalCount = data.riflesByIndex.size() + 1;
        MamiRifleEntity newRifle = new MamiRifleEntity(owner.level(), owner, index, totalCount);
        owner.level().addFreshEntity((Entity)newRifle);
        data.riflesByIndex.put(index, newRifle.getId());
    }

    private void respawn(Player owner) {
        if (owner == null) {
            return;
        }
        ItemStack stack = owner.getMainHandItem();
        MamiFormation formation = MamiFormation.valueOf((String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE"));
        MamiRifleData data = (MamiRifleData)owner.getData(ModDataAttachments.MAMI_RIFLES.get());
        int totalCount = data.riflesByIndex.size();
        Vec3 spawnPos = FormationStrategy.getPosition(formation, owner, this.getIndex(), totalCount);
        this.setPos(spawnPos);
        this.entityData.set(SPAWN_TICKS, (Object)0);
    }

    public void destroy(boolean removeFromData) {
        Level level;
        Player owner;
        if (!this.level().isClientSide && removeFromData && (owner = this.getOwnerPlayer()) != null) {
            MamiRifleData data = (MamiRifleData)owner.getData(ModDataAttachments.MAMI_RIFLES.get());
            data.riflesByIndex.values().remove(this.getId());
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)ModItems.RIFLE.get())), this.getX(), this.getY(), this.getZ(), 10, 0.1, 0.1, 0.1, 0.05);
            server.sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY(), this.getZ(), 15, 0.2, 0.2, 0.2, 0.3);
        }
        this.discard();
    }

    private void spawnParticles() {
        if (this.random.nextFloat() < 0.2f) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() + (this.random.nextDouble() - 0.5) * 0.2, this.getY() + (this.random.nextDouble() - 0.5) * 0.2, this.getZ() + (this.random.nextDouble() - 0.5) * 0.2, 0.0, 0.03, 0.0);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(INDEX, (Object)0);
        builder.define(SPAWN_TICKS, (Object)0);
        builder.define(SHOOT_DELAY, (Object)0);
        builder.define(SHOULD_SHOOT, (Object)false);
        builder.define(IS_MASS_SHOOT, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.hasUUID("Owner")) {
            this.entityData.set(OWNER_UUID, Optional.of(tag.getUUID("Owner")));
        }
        this.entityData.set(INDEX, (Object)tag.getInt("Index"));
        this.entityData.set(SPAWN_TICKS, (Object)tag.getInt("SpawnTicks"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        ((Optional)this.entityData.get(OWNER_UUID)).ifPresent(uuid -> tag.putUUID("Owner", uuid));
        tag.putInt("Index", ((Integer)this.entityData.get(INDEX)).intValue());
        tag.putInt("SpawnTicks", ((Integer)this.entityData.get(SPAWN_TICKS)).intValue());
    }
}

