/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.data.ModDataAttachments;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.nami.MamiFormation;
import com.f708.anothergunmod.nami.MamiRifleConfigScreen;
import com.f708.anothergunmod.nami.MamiRifleData;
import com.f708.anothergunmod.nami.MamiRifleLimit;
import com.f708.anothergunmod.nami.MamiRifleManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MamiRifleItem
extends Item {
    private static final UUID SPECIAL_PLAYER_UUID = UUID.fromString("5625b902-84be-4b2e-81d0-c6b75b1d6c9a");

    public static boolean hasSpecialAccess(Player player) {
        return player.getUUID().equals(SPECIAL_PLAYER_UUID);
    }

    public MamiRifleItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE").component(ModDataComponents.MAMI_LIMIT, (Object)"TEN"));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (level.isClientSide) {
                this.openConfigMenu(player, stack);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        if (!level.isClientSide) {
            String formation = (String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE");
            MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
            if (formation.equals("CIRCLE")) {
                data.wasReleased = false;
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)stack);
            }
            if (data.limitReached && data.wasReleased) {
                data.wasReleased = false;
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)stack);
            }
            data.wasReleased = false;
            player.startUsingItem(hand);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.isClientSide) {
            return;
        }
        String formation = (String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE");
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        int currentLimit = MamiRifleManager.getCurrentLimit(player);
        int currentCount = MamiRifleManager.getRifleCount(player);
        if (formation.equals("CIRCLE")) {
            if (currentCount >= currentLimit) {
                player.stopUsingItem();
                data.limitReached = true;
                return;
            }
            int useTime = this.getUseDuration(stack, (LivingEntity)player) - remainingUseDuration;
            int interval = Math.max(1, 10 - useTime / 20);
            if (data.summonCooldown == 0) {
                MamiRifleManager.summonRifle(player, level);
                data.summonCooldown = interval;
            }
            return;
        }
        if (data.limitReached) {
            if (currentCount < currentLimit) {
                int useTime = this.getUseDuration(stack, (LivingEntity)player) - remainingUseDuration;
                int interval = Math.max(1, 5 - useTime / 20);
                if (data.summonCooldown == 0) {
                    MamiRifleManager.summonRifle(player, level);
                    data.summonCooldown = interval;
                }
            } else {
                MamiRifleManager.shootMass(player);
            }
            return;
        }
        if (currentCount >= currentLimit) {
            player.stopUsingItem();
            data.limitReached = true;
            return;
        }
        int useTime = this.getUseDuration(stack, (LivingEntity)player) - remainingUseDuration;
        int interval = Math.max(1, 5 - useTime / 20);
        if (data.summonCooldown == 0) {
            MamiRifleManager.summonRifle(player, level);
            data.summonCooldown = interval;
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.isClientSide) {
            return;
        }
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        data.wasReleased = true;
        player.stopUsingItem();
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        MamiRifleData data;
        boolean heldInMainHand;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean bl = heldInMainHand = player.getMainHandItem() == stack;
        if (!heldInMainHand && !level.isClientSide) {
            MamiRifleManager.destroyAll(player, true);
            data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
            data.rotationSpeed = 0.02f;
        }
        if (heldInMainHand && !level.isClientSide) {
            MamiRifleManager.tickCooldowns(player);
            data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
            int currentLimit = MamiRifleManager.getCurrentLimit(player);
            int currentCount = MamiRifleManager.getRifleCount(player);
            if (currentCount < currentLimit) {
                data.limitReached = false;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openConfigMenu(Player player, ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new MamiRifleConfigScreen(stack));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MamiFormation formation = MamiFormation.valueOf((String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE"));
        MamiRifleLimit limit = MamiRifleLimit.valueOf((String)stack.getOrDefault(ModDataComponents.MAMI_LIMIT, (Object)"TEN"));
        tooltip.add((Component)Component.literal((String)"CREATIVE ONLY").withStyle(ChatFormatting.DARK_PURPLE));
        tooltip.add((Component)Component.translatable((String)"tooltip.anothergunmod.mami.shift_use").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }
}

