/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.data.ModDataAttachments;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.nami.MamiEventSynchronizer;
import com.f708.anothergunmod.nami.MamiRifleData;
import com.f708.anothergunmod.nami.MamiRifleEntity;
import com.f708.anothergunmod.nami.MamiRifleItem;
import com.f708.anothergunmod.nami.MamiRifleLimit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MamiRifleManager {
    private static float getShotsPerSecond(int limit) {
        return switch (limit) {
            case 10 -> 5.0f;
            case 20 -> 15.0f;
            case 50 -> 35.0f;
            case 100 -> 60.0f;
            case 200 -> 100.0f;
            default -> 5.0f;
        };
    }

    private static int getSalvoSize(int totalRifles) {
        if (totalRifles < 20) {
            return 1;
        }
        if (totalRifles < 50) {
            return 3;
        }
        if (totalRifles < 100) {
            return 7;
        }
        if (totalRifles < 200) {
            return 15;
        }
        return 30;
    }

    public static void shootMass(Player player) {
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        List<MamiRifleEntity> allRifles = MamiRifleManager.getRifles(player);
        if (allRifles.isEmpty()) {
            return;
        }
        List<MamiRifleEntity> readyRifles = allRifles.stream().filter(r -> r.isAlive() && r.isSpawned()).sorted(Comparator.comparingInt(MamiRifleEntity::getIndex)).toList();
        if (readyRifles.isEmpty()) {
            return;
        }
        int limit = MamiRifleManager.getCurrentLimit(player);
        float shotsPerSecond = MamiRifleManager.getShotsPerSecond(limit);
        float shotsPerTick = shotsPerSecond / 20.0f;
        data.shootAccumulator += shotsPerTick;
        ArrayList<MamiRifleEntity> shotRiflesThisTick = new ArrayList<MamiRifleEntity>();
        while (data.shootAccumulator >= 1.0f && !readyRifles.isEmpty()) {
            int salvoSize = MamiRifleManager.getSalvoSize(readyRifles.size());
            for (int i = 0; i < salvoSize; ++i) {
                int rifleIndex = data.currentShootIndex % readyRifles.size();
                MamiRifleEntity rifle = readyRifles.get(rifleIndex);
                rifle.shootMass();
                shotRiflesThisTick.add(rifle);
                ++data.currentShootIndex;
            }
            data.shootAccumulator -= 1.0f;
            if (!(data.shootAccumulator > 10.0f)) continue;
            data.shootAccumulator = 10.0f;
        }
        if (!shotRiflesThisTick.isEmpty() && player.level() instanceof ServerLevel) {
            MamiEventSynchronizer.syncBatchShootEvent(player, shotRiflesThisTick, 64.0);
        }
    }

    public static void summonRifle(Player player, Level level) {
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        int currentLimit = MamiRifleManager.getCurrentLimit(player);
        if (data.riflesByIndex.size() >= currentLimit) {
            return;
        }
        int index = MamiRifleManager.findFreeIndex(data, currentLimit);
        if (index == -1) {
            return;
        }
        int totalCount = data.riflesByIndex.size() + 1;
        MamiRifleEntity rifle = new MamiRifleEntity(level, player, index, totalCount);
        level.addFreshEntity((Entity)rifle);
        data.riflesByIndex.put(index, rifle.getId());
        if (data.riflesByIndex.size() >= currentLimit) {
            data.limitReached = true;
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Vec3 pos = rifle.position();
            server.playSound(null, pos.x, pos.y, pos.z, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 0.3f, 1.5f);
        }
    }

    private static int findFreeIndex(MamiRifleData data, int limit) {
        for (int i = 0; i < limit; ++i) {
            if (data.riflesByIndex.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    public static void destroyAll(Player player, boolean particles) {
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        for (int entityId : new ArrayList<Integer>(data.riflesByIndex.values())) {
            Entity entity = player.level().getEntity(entityId);
            if (!(entity instanceof MamiRifleEntity)) continue;
            MamiRifleEntity rifle = (MamiRifleEntity)entity;
            rifle.destroy(false);
        }
        data.riflesByIndex.clear();
        data.limitReached = false;
        data.shootAccumulator = 0.0f;
        data.currentShootIndex = 0;
    }

    public static void adjustToLimit(Player player) {
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        int newLimit = MamiRifleManager.getCurrentLimit(player);
        int currentCount = data.riflesByIndex.size();
        if (currentCount > newLimit) {
            MamiRifleManager.removeExcessRifles(player, currentCount - newLimit);
            data.limitReached = false;
        } else {
            data.limitReached = currentCount == newLimit;
        }
    }

    private static void removeExcessRifles(Player player, int countToRemove) {
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        List<MamiRifleEntity> rifles = MamiRifleManager.getRifles(player);
        if (rifles.isEmpty()) {
            return;
        }
        rifles.sort(Comparator.comparingInt(MamiRifleEntity::getIndex).reversed());
        int removed = 0;
        for (MamiRifleEntity rifle : rifles) {
            if (removed >= countToRemove) break;
            rifle.destroy(true);
            ++removed;
        }
        MamiRifleManager.getRifles(player);
        data.currentShootIndex = 0;
        data.shootAccumulator = 0.0f;
    }

    public static List<MamiRifleEntity> getRifles(Player player) {
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        ArrayList<MamiRifleEntity> rifles = new ArrayList<MamiRifleEntity>();
        for (int entityId : new ArrayList<Integer>(data.riflesByIndex.values())) {
            Entity entity = player.level().getEntity(entityId);
            if (entity instanceof MamiRifleEntity) {
                MamiRifleEntity rifle = (MamiRifleEntity)entity;
                rifles.add(rifle);
                continue;
            }
            data.riflesByIndex.values().remove(entityId);
        }
        return rifles;
    }

    public static int getRifleCount(Player player) {
        return MamiRifleManager.getRifles(player).size();
    }

    public static void tickCooldowns(Player player) {
        MamiRifleData data = (MamiRifleData)player.getData(ModDataAttachments.MAMI_RIFLES.get());
        if (data.summonCooldown > 0) {
            --data.summonCooldown;
        }
    }

    public static int getCurrentLimit(Player player) {
        if (!(player.getMainHandItem().getItem() instanceof MamiRifleItem)) {
            return 10;
        }
        String limitStr = (String)player.getMainHandItem().getOrDefault(ModDataComponents.MAMI_LIMIT, (Object)"TEN");
        return MamiRifleLimit.valueOf(limitStr).getCount();
    }
}

