/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.core.events.core.ClientEventHandler;
import com.f708.anothergunmod.nami.MamiRifleEntity;
import com.f708.anothergunmod.nami.MamiRifleShootEvent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record S2C_MamiRifleBatchShootPacket(long ownerUUIDMost, long ownerUUIDLeast, int[] rifleEntityIds) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2C_MamiRifleBatchShootPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"mami_rifle_batch_shoot"));
    public static final StreamCodec<ByteBuf, S2C_MamiRifleBatchShootPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, S2C_MamiRifleBatchShootPacket::ownerUUIDMost, (StreamCodec)ByteBufCodecs.VAR_LONG, S2C_MamiRifleBatchShootPacket::ownerUUIDLeast, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.VAR_INT).map(list -> list.stream().mapToInt(Integer::intValue).toArray(), arr -> {
        ArrayList<Integer> list = new ArrayList<Integer>(((int[])arr).length);
        for (int i : arr) {
            list.add(i);
        }
        return list;
    }), S2C_MamiRifleBatchShootPacket::rifleEntityIds, S2C_MamiRifleBatchShootPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(S2C_MamiRifleBatchShootPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            UUID ownerUUID = new UUID(packet.ownerUUIDMost, packet.ownerUUIDLeast);
            Player owner = mc.level.getPlayerByUUID(ownerUUID);
            if (owner == null) {
                return;
            }
            for (int rifleId : packet.rifleEntityIds) {
                Entity entity = mc.level.getEntity(rifleId);
                if (!(entity instanceof MamiRifleEntity)) continue;
                MamiRifleEntity rifle = (MamiRifleEntity)entity;
                MamiRifleShootEvent event = new MamiRifleShootEvent(owner, rifle);
                ClientEventHandler.onMamiRifleShoot(event);
            }
        });
    }
}

