/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.network;

import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.events.core.WeaponBlockEvent;
import com.f708.anothergunmod.core.events.game.WeaponReloadEvent;
import com.f708.anothergunmod.core.events.game.WeaponShootEvent;
import com.f708.anothergunmod.data.ModDataAttachments;
import com.f708.anothergunmod.network.packets.S2C_Recoil_Packet;
import com.f708.anothergunmod.network.packets.S2C_ScopingDataPacket;
import com.f708.anothergunmod.network.packets.S2C_WeaponBlockEventPacket;
import com.f708.anothergunmod.network.packets.S2C_WeaponReloadEventPacket;
import com.f708.anothergunmod.network.packets.S2C_WeaponShootEventPacket;
import com.f708.anothergunmod.utils.CameraUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

@OnlyIn(value=Dist.CLIENT)
public final class ClientPacketHandlers {
    private static final Map<Key, Long> LAST_RELOAD_SEEN = new HashMap<Key, Long>();
    private static final Map<Key, Long> LAST_SHOOT_SEEN = new HashMap<Key, Long>();

    private ClientPacketHandlers() {
    }

    public static void onRecoil(S2C_Recoil_Packet pkt) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null) {
            CameraUtils.triggerRecoil((Player)player, pkt.duration(), pkt.pitchAngle(), pkt.yawAngle());
        }
    }

    public static void onScoping(S2C_ScopingDataPacket pkt) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null) {
            player.setData(ModDataAttachments.SCOPING.get(), (Object)pkt.isScoping());
        }
    }

    public static void onWeaponReloadEvent(S2C_WeaponReloadEventPacket pkt) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Player player = mc.level.getPlayerByUUID(pkt.playerUUID());
        if (player == null) {
            return;
        }
        Key key = new Key(player.getUUID(), pkt.weaponType());
        Long prev = LAST_RELOAD_SEEN.get(key);
        if (prev != null && prev.longValue() == pkt.serverTime()) {
            return;
        }
        LAST_RELOAD_SEEN.put(key, pkt.serverTime());
        NeoForge.EVENT_BUS.post((Event)new WeaponReloadEvent(player, pkt.weaponType(), pkt.hand()));
    }

    public static void onWeaponShootEvent(S2C_WeaponShootEventPacket pkt) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Player player = mc.level.getPlayerByUUID(pkt.playerUUID());
        if (player == null) {
            return;
        }
        Key key = new Key(player.getUUID(), pkt.weaponType());
        Long prev = LAST_SHOOT_SEEN.get(key);
        if (prev != null && prev.longValue() == pkt.serverTime()) {
            return;
        }
        LAST_SHOOT_SEEN.put(key, pkt.serverTime());
        NeoForge.EVENT_BUS.post((Event)new WeaponShootEvent(player, pkt.weaponType(), pkt.hand()));
    }

    public static void onWeaponBlockEvent(S2C_WeaponBlockEventPacket pkt) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Player player = mc.level.getPlayerByUUID(pkt.playerUUID());
        if (player == null) {
            return;
        }
        NeoForge.EVENT_BUS.post((Event)new WeaponBlockEvent(player, pkt.hand()));
    }

    private record Key(UUID id, WeaponType type) {
    }
}

