/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.network.packets;

import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.registry.item.custom.magazine.AbstractMagazine;
import com.f708.anothergunmod.registry.item.custom.mechanics.DualWieldRevolverState;
import com.f708.anothergunmod.utils.GunUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record C2S_PacketSendReloadAction(InteractionHand hand) implements CustomPacketPayload
{
    private static final Map<UUID, Long> LAST_RELOAD_REQ_TICK = new HashMap<UUID, Long>();
    public static final CustomPacketPayload.Type<C2S_PacketSendReloadAction> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"reload_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2S_PacketSendReloadAction> STREAM_CODEC = StreamCodec.of((buf, pkt) -> buf.writeEnum((Enum)pkt.hand), buf -> new C2S_PacketSendReloadAction((InteractionHand)buf.readEnum(InteractionHand.class)));

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handleData(IPayloadContext context) {
        if (!context.flow().isServerbound()) {
            return;
        }
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            C2S_PacketSendReloadAction.handleServerReload(player, this.hand);
        }).exceptionally(e -> {
            context.connection().disconnect((Component)Component.literal((String)("Reload error: " + e.getMessage())));
            return null;
        });
    }

    private static void handleServerReload(ServerPlayer player, InteractionHand hand) {
        AbstractGunItem og;
        AbstractGunItem mg;
        Item item;
        boolean bothRevolvers;
        UUID id;
        long last;
        if (player == null || hand == null) {
            return;
        }
        long now = player.serverLevel().getGameTime();
        if (now - (last = LAST_RELOAD_REQ_TICK.getOrDefault(id = player.getUUID(), -1000L).longValue()) < 2L) {
            return;
        }
        LAST_RELOAD_REQ_TICK.put(id, now);
        ItemStack stack = player.getItemInHand(hand);
        AbstractGunItem abstractGunItem = (AbstractGunItem)stack.getItem();
        Item item2 = stack.getItem();
        if (item2 instanceof AbstractMagazine) {
            AbstractMagazine magazine = (AbstractMagazine)item2;
            if (!player.getCooldowns().isOnCooldown((Item)magazine)) {
                magazine.reload((Player)player, stack);
            }
            return;
        }
        item2 = stack.getItem();
        if (!(item2 instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gun = (AbstractGunItem)item2;
        if (player.getCooldowns().isOnCooldown((Item)gun)) {
            return;
        }
        if (gun.weaponType() != WeaponType.REVOLVER) {
            InteractionHand other;
            InteractionHand interactionHand = other = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            if (!player.getItemInHand(other).isEmpty()) {
                return;
            }
        }
        boolean bl = bothRevolvers = (item = player.getMainHandItem().getItem()) instanceof AbstractGunItem && (mg = (AbstractGunItem)item).weaponType() == WeaponType.REVOLVER && (item = player.getOffhandItem().getItem()) instanceof AbstractGunItem && (og = (AbstractGunItem)item).weaponType() == WeaponType.REVOLVER;
        if (!C2S_PacketSendReloadAction.serverCanStartReload(player, stack, gun)) {
            AbstractGunItem otherGun;
            InteractionHand other;
            ItemStack otherStack;
            Item item3;
            if (bothRevolvers && (item3 = (otherStack = player.getItemInHand(other = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND)).getItem()) instanceof AbstractGunItem && C2S_PacketSendReloadAction.serverCanStartReload(player, otherStack, otherGun = (AbstractGunItem)item3)) {
                abstractGunItem.reload((Player)player, otherStack, other);
                DualWieldRevolverState.toggleAfterReload((Player)player);
            }
            return;
        }
        abstractGunItem.reload((Player)player, stack, hand);
        if (bothRevolvers && gun.weaponType() == WeaponType.REVOLVER) {
            DualWieldRevolverState.toggleAfterReload((Player)player);
        }
    }

    private static boolean serverCanStartReload(ServerPlayer player, ItemStack stack, AbstractGunItem gun) {
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            return false;
        }
        return switch (gun.weaponType()) {
            default -> throw new MatchException(null, null);
            case WeaponType.REVOLVER -> {
                if (!gun.isMaxAmmo(stack) && GunUtils.containItem((Player)player, ModItems.SMALLBULLET.get())) {
                    yield true;
                }
                yield false;
            }
            case WeaponType.RIFLE, WeaponType.RIFLE_SPYGLASS -> {
                if (!gun.isMaxAmmo(stack) && GunUtils.containItem((Player)player, ModItems.BIGBULLET.get())) {
                    yield true;
                }
                yield false;
            }
            case WeaponType.SHOTGUN -> {
                if (!gun.isMaxAmmo(stack) && GunUtils.containItem((Player)player, ModItems.SHELL.get())) {
                    yield true;
                }
                yield false;
            }
            case WeaponType.AUTOGUN, WeaponType.MACHINEGUN -> true;
            case WeaponType.FLAMETHROWER -> !gun.isMaxAmmo(stack) && GunUtils.containItem((Player)player, Items.BLAZE_ROD);
        };
    }
}

