/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.network.packets;

import com.f708.anothergunmod.core.enums.WeaponType;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record S2C_WeaponBlockEventPacket(UUID playerUUID, WeaponType weaponType, InteractionHand hand, long serverTime) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2C_WeaponBlockEventPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"weapon_block_event"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2C_WeaponBlockEventPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, uuid) -> {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }, buf -> new UUID(buf.readLong(), buf.readLong())), S2C_WeaponBlockEventPacket::playerUUID, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeEnum, buf -> (WeaponType)buf.readEnum(WeaponType.class)), S2C_WeaponBlockEventPacket::weaponType, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeEnum, buf -> (InteractionHand)buf.readEnum(InteractionHand.class)), S2C_WeaponBlockEventPacket::hand, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeVarLong, FriendlyByteBuf::readVarLong), S2C_WeaponBlockEventPacket::serverTime, S2C_WeaponBlockEventPacket::new);

    public static void handle(S2C_WeaponBlockEventPacket packet, IPayloadContext ctx) {
        if (!ctx.flow().isClientbound()) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                try {
                    Class<?> cls = Class.forName("com.f708.anothergunmod.client.network.ClientPacketHandlers");
                    Method m = cls.getMethod("onWeaponBlockEvent", S2C_WeaponBlockEventPacket.class);
                    m.invoke(null, packet);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

