/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.network.packets;

import com.f708.anothergunmod.core.enums.WeaponType;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record S2C_WeaponShootEventPacket(UUID playerUUID, WeaponType weaponType, InteractionHand hand, long serverTime) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2C_WeaponShootEventPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"weapon_shoot_event"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2C_WeaponShootEventPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, uuid) -> {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }, buf -> new UUID(buf.readLong(), buf.readLong())), S2C_WeaponShootEventPacket::playerUUID, (StreamCodec)StreamCodec.of((buf, t) -> buf.writeEnum((Enum)t), buf -> (WeaponType)buf.readEnum(WeaponType.class)), S2C_WeaponShootEventPacket::weaponType, (StreamCodec)StreamCodec.of((buf, h) -> buf.writeEnum((Enum)h), buf -> (InteractionHand)buf.readEnum(InteractionHand.class)), S2C_WeaponShootEventPacket::hand, (StreamCodec)StreamCodec.of((buf, time) -> buf.writeVarLong(time.longValue()), FriendlyByteBuf::readVarLong), S2C_WeaponShootEventPacket::serverTime, S2C_WeaponShootEventPacket::new);

    public static void handle(S2C_WeaponShootEventPacket packet, IPayloadContext ctx) {
        if (!ctx.flow().isClientbound()) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                try {
                    Class<?> cls = Class.forName("com.f708.anothergunmod.client.network.ClientPacketHandlers");
                    Method m = cls.getMethod("onWeaponShootEvent", S2C_WeaponShootEventPacket.class);
                    m.invoke(null, packet);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

