/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.entity.bullet;

import com.f708.anothergunmod.core.enums.BulletType;
import com.f708.anothergunmod.registry.entity.bullet.BulletEntity;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BulletBuilder {
    private final EntityType<? extends BulletEntity> entityType;
    private final Level level;
    private final LivingEntity owner;
    private final ItemStack gun;
    private final List<BulletType> bulletType;
    private Vec3 customPosition = null;
    private Vec3 customDirection = null;
    private float speed = 3.0f;
    private int lifetime = 100;
    private float spreadX = 0.0f;
    private float spreadY = 0.0f;
    private float spreadZ = 0.0f;
    private int damage = 10;

    public BulletBuilder(EntityType<? extends BulletEntity> entityType, Level level, LivingEntity owner, ItemStack gun, List<BulletType> bulletType) {
        this.entityType = entityType;
        this.level = level;
        this.owner = owner;
        this.gun = gun;
        this.bulletType = bulletType;
    }

    public BulletBuilder position(Vec3 pos) {
        this.customPosition = pos;
        return this;
    }

    public BulletBuilder direction(Vec3 dir) {
        this.customDirection = dir;
        return this;
    }

    public BulletBuilder speed(float speed) {
        this.speed = speed;
        return this;
    }

    public BulletBuilder lifetime(int lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    public BulletBuilder spread(float x, float y, float z) {
        this.spreadX = x;
        this.spreadY = y;
        this.spreadZ = z;
        return this;
    }

    public BulletBuilder damage(int damage) {
        this.damage = damage;
        return this;
    }

    public void spawn() {
        BulletEntity bullet = this.customPosition != null && this.customDirection != null ? new BulletEntity(this.entityType, this.level, this.owner, this.customPosition, this.customDirection, this.speed, this.lifetime, new Vec3((double)this.spreadX, (double)this.spreadY, (double)this.spreadZ), this.damage, this.gun) : new BulletEntity(this.entityType, this.level, this.owner, this.speed, this.lifetime, new Vec3((double)this.spreadX, (double)this.spreadY, (double)this.spreadZ), this.damage, this.gun);
        this.level.addFreshEntity((Entity)bullet);
    }
}

