/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.entity.flamejet;

import com.f708.anothergunmod.core.ModDamageTypes;
import com.f708.anothergunmod.registry.entity.ModEntities;
import com.f708.anothergunmod.registry.particle.flame.FlameJetParams;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlameJetEntity
extends Projectile {
    private int age = 0;
    private Vec3 baseDir = Vec3.ZERO;
    private float damagePerTick = FlameJetParams.DAMAGE_PER_TICK;
    private Vec3 shootPos = null;
    private ItemStack firedWeapon;
    private float speedMul = 1.0f;

    public FlameJetEntity(EntityType<? extends FlameJetEntity> type, Level level, ItemStack gun) {
        super(type, level);
        this.noPhysics = false;
        this.setNoGravity(true);
        this.setInvisible(true);
        this.firedWeapon = gun;
    }

    public FlameJetEntity(EntityType<? extends FlameJetEntity> type, Level level) {
        super(type, level);
        this.noPhysics = false;
        this.setNoGravity(true);
        this.setInvisible(true);
    }

    public static FlameJetEntity spawnSingle(ServerLevel level, LivingEntity shooter, Vec3 pos, Vec3 dir, ItemStack gun) {
        FlameJetEntity jet = new FlameJetEntity(ModEntities.FLAME_JET.get(), (Level)level);
        jet.setOwner((Entity)shooter);
        jet.setPos(pos.x, pos.y, pos.z);
        jet.baseDir = dir.normalize();
        jet.firedWeapon = gun.copy();
        jet.setDeltaMovement(jet.baseDir.scale((double)FlameJetParams.INITIAL_SPEED));
        jet.shootPos = pos;
        level.addFreshEntity((Entity)jet);
        return jet;
    }

    public static void spawnBurst(ServerLevel level, LivingEntity shooter, Vec3 spread, float damagePerTick, ItemStack gun) {
        if (level == null || shooter == null) {
            return;
        }
        Random rng = new Random();
        Vec3 look = shooter.getLookAngle().normalize();
        Vec3 body = shooter.position().add(0.0, (double)shooter.getBbHeight() * 0.4, 0.0);
        Vec3 startPos = body.add(look.scale(-0.5));
        Vec3 dir = look.add(rng.nextGaussian() * spread.x, rng.nextGaussian() * spread.y, rng.nextGaussian() * spread.z).normalize();
        FlameJetEntity.spawnSingle(level, shooter, startPos, dir, gun);
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return this.firedWeapon;
    }

    public void tick() {
        super.tick();
        if (this.isInWaterOrBubble() || this.level().getFluidState(this.blockPosition()).is(FluidTags.WATER)) {
            this.discard();
            return;
        }
        if (this.age++ >= FlameJetParams.PROJECTILE_LIFETIME) {
            this.discard();
            return;
        }
        if (this.getBlockStateOn().isSuffocating((BlockGetter)this.level(), this.getOnPos())) {
            this.discard();
            return;
        }
        float t = (float)this.age / (float)FlameJetParams.PROJECTILE_LIFETIME;
        float baseSpeed = FlameJetParams.INITIAL_SPEED * FlameJetParams.speedFactor(t);
        float speed = baseSpeed * this.speedMul;
        if (this.baseDir.lengthSqr() > 1.0E-6) {
            Vec3 motion = this.baseDir.scale((double)speed);
            this.move(MoverType.SELF, motion);
            this.speedMul = this.horizontalCollision || this.verticalCollision ? Math.max(0.15f, this.speedMul * 0.35f) : (this.speedMul += (1.0f - this.speedMul) * 0.2f);
        }
        float rStart = 0.5f;
        float rEnd = Math.max(FlameJetParams.END_HITBOX_RADIUS, rStart);
        float r = Mth.lerp((float)t, (float)rStart, (float)rEnd);
        this.setBoundingBox(new AABB(this.getX() - (double)r, this.getY() - (double)r, this.getZ() - (double)r, this.getX() + (double)r, this.getY() + (double)r, this.getZ() + (double)r));
        if (!this.level().isClientSide) {
            LivingEntity le;
            Entity entity = this.getOwner();
            LivingEntity owner = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
            AABB box = this.getBoundingBox();
            for (LivingEntity target : this.level().getEntitiesOfClass(LivingEntity.class, box, e -> e.isAlive() && e != owner)) {
                Mob mob;
                Player player;
                if (!this.hasLineOfSightTo(owner, target)) continue;
                int interval = 10;
                if (owner != null) {
                    double d = owner.distanceTo((Entity)target);
                    double a = Mth.clamp((double)(d - 1.0), (double)0.0, (double)1.0);
                    interval = Math.round(Mth.lerp((float)((float)a), (float)5.0f, (float)10.0f));
                }
                if ((this.age + target.getId()) % interval != 0) continue;
                if (target instanceof Player && (player = (Player)target).isBlocking()) {
                    InteractionHand hand = player.getUsedItemHand();
                    EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    player.getUseItem().hurtAndBreak(5, (LivingEntity)player, slot);
                    continue;
                }
                Vec3 prevVel = target.getDeltaMovement();
                DamageSource src = ModDamageTypes.flamethrower(this.level(), (Entity)this, (Entity)(owner != null ? owner : this), this.getWeaponItem());
                target.invulnerableTime = 0;
                boolean damaged = target.hurt(src, this.damagePerTick);
                if (!damaged) continue;
                target.setDeltaMovement(prevVel.x, target.getDeltaMovement().y, prevVel.z);
                target.setRemainingFireTicks(Math.max(target.getRemainingFireTicks(), 20));
                if (owner instanceof Player) {
                    Player p = (Player)owner;
                    if (p.isCreative()) continue;
                    target.setLastHurtByPlayer(p);
                    if (!(target instanceof Mob)) continue;
                    mob = (Mob)target;
                    mob.setTarget((LivingEntity)p);
                    continue;
                }
                if (owner == null) continue;
                target.setLastHurtByMob(owner);
                if (!(target instanceof Mob)) continue;
                mob = (Mob)target;
                mob.setTarget(owner);
            }
        }
    }

    private boolean hasLineOfSightTo(LivingEntity shooter, LivingEntity target) {
        Vec3 start = this.shootPos;
        Vec3 end = target.getBoundingBox().getCenter();
        Vec3 anotherEnd = target.getEyePosition();
        BlockHitResult hit2 = this.level().clip(new ClipContext(start, anotherEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockHitResult hit = this.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return hit.getType() == HitResult.Type.MISS || hit2.getType() == HitResult.Type.MISS;
    }

    protected void onHitEntity(EntityHitResult result) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.age = tag.getInt("Age");
        this.damagePerTick = tag.contains("Dmg") ? tag.getFloat("Dmg") : FlameJetParams.DAMAGE_PER_TICK;
        double dx = tag.getDouble("DirX");
        double dy = tag.getDouble("DirY");
        double dz = tag.getDouble("DirZ");
        this.baseDir = new Vec3(dx, dy, dz);
        if (this.baseDir.lengthSqr() <= 1.0E-6) {
            this.baseDir = Vec3.ZERO;
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("Age", this.age);
        tag.putFloat("Dmg", this.damagePerTick);
        tag.putDouble("DirX", this.baseDir.x);
        tag.putDouble("DirY", this.baseDir.y);
        tag.putDouble("DirZ", this.baseDir.z);
    }

    public boolean isPickable() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }
}

