/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.item.custom;

import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.core.enums.AmmoType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.interfaces.IMeleeGun;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.utils.GunUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AutoGun
extends AbstractGunItem
implements IMeleeGun {
    public AutoGun(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int rangedDamage(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.DAMAGE, (Object)ModConfig.getAutogunDamage());
    }

    @Override
    public int bulletAmountPerShot(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.BULLETS_PER_SHOT, (Object)1);
    }

    @Override
    public int maxAmmo(ItemStack gun) {
        return 32;
    }

    @Override
    public int recoil(ItemStack gun) {
        float support = (Boolean)gun.getOrDefault(ModDataComponents.IS_SUPPORTED, (Object)false) != false ? 0.8f : 1.0f;
        return (int)((float)((Integer)gun.getOrDefault(ModDataComponents.RECOIL, (Object)ModConfig.getAutogunRecoil())).intValue() * support);
    }

    @Override
    public int fireRate(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.FIRE_RATE, (Object)ModConfig.getAutogunFireRate());
    }

    @Override
    public int reloadTime(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.RELOAD_TIME, (Object)ModConfig.getAutogunReloadTime());
    }

    @Override
    public WeaponType weaponType() {
        return WeaponType.AUTOGUN;
    }

    @Override
    public AmmoType ammoType() {
        return AmmoType.BULLET;
    }

    @Override
    public boolean magazineAttached(ItemStack gun) {
        return (Boolean)gun.getOrDefault(ModDataComponents.MAGAZINEATTACHED, (Object)false);
    }

    @Override
    public boolean isAmmoEmpty(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return ammoContainer.isEmpty();
    }

    @Override
    public boolean canShoot(ItemStack gun, Player player) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return !ammoContainer.isEmpty() && this.magazineAttached(gun) || player.isCreative();
    }

    @Override
    public boolean isMaxAmmo(ItemStack gun) {
        return this.getAmmoContainer(gun).isFull();
    }

    @Override
    public void descreaseAmmo(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        if (!this.isAmmoEmpty(gun)) {
            AmmoContainerRecord.setContainerToComponent(gun, ammoContainer.removeBullet());
        }
    }

    @Override
    public int getAmmo(ItemStack gun) {
        if (this.magazineAttached(gun)) {
            AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
            return ammoContainer.size();
        }
        return 0;
    }

    @Override
    public void shoot(Player player, ItemStack stack) {
        GunUtils.performBulletSpawn(player, player.level(), stack);
        GunUtils.triggerRecoil(player, stack);
    }

    @Override
    public void reload(Player player, ItemStack stack) {
        AbstractGunItem abstractGunItem = (AbstractGunItem)stack.getItem();
        player.getCooldowns().addCooldown(stack.getItem(), abstractGunItem.reloadTime(stack));
        abstractGunItem.setReloading(stack);
    }
}

