/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.item.custom;

import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.core.enums.AmmoType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.interfaces.IGun;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.registry.particle.ModParticleTypes;
import com.f708.anothergunmod.sounds.ModSounds;
import com.f708.anothergunmod.utils.AdvUtils;
import com.f708.anothergunmod.utils.CameraUtils;
import com.f708.anothergunmod.utils.GunUtils;
import com.f708.anothergunmod.utils.TickScheduler;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FlameThrower
extends AbstractGunItem
implements IGun {
    public FlameThrower(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int rangedDamage(ItemStack gun) {
        return ModConfig.getFlamethrowerDamage();
    }

    @Override
    public int bulletAmountPerShot(ItemStack gun) {
        return 1;
    }

    @Override
    public int maxAmmo(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.MAX_AMMO, (Object)100);
    }

    @Override
    public int recoil(ItemStack gun) {
        return 0;
    }

    @Override
    public int fireRate(ItemStack gun) {
        return 1;
    }

    @Override
    public int reloadTime(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.RELOAD_TIME, (Object)ModConfig.getFlamethrowerReloadTime());
    }

    @Override
    public WeaponType weaponType() {
        return WeaponType.FLAMETHROWER;
    }

    @Override
    public AmmoType ammoType() {
        return AmmoType.BLAZEROD;
    }

    @Override
    public boolean magazineAttached(ItemStack gun) {
        return (Boolean)gun.getOrDefault(ModDataComponents.MAGAZINEATTACHED, (Object)false);
    }

    @Override
    public boolean isAmmoEmpty(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return ammoContainer.isEmpty();
    }

    @Override
    public boolean canShoot(ItemStack gun, Player player) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return !ammoContainer.isEmpty() || player.isCreative();
    }

    @Override
    public boolean isMaxAmmo(ItemStack gun) {
        return this.getAmmoContainer(gun).isFull();
    }

    @Override
    public void descreaseAmmo(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        if (!this.isAmmoEmpty(gun)) {
            AmmoContainerRecord.setContainerToComponent(gun, ammoContainer.removeBullet());
        } else {
            gun.set(ModDataComponents.MAGAZINEATTACHED, (Object)true);
        }
    }

    @Override
    public int getAmmo(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return ammoContainer.size();
    }

    @Override
    public void shoot(Player player, ItemStack stack, Level level, InteractionHand hand) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.FLAMETHROWER_START.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        super.shoot(player, stack, level, hand);
    }

    @Override
    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Player player;
        if (this.getAmmo(stack) <= 0 && livingEntity instanceof Player && !(player = (Player)livingEntity).isCreative()) {
            this.releaseUsing(stack, level, livingEntity, this.getUseDuration(stack, livingEntity) - remainingUseDuration);
        }
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        boolean activated;
        boolean bl = activated = !this.magazineAttached(stack);
        if (activated) {
            tooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.anothergunmod.activated").withStyle(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (stack.is(ModItems.FLAMETHROWER.get())) {
                player.getCooldowns().addCooldown((Item)this, 50);
                Item item = stack.getItem();
                if (item instanceof AbstractGunItem) {
                    AbstractGunItem abstractGunItem = (AbstractGunItem)item;
                    TickScheduler.schedule(() -> {
                        if (abstractGunItem.getAmmo(stack) > 0) {
                            level.playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.FLAMETHROWER_END.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        } else {
                            level.playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.FLAMETHROWER_EJECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }, 1);
                }
            }
        }
        super.releaseUsing(stack, level, livingEntity, timeCharged);
    }

    @Override
    public void shoot(Player player, ItemStack stack) {
        GunUtils.performFlameJetSpawn(player, (ServerLevel)player.level(), stack);
        if (this.magazineAttached(stack)) {
            stack.set(ModDataComponents.MAGAZINEATTACHED, (Object)false);
        }
        GunUtils.triggerKnockback(player, stack);
    }

    @Override
    public void reload(Player player, ItemStack stack) {
        AbstractGunItem abstractGunItem = (AbstractGunItem)stack.getItem();
        if (!((Boolean)stack.getOrDefault(ModDataComponents.MAGAZINEATTACHED, (Object)false)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                AdvUtils.grant(sp, ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"flamethrowerblow"));
            }
            double explosionX = player.getX();
            double explosionY = player.getY() + 0.8;
            double explosionZ = player.getZ();
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnExplosionFlames(serverLevel, explosionX, explosionY, explosionZ);
            }
            player.level().explode(null, explosionX, explosionY, explosionZ, 1.5f, true, Level.ExplosionInteraction.NONE);
            player.getCooldowns().addCooldown(stack.getItem(), 180);
            stack.hurtAndBreak(100, (LivingEntity)player, EquipmentSlot.MAINHAND);
            if (player.level().isClientSide()) {
                CameraUtils.triggerCameraShake(5, 1.0f, 5, 10.0f);
            }
            for (int i = 0; i < 40; ++i) {
                abstractGunItem.descreaseAmmo(stack);
            }
            return;
        }
        if (!abstractGunItem.isMaxAmmo(stack) && GunUtils.containItem(player, Items.BLAZE_ROD)) {
            player.getCooldowns().addCooldown(stack.getItem(), abstractGunItem.reloadTime(stack));
            abstractGunItem.setReloading(stack);
        }
    }

    private void spawnExplosionFlames(ServerLevel level, double x, double y, double z) {
        Random random = new Random();
        int particleCount = 80;
        for (int i = 0; i < particleCount; ++i) {
            double theta = random.nextDouble() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
            double speed = 0.3 + random.nextDouble() * 0.7;
            double vx = Math.sin(phi) * Math.cos(theta) * speed;
            double vy = Math.sin(phi) * Math.sin(theta) * speed;
            double vz = Math.cos(phi) * speed;
            double offsetX = (random.nextDouble() - 0.5) * 0.3;
            double offsetY = (random.nextDouble() - 0.5) * 0.3;
            double offsetZ = (random.nextDouble() - 0.5) * 0.3;
            level.sendParticles((ParticleOptions)((SimpleParticleType)ModParticleTypes.FLAME_PUFF.get()), x + offsetX, y + offsetY, z + offsetZ, 0, vx, vy, vz, 1.0);
        }
        level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, x, y, z, 5, 0.3, 0.3, 0.3, 0.1);
        level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, 30, 0.5, 0.5, 0.5, 0.15);
    }
}

