/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.item.custom;

import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.core.enums.AmmoType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.interfaces.IMeleeGun;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.utils.GunUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShotGun
extends AbstractGunItem
implements IMeleeGun {
    public ShotGun(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int rangedDamage(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.DAMAGE, (Object)ModConfig.getShotgunDamage());
    }

    @Override
    public int bulletAmountPerShot(ItemStack gun) {
        return ModConfig.getShotgunPelletCount();
    }

    @Override
    public int maxAmmo(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.MAX_AMMO, (Object)5);
    }

    @Override
    public int recoil(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.RECOIL, (Object)ModConfig.getShotgunRecoil());
    }

    @Override
    public int fireRate(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.FIRE_RATE, (Object)ModConfig.getShotgunFireRate());
    }

    @Override
    public int reloadTime(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.RELOAD_TIME, (Object)ModConfig.getShotgunReloadTime());
    }

    @Override
    public WeaponType weaponType() {
        return WeaponType.SHOTGUN;
    }

    @Override
    public AmmoType ammoType() {
        return AmmoType.SHELL;
    }

    @Override
    public boolean magazineAttached(ItemStack gun) {
        return true;
    }

    @Override
    public boolean isAmmoEmpty(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return ammoContainer.isEmpty();
    }

    @Override
    public boolean canShoot(ItemStack gun, Player player) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return !ammoContainer.isEmpty() || player.isCreative();
    }

    @Override
    public boolean isMaxAmmo(ItemStack gun) {
        return this.getAmmoContainer(gun).isFull();
    }

    @Override
    public void descreaseAmmo(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        if (!this.isAmmoEmpty(gun)) {
            AmmoContainerRecord.setContainerToComponent(gun, ammoContainer.removeBullet());
        }
    }

    @Override
    public int getAmmo(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return ammoContainer.size();
    }

    @Override
    public void shoot(Player player, ItemStack stack) {
        GunUtils.performBulletSpawn(player, player.level(), stack);
        GunUtils.triggerRecoil(player, stack);
        if (!((Boolean)stack.getOrDefault(ModDataComponents.IS_SUPPORTED, (Object)false)).booleanValue()) {
            GunUtils.triggerKnockback(player, stack);
        }
    }

    @Override
    public void reload(Player player, ItemStack stack) {
        AbstractGunItem abstractGunItem = (AbstractGunItem)stack.getItem();
        if (!abstractGunItem.isMaxAmmo(stack) && GunUtils.containItem(player, ModItems.SHELL.get())) {
            player.getCooldowns().addCooldown(stack.getItem(), abstractGunItem.reloadTime(stack));
            abstractGunItem.setReloading(stack);
        }
    }
}

