/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.particle.airring;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class AirRingParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final int totalFrames = 4;

    public AirRingParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.spriteSet = spriteSet;
        this.gravity = 0.0f;
        this.lifetime = 4;
        this.setSprite(spriteSet.get(0, 3));
        this.setSize(0.5f, 0.5f);
        this.quadSize = 0.5f;
        this.setColor(1.0f, 1.0f, 1.0f);
        this.setAlpha(1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        int ticksPerFrame = this.lifetime / 4;
        int currentFrame = this.age / ticksPerFrame;
        if (currentFrame >= 4) {
            currentFrame = 3;
        }
        this.setSprite(this.spriteSet.get(currentFrame, 3));
        float fadeStart = 1.0f;
        if ((float)this.age > (float)this.lifetime * fadeStart) {
            float fadeProgress = ((float)this.age - (float)this.lifetime * fadeStart) / ((float)this.lifetime * (1.0f - fadeStart));
            this.setAlpha(1.0f - fadeProgress);
        }
        this.move(this.xd, this.yd, this.zd);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

