/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.particle.flame;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class SprayMath {
    private SprayMath() {
    }

    public static Vec3[] triangleOffsets(LivingEntity shooter, double radius) {
        Vec3 worldUp;
        Vec3 look = shooter.getLookAngle().normalize();
        Vec3 right = look.cross(worldUp = new Vec3(0.0, 1.0, 0.0));
        if (right.lengthSqr() < 1.0E-6) {
            right = new Vec3(1.0, 0.0, 0.0);
        }
        right = right.normalize();
        Vec3 up = right.cross(look).normalize();
        Vec3 p1 = right.scale(radius).add(up.scale(-0.6 * radius));
        Vec3 p2 = right.scale(-radius).add(up.scale(-0.6 * radius));
        Vec3 p3 = up.scale(0.9 * radius);
        return new Vec3[]{p1, p2, p3};
    }

    public static Vec3 muzzlePosition(LivingEntity shooter, double forward) {
        Vec3 eye = shooter.getEyePosition();
        Vec3 look = shooter.getLookAngle().normalize();
        return eye.add(look.scale(forward));
    }
}

