/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.tabs;

import com.f708.anothergunmod.registry.item.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class CreativeTabBulletRenderer {
    private static final List<FallingBullet> bullets = new ArrayList<FallingBullet>();
    private static boolean initialized = false;

    public static void init(int width, int height) {
        bullets.clear();
        ItemStack[] bulletTypes = new ItemStack[]{new ItemStack((ItemLike)ModItems.SMALLBULLET.get()), new ItemStack((ItemLike)ModItems.BIGBULLET.get()), new ItemStack((ItemLike)ModItems.SHELL.get())};
        int[] layerCounts = new int[]{25, 15, 10};
        int bulletIndex = 0;
        for (int layer = 0; layer < 3; ++layer) {
            for (int i = 0; i < layerCounts[layer]; ++i) {
                FallingBullet bullet = new FallingBullet();
                bullet.stack = bulletTypes[bulletIndex % 3];
                bullet.x = (float)(Math.random() * (double)width);
                bullet.y = (float)(Math.random() * (double)height);
                bullet.layer = layer;
                bullet.rotation = (float)(Math.random() * 360.0);
                bullet.rotationSpeed = (float)(0.25 + Math.random() * 0.25) * (float)(Math.random() < 0.5 ? 1 : -1);
                switch (layer) {
                    case 0: {
                        bullet.size = 100;
                        bullet.speed = 0.02f;
                        break;
                    }
                    case 1: {
                        bullet.size = 200;
                        bullet.speed = 0.04f;
                        break;
                    }
                    case 2: {
                        bullet.size = 300;
                        bullet.speed = 0.06f;
                    }
                }
                bullets.add(bullet);
                ++bulletIndex;
            }
        }
        initialized = true;
    }

    public static void update(int height) {
        for (FallingBullet bullet : bullets) {
            bullet.y += bullet.speed;
            bullet.rotation += bullet.rotationSpeed;
            if (!(bullet.y > (float)(height + 50))) continue;
            bullet.y = -50.0f;
            bullet.x = (float)(Math.random() * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth());
        }
    }

    public static void render(PoseStack poseStack, int width, int height) {
        if (!initialized) {
            CreativeTabBulletRenderer.init(width, height);
        }
        CreativeTabBulletRenderer.update(height);
        Minecraft mc = Minecraft.getInstance();
        for (int layer = 0; layer < 3; ++layer) {
            for (FallingBullet bullet : bullets) {
                if (bullet.layer != layer) continue;
                poseStack.pushPose();
                poseStack.translate(bullet.x, bullet.y, (float)(100 + layer * 50));
                float scale = (float)bullet.size / 16.0f;
                poseStack.scale(scale, scale, scale);
                poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(bullet.rotation)));
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                mc.getItemRenderer().renderStatic(bullet.stack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, (MultiBufferSource)mc.renderBuffers().bufferSource(), (Level)mc.level, 0);
                poseStack.popPose();
            }
        }
    }

    public static void reset() {
        bullets.clear();
        initialized = false;
    }

    private static class FallingBullet {
        ItemStack stack;
        float x;
        float y;
        int layer;
        float rotation;
        float rotationSpeed;
        int size;
        float speed;

        private FallingBullet() {
        }
    }
}

