/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.utils;

import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.core.enums.BulletType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.interfaces.IMeleeGun;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.network.packets.S2C_Recoil_Packet;
import com.f708.anothergunmod.registry.entity.ModEntities;
import com.f708.anothergunmod.registry.entity.bullet.BulletBuilder;
import com.f708.anothergunmod.registry.entity.flamejet.FlameJetEntity;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.registry.particle.ModParticleTypes;
import com.f708.anothergunmod.registry.particle.flame.FlameJetParams;
import com.f708.anothergunmod.utils.AdvUtils;
import com.f708.anothergunmod.utils.ArmorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class GunUtils {
    static Random random = new Random();

    public static float getSpread(Player player, ItemStack gun) {
        float basicSpread = 0.02f;
        float additionalSpread = 0.0f;
        float tripod = (Boolean)gun.getOrDefault(ModDataComponents.IS_SUPPORTED, (Object)false) != false ? 0.02f : 0.0f;
        AbstractGunItem abstractGun = (AbstractGunItem)gun.getItem();
        WeaponType weaponType = abstractGun.weaponType();
        if (weaponType == WeaponType.AUTOGUN) {
            additionalSpread += 0.01f;
        }
        if (weaponType == WeaponType.SHOTGUN) {
            basicSpread = 0.12f;
        }
        if (weaponType == WeaponType.MACHINEGUN) {
            additionalSpread += 0.03f - tripod;
        }
        if (weaponType == WeaponType.RIFLE_SPYGLASS && !player.isShiftKeyDown()) {
            basicSpread += 0.05f;
        }
        if (player.isCrouching()) {
            basicSpread -= 0.02f;
        }
        if (player.isSwimming()) {
            basicSpread += 0.01f;
        }
        if (player.isFallFlying()) {
            basicSpread += 0.04f;
        }
        if (player.isSprinting()) {
            basicSpread += 0.01f;
        }
        return basicSpread + additionalSpread;
    }

    public static void performBulletSpawn(Player player, Level level, ItemStack gun) {
        AbstractGunItem abstractGun = (AbstractGunItem)gun.getItem();
        if (!abstractGun.canShoot(gun, player)) {
            return;
        }
        AmmoContainerRecord ammoContainer = abstractGun.getAmmoContainer(gun);
        ItemStack bullet = ammoContainer.getBullet(0);
        for (int i = 0; i < abstractGun.bulletAmountPerShot(gun); ++i) {
            new BulletBuilder(ModEntities.BULLET.get(), level, (LivingEntity)player, gun, GunUtils.getBulletType(bullet)).speed(4.0f).lifetime(100).spread(GunUtils.getSpread(player, gun), GunUtils.getSpread(player, gun), GunUtils.getSpread(player, gun)).damage(abstractGun.rangedDamage(gun)).spawn();
        }
        abstractGun.descreaseAmmo(gun);
        player.getCooldowns().addCooldown(gun.getItem(), abstractGun.fireRate(gun));
    }

    public static void performFlameJetSpawn(Player player, ServerLevel level, ItemStack gun) {
        Vec3 look = player.getLookAngle().normalize();
        Vec3 bodyMid = player.position().add(0.0, (double)player.getBbHeight() * 0.2, 0.0);
        Vec3 startPos = bodyMid.add(look.scale(0.6));
        Vec3 spread = new Vec3(0.05, 0.05, 0.05);
        FlameJetEntity.spawnBurst(level, (LivingEntity)player, spread, 0.1f, gun);
        AbstractGunItem abstractGunItem = (AbstractGunItem)gun.getItem();
        abstractGunItem.descreaseAmmo(gun);
    }

    public static void triggerRecoil(Player player, ItemStack gun) {
        Item item = gun.getItem();
        if (item instanceof AbstractGunItem) {
            AbstractGunItem abstractGunItem = (AbstractGunItem)item;
            WeaponType weaponType = abstractGunItem.weaponType();
            int yaw = 1;
            if (abstractGunItem.weaponType() == WeaponType.MACHINEGUN) {
                yaw += (Boolean)gun.getOrDefault(ModDataComponents.IS_SUPPORTED, (Object)false) != false ? 0 : 1;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new S2C_Recoil_Packet(2, (float)abstractGunItem.recoil(gun) * ArmorUtils.getRecoilMultiplierFromArmor(player), (float)yaw * ArmorUtils.getSpreadYawMultiplierFromArmor(player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void forceFirstPerson(Player player, ItemStack gun) {
        if (ModList.get().isLoaded("betterthirdperson") && player.level().isClientSide()) {
            Minecraft mc = Minecraft.getInstance();
            if (gun.is(ModItems.FLAMETHROWER.get())) {
                return;
            }
            if (mc.options.getCameraType() != CameraType.FIRST_PERSON) {
                mc.options.setCameraType(CameraType.FIRST_PERSON);
            }
        }
    }

    public static void triggerKnockback(Player player, ItemStack gun) {
        ServerPlayer serverPlayer;
        Vec3 knockback;
        Vec3 lookDir = player.getLookAngle();
        if (gun.is(ModItems.SHOTGUN.get())) {
            double strength = 0.5;
            if (!player.hasEffect(MobEffects.SLOW_FALLING)) {
                strength = 0.7;
            }
            knockback = new Vec3(-lookDir.x * (strength *= (double)ArmorUtils.shotgunKnockbackMultiplier(player)), 0.1, -lookDir.z * strength);
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                serverPlayer.setDeltaMovement(serverPlayer.getDeltaMovement().add(knockback));
                serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
            }
        }
        if (gun.is(ModItems.FLAMETHROWER.get())) {
            if (player.hasEffect(MobEffects.SLOW_FALLING)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer2 = (ServerPlayer)player;
                    AdvUtils.grant(serverPlayer2, ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"flamethrowerfly"));
                }
                float strength = player.isEyeInFluidType(Fluids.WATER.getFluidType()) ? 0.05f : 0.04f;
                Vec3 knockback2 = new Vec3(-lookDir.x * (double)(strength *= ArmorUtils.shotgunKnockbackMultiplier(player)), -lookDir.y * (double)strength, -lookDir.z * (double)strength);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer3 = (ServerPlayer)player;
                    serverPlayer3.setDeltaMovement(serverPlayer3.getDeltaMovement().add(knockback2));
                    serverPlayer3.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer3));
                }
            }
            if (player.isEyeInFluidType(Fluids.WATER.getFluidType())) {
                double strength = 0.05;
                knockback = new Vec3(-lookDir.x * strength, -lookDir.y * strength, -lookDir.z * strength);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    serverPlayer.setDeltaMovement(serverPlayer.getDeltaMovement().add(knockback));
                    serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
            }
        }
    }

    public static ItemStack findBestSmallMagazine(Player player) {
        return player.getInventory().items.stream().filter(stack -> stack.is(ModItems.SMALL_MAGAZINE.get())).max(Comparator.comparingInt(stack -> AmmoContainerRecord.getContainerFromComponent(stack).size())).orElse(ItemStack.EMPTY);
    }

    public static ItemStack findBestBigMagazine(Player player) {
        return player.getInventory().items.stream().filter(stack -> stack.is(ModItems.BIG_MAGAZINE.get())).max(Comparator.comparingInt(stack -> AmmoContainerRecord.getContainerFromComponent(stack).size())).orElse(ItemStack.EMPTY);
    }

    public static void handleSupportedPose(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ItemStack gun = stack;
        if (entity instanceof Player) {
            boolean eyeView;
            Player player = (Player)entity;
            for (InteractionHand h : InteractionHand.values()) {
                Item item = player.getItemInHand(h).getItem();
                if (!(item instanceof IMeleeGun)) continue;
                IMeleeGun iMeleeGun = (IMeleeGun)item;
                gun = player.getItemInHand(h);
            }
            if (gun == null) {
                return;
            }
            if (!player.isShiftKeyDown() && ((Boolean)gun.getOrDefault(ModDataComponents.IS_SUPPORTED, (Object)false)).booleanValue()) {
                gun.set(ModDataComponents.IS_SUPPORTED, (Object)false);
                return;
            }
            if (AbstractGunItem.holdingInnaporatedItem(player)) {
                return;
            }
            Vec3 leg = player.position().add(0.0, 0.5, 0.0);
            Vec3 eye = player.getEyePosition();
            Vec3 dis = player.getLookAngle();
            dis.scale(1.0);
            Vec3 endL = leg.add(dis);
            Vec3 endE = eye.add(dis.scale(3.0));
            ClipContext legClipContext = new ClipContext(leg, endL, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            ClipContext eyeClipContext = new ClipContext(eye, endE, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult legResult = player.level().clip(legClipContext);
            BlockHitResult eyeResult = player.level().clip(eyeClipContext);
            boolean legView = legResult.getType() == HitResult.Type.BLOCK;
            boolean bl = eyeView = eyeResult.getType() != HitResult.Type.BLOCK;
            if (legView && eyeView && player.isShiftKeyDown()) {
                if (legResult.getDirection() != Direction.DOWN && legResult.getDirection() != Direction.UP) {
                    gun.set(ModDataComponents.IS_SUPPORTED, (Object)true);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        AdvUtils.grant(serverPlayer, ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"fortified_position"));
                    }
                }
            } else {
                gun.set(ModDataComponents.IS_SUPPORTED, (Object)false);
            }
        }
    }

    public static void attachMagazine(ItemStack gun, ItemStack magazine) {
        Item item = gun.getItem();
        if (item instanceof AbstractGunItem) {
            AbstractGunItem abstractGunItem = (AbstractGunItem)item;
            AmmoContainerRecord magazineContainer = abstractGunItem.getAmmoContainer(magazine);
            if (!abstractGunItem.magazineAttached(gun)) {
                gun.set(ModDataComponents.AMMO_CONTAINER, (Object)magazineContainer);
                if (magazine.is(ModItems.BIG_MAGAZINE.get())) {
                    gun.set(ModDataComponents.BIGMAGAZINEATTACHED, (Object)true);
                }
                gun.set(ModDataComponents.MAGAZINEATTACHED, (Object)true);
            }
        }
    }

    public static void setOwner(Player player, ItemStack itemStack) {
        if (((String)itemStack.getOrDefault(ModDataComponents.OWNER, (Object)"")).isEmpty()) {
            itemStack.set(ModDataComponents.OWNER, (Object)player.getName().getString());
        }
    }

    public static int killAmount(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.KILL_COUNTER, (Object)0);
    }

    public static boolean containItem(Player player, Item item) {
        if (item == ModItems.SMALL_MAGAZINE.get()) {
            return player.getInventory().items.stream().anyMatch(stack -> stack.is(ModItems.SMALL_MAGAZINE.get()));
        }
        if (item == ModItems.BIG_MAGAZINE.get()) {
            return player.getInventory().items.stream().anyMatch(stack -> stack.is(ModItems.BIG_MAGAZINE.get()));
        }
        return player.getInventory().contains(item.getDefaultInstance());
    }

    public static int getItemSlot(Player player, Item item) {
        if (item == ModItems.SMALL_MAGAZINE.get()) {
            int bestSlot = -1;
            int maxBullets = 0;
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                AmmoContainerRecord container;
                int bullets;
                ItemStack stack = player.getInventory().getItem(i);
                if (!stack.is(ModItems.SMALL_MAGAZINE.get()) || (bullets = (container = AmmoContainerRecord.getContainerFromComponent(stack)).size()) <= maxBullets) continue;
                maxBullets = bullets;
                bestSlot = i;
            }
            return bestSlot;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!player.getInventory().getItem(i).is(item)) continue;
            return i;
        }
        return -1;
    }

    public static List<BulletType> getBulletType(ItemStack bullet) {
        return new ArrayList<BulletType>((Collection)bullet.getOrDefault(ModDataComponents.BULLET_TYPE, new ArrayList()));
    }

    public static boolean hasGunOnCooldown(Player player) {
        for (ItemStack stack : player.getInventory().items) {
            if (!(stack.getItem() instanceof AbstractGunItem) || !player.getCooldowns().isOnCooldown(stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public static void spawnFlameParticles(Level level, LivingEntity shooter) {
        InteractionHand activeHand = null;
        for (InteractionHand hand : InteractionHand.values()) {
            if (!shooter.getItemInHand(hand).is(ModItems.FLAMETHROWER.get())) continue;
            activeHand = hand;
            break;
        }
        if (activeHand == null) {
            return;
        }
        int side = activeHand == InteractionHand.MAIN_HAND ? 1 : -1;
        Vec3 look = shooter.getLookAngle().normalize();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 right = look.cross(up).normalize();
        Vec3 bodyMid = shooter.position().add(0.0, (double)shooter.getBbHeight() * 0.6, 0.0);
        Vec3 startPos = bodyMid.add(look.scale(0.5)).add(right.scale(0.3 * (double)side));
        Random rng = new Random();
        Vec3 dir = look.add(rng.nextGaussian() * 0.13, rng.nextGaussian() * 0.13 + 0.02, rng.nextGaussian() * 0.13).normalize().scale((double)FlameJetParams.INITIAL_SPEED);
        if (shooter.isEyeInFluidType(Fluids.WATER.getFluidType())) {
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, startPos.x, startPos.y, startPos.z, dir.x, dir.y, dir.z);
        } else {
            level.addParticle((ParticleOptions)ModParticleTypes.FLAME_PUFF.get(), startPos.x, startPos.y, startPos.z, dir.x, dir.y, dir.z);
        }
    }
}

