/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.utils;

import com.f708.anothergunmod.core.events.game.WeaponReloadEvent;
import com.f708.anothergunmod.core.events.game.WeaponShootEvent;
import com.f708.anothergunmod.network.packets.S2C_WeaponReloadEventPacket;
import com.f708.anothergunmod.network.packets.S2C_WeaponShootEventPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class WeaponEventSynchronizer {
    public static void syncShootEvent(WeaponShootEvent event, double radius) {
        Player sourcePlayer = event.getPlayer();
        Level level = sourcePlayer.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            S2C_WeaponShootEventPacket packet = new S2C_WeaponShootEventPacket(sourcePlayer.getUUID(), event.getWeaponType(), event.getHand(), sourcePlayer.level().getGameTime());
            for (ServerPlayer nearbyPlayer : serverLevel.players()) {
                if (!(nearbyPlayer.distanceToSqr((Entity)sourcePlayer) <= radius * radius)) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)nearbyPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void syncReloadEvent(WeaponReloadEvent event, double radius) {
        Player sourcePlayer = event.getPlayer();
        Level level = sourcePlayer.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            S2C_WeaponReloadEventPacket packet = new S2C_WeaponReloadEventPacket(sourcePlayer.getUUID(), event.getWeaponType(), event.getHand(), sourcePlayer.level().getGameTime());
            for (ServerPlayer nearbyPlayer : serverLevel.players()) {
                if (!(nearbyPlayer.distanceToSqr((Entity)sourcePlayer) <= radius * radius)) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)nearbyPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

