/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.mpatric.mp3agic.Mp3File;
import com.urlcustomdiscs.DenoSetup;
import com.urlcustomdiscs.DiscJsonManager;
import com.urlcustomdiscs.RemoteApiClient;
import com.urlcustomdiscs.SelfHostedManager;
import com.urlcustomdiscs.URLCustomDiscs;
import com.urlcustomdiscs.YtDlpManager;
import com.urlcustomdiscs.YtDlpSetup;
import com.urlcustomdiscs.utils.DiscUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class CommandURLCustomDiscs
implements CommandExecutor {
    private final URLCustomDiscs plugin;
    private final URLCustomDiscs.OS os;
    private final RemoteApiClient remoteApiClient;
    private final SelfHostedManager selfHostedManager;
    private final File discUuidFile;
    private final String pluginUsageMode;

    public CommandURLCustomDiscs(URLCustomDiscs plugin, URLCustomDiscs.OS os, RemoteApiClient remoteApiClient, SelfHostedManager selfHostedManager) {
        this.plugin = plugin;
        this.os = os;
        this.remoteApiClient = remoteApiClient;
        this.selfHostedManager = selfHostedManager;
        this.discUuidFile = new File(plugin.getDataFolder(), "discs.json");
        this.pluginUsageMode = plugin.getPluginUsageMode();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("help")) {
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage of the command " + String.valueOf(ChatColor.GOLD) + "/customdisc" + String.valueOf(ChatColor.YELLOW) + ":");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "Create a custom music disc from a YouTube URL or local MP3 file:");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/customdisc create " + String.valueOf(ChatColor.GOLD) + "<" + String.valueOf(ChatColor.YELLOW) + "URL" + String.valueOf(ChatColor.GOLD) + " OR " + String.valueOf(ChatColor.YELLOW) + "audio_name.mp3" + String.valueOf(ChatColor.GOLD) + "> <" + String.valueOf(ChatColor.YELLOW) + "disc_name" + String.valueOf(ChatColor.GOLD) + "> <" + String.valueOf(ChatColor.YELLOW) + "mono" + String.valueOf(ChatColor.GOLD) + " / " + String.valueOf(ChatColor.YELLOW) + "stereo" + String.valueOf(ChatColor.GOLD) + ">");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "- mono: enables spatial audio (as when played in a jukebox)");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "- stereo: plays the audio in the traditional way");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Instructions for local MP3 files (admin-only):");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "- Place your MP3 file inside the audio_to_send folder in the plugin directory");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "- Rename the MP3 file to a simple name with no spaces and no special characters.");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "- Don't forget to include the .mp3 extension in the audio_name.mp3 field.");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "Give yourself a custom music disc:");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/customdisc give " + String.valueOf(ChatColor.GOLD) + "<" + String.valueOf(ChatColor.YELLOW) + "disc_name" + String.valueOf(ChatColor.GOLD) + ">");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "Show the list of custom music discs (clickable names):");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/customdisc list");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "Delete a custom music disc:");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/customdisc delete " + String.valueOf(ChatColor.GOLD) + "<" + String.valueOf(ChatColor.YELLOW) + "disc_name" + String.valueOf(ChatColor.GOLD) + ">");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "Show details of the custom music disc you're holding:");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/customdisc info");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "Update Deno and yt-dlp dependencies:");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/customdisc updatedep");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(ChatColor.BOLD) + "Other useful vanilla commands:");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "/playsound minecraft:customdisc." + String.valueOf(ChatColor.DARK_AQUA) + "<" + String.valueOf(ChatColor.AQUA) + "disc_name" + String.valueOf(ChatColor.DARK_AQUA) + "> " + String.valueOf(ChatColor.AQUA) + "ambient @a ~ ~ ~ 1 1");
            player.sendMessage("");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "/stopsound @a * minecraft:customdisc." + String.valueOf(ChatColor.DARK_AQUA) + "<" + String.valueOf(ChatColor.AQUA) + "disc_name" + String.valueOf(ChatColor.DARK_AQUA) + ">");
            player.sendMessage("");
            return true;
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("create")) {
            String input = args[1];
            String rawDiscName = args[2].replaceAll("[^a-zA-Z0-9_-]", "_");
            String audioType = args[3].toLowerCase();
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Processing audio...");
            try {
                new URL(input);
                if ("api".equalsIgnoreCase(this.pluginUsageMode) && this.plugin.getLocalYtDlp().booleanValue() || "self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        YtDlpManager ytDlpManager = new YtDlpManager(this.plugin, this.os);
                        File mp3File = new File(this.plugin.getAudioFolder(), rawDiscName + ".mp3");
                        boolean downloaded = ytDlpManager.downloadAudioWithYtDlp(input, mp3File);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                            if (!downloaded || !mp3File.exists()) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Failed to download audio from the URL using yt-dlp.");
                                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Attempting to update Deno and yt-dlp...");
                                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                                    new DenoSetup(this.plugin, this.os).setup();
                                    new YtDlpSetup(this.plugin, this.os).setup();
                                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                                        boolean retried = ytDlpManager.downloadAudioWithYtDlp(input, mp3File);
                                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                                            if (!retried || !mp3File.exists()) {
                                                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Download failed even after updating yt-dlp.");
                                                return;
                                            }
                                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Audio downloaded after updating yt-dlp.");
                                            this.continueDiscCreation(player, mp3File.getName(), rawDiscName, audioType);
                                        });
                                    });
                                });
                            }
                            this.continueDiscCreation(player, mp3File.getName(), rawDiscName, audioType);
                        });
                    });
                } else {
                    this.continueDiscCreation(player, input, rawDiscName, audioType);
                }
                return true;
            }
            catch (MalformedURLException e) {
                File localMp3 = new File(this.plugin.getAudioToSendFolder(), input);
                if (localMp3.exists() && localMp3.isFile() && input.toLowerCase().endsWith(".mp3")) {
                    block39: {
                        if ("api".equalsIgnoreCase(this.pluginUsageMode)) {
                            long maxSize = 0xC00000L;
                            if (localMp3.length() > maxSize) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "The audio file exceeds the maximum allowed size of 12MB.");
                                return true;
                            }
                            try {
                                Mp3File mp3file = new Mp3File(localMp3);
                                long durationSeconds = mp3file.getLengthInSeconds();
                                if (durationSeconds > 300L) {
                                    player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "The audio file exceeds the maximum allowed length of 5 minutes.");
                                    return true;
                                }
                                break block39;
                            }
                            catch (Exception ex) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Unable to read the duration of the audio file.");
                                return true;
                            }
                        }
                        if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
                            File destFile = new File(this.plugin.getTempAudioFolder(), input);
                            try {
                                Files.move(localMp3.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e1) {
                                this.plugin.getLogger().severe("Exception: " + e.getMessage());
                                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Failed to move the MP3 file to temp_audio.");
                                return true;
                            }
                        }
                    }
                    this.continueDiscCreation(player, input, rawDiscName, audioType);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Invalid input: not a valid URL or .mp3 file in the audio_to_send folder.");
                    player.sendMessage(String.valueOf(ChatColor.GOLD) + "Usage: " + String.valueOf(ChatColor.YELLOW) + "/customdisc help");
                }
                return true;
            }
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            String discName = args[1].toLowerCase().replaceAll(" ", "_");
            this.giveCustomMusicDisc(player, discName);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
            JSONObject discData = DiscUtils.loadDiscData(this.discUuidFile);
            if (discData.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No custom music disc found. Create a disc first (/customdisc help).");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "List of custom music discs:");
            ArrayList<String> discNames = new ArrayList<String>(discData.keySet());
            Collections.sort(discNames);
            for (String discName : discNames) {
                JSONObject discInfo = discData.getJSONObject(discName);
                String displayName = discInfo.getString("displayName");
                TextComponent discText = this.createDiscTextComponent(displayName);
                player.spigot().sendMessage((BaseComponent)discText);
            }
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("delete")) {
            JSONObject discData = DiscUtils.loadDiscData(this.discUuidFile);
            if (discData.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No custom disc found. Create a custom disc first (/customdisc help).");
                return true;
            }
            String discName = args[1].toLowerCase();
            DiscJsonManager discManager = new DiscJsonManager(this.plugin);
            JSONObject discInfo = null;
            try {
                discInfo = discManager.getDisc(discName);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Exception: " + e.getMessage());
            }
            if (discInfo == null || discInfo.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Custom disc '" + discName + "' does not exist.");
                return true;
            }
            JSONObject discInfoFinal = discInfo;
            if (this.pluginUsageMode.equalsIgnoreCase("api")) {
                String token = this.plugin.getToken();
                if (token == null || token.isEmpty()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No token configured. Please register your server first by creating a custom disc.");
                    return true;
                }
                String minecraftServerVersion = this.plugin.getMinecraftServerVersion();
                this.remoteApiClient.deleteCustomDiscRemotely(player, discName, discInfoFinal, token, minecraftServerVersion);
                return true;
            }
            if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
                this.selfHostedManager.deleteCustomDisc(player, discName, discInfoFinal);
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Invalid plugin usage mode: " + this.pluginUsageMode + ". Please set the plugin usage mode to 'api', 'self-hosted' or 'edit-only' in the config.yml file.");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("info")) {
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand.hasItemMeta()) {
                ItemMeta meta = itemInHand.getItemMeta();
                if (meta != null && meta.hasCustomModelData()) {
                    int customModelData = meta.getCustomModelData();
                    JSONObject discData = DiscUtils.loadDiscData(this.discUuidFile);
                    String discName = DiscUtils.getDiscNameFromCustomModelData(discData, customModelData);
                    if (discName != null) {
                        JSONObject discInfo = discData.getJSONObject(discName);
                        String displayName = discInfo.getString("displayName");
                        String discUUID = discInfo.getString("uuid");
                        String soundKey = "customdisc." + discName.toLowerCase().replaceAll(" ", "_");
                        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Disc played: " + String.valueOf(ChatColor.GOLD) + discName);
                        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Display name: " + String.valueOf(ChatColor.GOLD) + displayName);
                        player.sendMessage(String.valueOf(ChatColor.GRAY) + "UUID: " + String.valueOf(ChatColor.GOLD) + discUUID);
                        player.sendMessage(String.valueOf(ChatColor.GRAY) + "CustomModelData: " + String.valueOf(ChatColor.GOLD) + customModelData);
                        player.sendMessage(String.valueOf(ChatColor.GRAY) + "SoundKey: " + String.valueOf(ChatColor.GOLD) + soundKey);
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No custom music disc found with this CustomModelData.");
                    }
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "You must be holding a custom music disc.");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "You must be holding a custom music disc.");
            }
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("updatedep")) {
            if ("api".equalsIgnoreCase(this.pluginUsageMode) && !this.plugin.getLocalYtDlp().booleanValue()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error: local yt-dlp is disabled. This feature is required to download audio from URLs using the server's local yt-dlp installation instead of the remote API. To enable it, open the config.yml file, set 'localYtDlp: true', and restart the server.");
                return true;
            }
            if ("api".equalsIgnoreCase(this.pluginUsageMode) && this.plugin.getLocalYtDlp().booleanValue() || "self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Checking for Deno and yt-dlp updates...");
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    DenoSetup denoSetup = new DenoSetup(this.plugin, this.os);
                    try {
                        denoSetup.setup();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Deno update check finished. See console for details.");
                    }
                    catch (Exception e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Failed to update Deno: " + e.getMessage());
                    }
                    YtDlpSetup ytDlpSetup = new YtDlpSetup(this.plugin, this.os);
                    try {
                        ytDlpSetup.setup();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "yt-dlp update check finished. See console for details.");
                    }
                    catch (Exception e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Failed to update yt-dlp: " + e.getMessage());
                    }
                });
                return true;
            }
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "Usage: " + String.valueOf(ChatColor.YELLOW) + "/customdisc help");
        return true;
    }

    private void continueDiscCreation(Player player, String finalAudioIdentifier, String displayName, String audioType) {
        String discName = displayName.toLowerCase();
        DiscJsonManager discManager = new DiscJsonManager(this.plugin);
        JSONObject discInfo = null;
        try {
            discInfo = discManager.getOrCreateDisc(discName, displayName);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Exception: " + e.getMessage());
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error creating disc information.");
        }
        JSONObject discInfoFinal = discInfo;
        String minecraftServerVersion = this.plugin.getMinecraftServerVersion();
        if (this.pluginUsageMode.equalsIgnoreCase("api")) {
            if (this.plugin.getToken().isEmpty()) {
                this.remoteApiClient.requestTokenFromRemoteServer(player, minecraftServerVersion, () -> this.remoteApiClient.createCustomDiscRemotely(player, finalAudioIdentifier, discName, audioType, discInfoFinal, this.plugin.getToken(), minecraftServerVersion));
            } else {
                this.remoteApiClient.createCustomDiscRemotely(player, finalAudioIdentifier, discName, audioType, discInfoFinal, this.plugin.getToken(), minecraftServerVersion);
            }
        } else if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            this.selfHostedManager.createCustomDisc(player, finalAudioIdentifier, discName, audioType, discInfoFinal);
        }
    }

    private void giveCustomMusicDisc(Player player, String discName) {
        try {
            if (!this.discUuidFile.exists()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No custom music disc found. Create a disc first (/customdisc help).");
                return;
            }
            String content = Files.readString(this.discUuidFile.toPath());
            JSONObject discData = new JSONObject(content);
            if (!discData.has(discName)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "The disc '" + discName + "' doesn't exist.");
                return;
            }
            JSONObject discInfo = discData.getJSONObject(discName);
            int customModelData = discInfo.getInt("customModelData");
            String displayName = discInfo.getString("displayName");
            ItemStack disc = new ItemStack(Material.MUSIC_DISC_13);
            ItemMeta meta = disc.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.GOLD) + displayName);
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Custom music disc: " + displayName)));
                meta.setLore(lore);
                meta.setCustomModelData(Integer.valueOf(customModelData));
                disc.setItemMeta(meta);
            }
            player.getInventory().addItem(new ItemStack[]{disc});
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Custom disc " + String.valueOf(ChatColor.GOLD) + displayName + String.valueOf(ChatColor.GRAY) + " added to your inventory.");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Exception: " + e.getMessage());
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error recovering the custom disc.");
        }
    }

    private TextComponent createDiscTextComponent(String displayName) {
        TextComponent discText = new TextComponent(displayName);
        discText.setColor(net.md_5.bungee.api.ChatColor.GOLD);
        discText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/customdisc give " + displayName));
        discText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Text(String.valueOf(ChatColor.YELLOW) + "Click to get this disc!")));
        return discText;
    }
}

