/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.URLCustomDiscs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class DenoSetup {
    private final JavaPlugin plugin;
    private final URLCustomDiscs.OS os;
    private final File denoFile;

    public DenoSetup(JavaPlugin plugin, URLCustomDiscs.OS os) {
        this.plugin = plugin;
        this.os = os;
        File binDir = new File(plugin.getDataFolder(), "bin");
        String denoName = switch (os) {
            case URLCustomDiscs.OS.WINDOWS_X64, URLCustomDiscs.OS.WINDOWS_ARM64 -> "deno.exe";
            case URLCustomDiscs.OS.LINUX_X64, URLCustomDiscs.OS.LINUX_ARM64, URLCustomDiscs.OS.LINUX_ARMV7, URLCustomDiscs.OS.LINUX_MUSL_X64, URLCustomDiscs.OS.LINUX_MUSL_ARM64 -> "deno";
            default -> throw new IllegalStateException("Unsupported OS: " + String.valueOf((Object)os));
        };
        this.denoFile = new File(binDir, denoName);
    }

    public void setup() {
        try {
            String localVersion = this.getLocalVersion();
            String latestVersion = this.fetchLatestVersion();
            this.plugin.getLogger().info("[SETUP] Local Deno version: " + (localVersion == null ? "none" : localVersion));
            this.plugin.getLogger().info("[SETUP] Latest Deno version: " + latestVersion);
            if (localVersion == null || !localVersion.equals(latestVersion)) {
                this.plugin.getLogger().info("[SETUP] Updating Deno...");
                if (this.denoFile.exists()) {
                    this.denoFile.delete();
                }
                String downloadUrl = switch (this.os) {
                    case URLCustomDiscs.OS.WINDOWS_X64, URLCustomDiscs.OS.WINDOWS_ARM64 -> "https://github.com/denoland/deno/releases/latest/download/deno-x86_64-pc-windows-msvc.zip";
                    case URLCustomDiscs.OS.LINUX_X64 -> "https://github.com/denoland/deno/releases/latest/download/deno-x86_64-unknown-linux-gnu.zip";
                    case URLCustomDiscs.OS.LINUX_ARM64 -> "https://github.com/denoland/deno/releases/latest/download/deno-aarch64-unknown-linux-gnu.zip";
                    case URLCustomDiscs.OS.LINUX_ARMV7 -> "https://github.com/denoland/deno/releases/latest/download/deno-armv7-unknown-linux-gnueabihf.zip";
                    case URLCustomDiscs.OS.LINUX_MUSL_X64 -> "https://github.com/denoland/deno/releases/latest/download/deno-x86_64-unknown-linux-musl.zip";
                    case URLCustomDiscs.OS.LINUX_MUSL_ARM64 -> "https://github.com/denoland/deno/releases/latest/download/deno-aarch64-unknown-linux-musl.zip";
                    default -> throw new IllegalStateException("Unsupported OS/architecture combination: " + String.valueOf((Object)this.os));
                };
                File zipFile = new File(this.denoFile.getParentFile(), this.denoFile.getName() + ".zip");
                this.downloadFile(downloadUrl, zipFile);
                this.unzipSingleFile(zipFile, this.denoFile.getName(), this.denoFile);
                if (!zipFile.delete()) {
                    this.plugin.getLogger().warning("[SETUP] Could not delete " + zipFile.getName());
                }
                if (!this.denoFile.setExecutable(true)) {
                    this.plugin.getLogger().warning("[SETUP] Could not set Deno as executable.");
                }
                this.plugin.getLogger().info("[SETUP] Deno updated.");
            } else {
                this.plugin.getLogger().info("[SETUP] Deno is up-to-date.");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[SETUP] Failed to setup Deno: " + e.getMessage());
        }
    }

    private String getLocalVersion() {
        if (!this.denoFile.exists()) {
            return null;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(this.denoFile.getAbsolutePath(), "--version");
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String version = reader.readLine();
            p.waitFor();
            return version != null ? version.trim() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String fetchLatestVersion() throws IOException {
        HttpURLConnection connection = DenoSetup.openHttpConnection("https://api.github.com/repos/denoland/deno/releases/latest", 5000, 5000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            int end;
            String line;
            StringBuilder json = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
            int idx = json.indexOf("\"tag_name\"");
            if (idx == -1) {
                throw new IOException("Invalid GitHub API response: tag_name missing");
            }
            int start = json.indexOf("\"", idx + 10);
            String tagName = json.substring(start + 1, end = json.indexOf("\"", start + 1));
            String string = tagName.startsWith("v") ? tagName.substring(1) : tagName;
            return string;
        }
    }

    private void downloadFile(String urlString, File destination) throws IOException {
        this.plugin.getLogger().info("[SETUP] Downloading " + urlString);
        HttpURLConnection connection = DenoSetup.openHttpConnection(urlString, 15000, 15000);
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(destination);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unzipSingleFile(File zipFile, String fileNameInZip, File targetFile) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().endsWith(fileNameInZip)) continue;
                targetFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(targetFile);
                try {
                    zis.transferTo(fos);
                    return;
                }
                finally {
                    fos.close();
                    return;
                }
            }
        }
    }

    @NotNull
    private static HttpURLConnection openHttpConnection(String urlString, int connectTimeout, int readTimeout) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", "JavaPlugin");
        connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed request to " + urlString + ", HTTP " + connection.getResponseCode());
        }
        return connection;
    }
}

