/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONObject;

public class DiscJsonManager {
    private final JavaPlugin plugin;
    private final File discUuidFile;

    public DiscJsonManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.discUuidFile = new File(plugin.getDataFolder(), "discs.json");
    }

    public JSONObject getOrCreateDisc(String discName, String displayName) throws IOException {
        JSONObject discData = this.loadDiscData();
        if (discData.has(discName)) {
            return discData.getJSONObject(discName);
        }
        String newUUID = UUID.randomUUID().toString();
        JSONObject discInfo = new JSONObject();
        discInfo.put("uuid", newUUID);
        int rawModelData = (int)(Long.parseLong(newUUID.replace("-", "").substring(0, 8), 16) & 0x7FFFFFL);
        int customModelData = rawModelData / 16 * 16;
        discInfo.put("customModelData", customModelData);
        this.plugin.getLogger().info("Generated customModelData: " + customModelData);
        discInfo.put("displayName", displayName);
        discData.put(discName, discInfo);
        this.saveDiscData(discData);
        return discInfo;
    }

    public JSONObject getDisc(String discName) throws IOException {
        JSONObject discData = this.loadDiscData();
        return discData.optJSONObject(discName);
    }

    public void deleteDisc(String discName) throws IOException {
        JSONObject discData = this.loadDiscData();
        if (discData.has(discName)) {
            discData.remove(discName);
            this.saveDiscData(discData);
        }
    }

    private JSONObject loadDiscData() throws IOException {
        if (this.discUuidFile.exists()) {
            String content = Files.readString(this.discUuidFile.toPath());
            return new JSONObject(content);
        }
        return new JSONObject();
    }

    private void saveDiscData(JSONObject discData) throws IOException {
        Files.writeString(this.discUuidFile.toPath(), (CharSequence)discData.toString(4), new OpenOption[0]);
    }

    public void deleteDiscFile() {
        if (this.discUuidFile.exists() && !this.discUuidFile.delete()) {
            this.plugin.getLogger().warning("Failed to delete discs.json file. You must delete this file manually from the plugin's URLCustomDisc folder, then restart your Minecraft server.");
        }
    }
}

