/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.URLCustomDiscs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Stream;

public class FFmpegManager {
    private final URLCustomDiscs plugin;
    private final File ffmpegFile;

    public FFmpegManager(URLCustomDiscs plugin, URLCustomDiscs.OS os) {
        this.plugin = plugin;
        File binDir = plugin.getBinFolder();
        File ffmpegDir = new File(binDir, "FFmpeg");
        String ffmpegName = switch (os) {
            case URLCustomDiscs.OS.WINDOWS_X64, URLCustomDiscs.OS.WINDOWS_ARM64 -> "ffmpeg.exe";
            case URLCustomDiscs.OS.LINUX_X64, URLCustomDiscs.OS.LINUX_ARM64, URLCustomDiscs.OS.LINUX_ARMV7, URLCustomDiscs.OS.LINUX_MUSL_X64, URLCustomDiscs.OS.LINUX_MUSL_ARM64 -> "ffmpeg";
            default -> null;
        };
        try {
            this.ffmpegFile = this.findFile(ffmpegDir, ffmpegName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean convertAudioWithFFmpeg(String inputFileMP3, File outputFileOggVorbis, String audioType) {
        File mp3File = new File(this.plugin.getTempAudioFolder(), inputFileMP3);
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.ffmpegFile.getAbsolutePath());
            command.add("-y");
            command.add("-i");
            command.add(String.valueOf(mp3File));
            command.add("-vn");
            if ("mono".equalsIgnoreCase(audioType)) {
                command.add("-ac");
                command.add("1");
            }
            command.add("-c:a");
            command.add("libvorbis");
            command.add(outputFileOggVorbis.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.plugin.getLogger().info("[FFmpeg] " + line);
                }
            }
            int exitCode = process.waitFor();
            return exitCode == 0 && outputFileOggVorbis.exists();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Exception: " + e.getMessage());
            this.plugin.getLogger().severe("[FFmpeg] Failed to run FFmpeg: " + e.getMessage());
            return false;
        }
    }

    private File findFile(File dir, String name) throws IOException {
        try (Stream<Path> files = Files.walk(dir.toPath(), new FileVisitOption[0]);){
            File file = files.filter(p -> p.toFile().isFile()).filter(p -> p.getFileName().toString().equalsIgnoreCase(name)).map(Path::toFile).findFirst().orElse(null);
            return file;
        }
    }
}

