/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.URLCustomDiscs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.tukaani.xz.XZInputStream;

public class FFmpegSetup {
    private final URLCustomDiscs plugin;
    private final URLCustomDiscs.OS os;
    private final File binDir;
    private final File ffmpegDir;

    FFmpegSetup(URLCustomDiscs plugin, URLCustomDiscs.OS os) {
        this.plugin = plugin;
        this.os = os;
        this.binDir = new File(plugin.getDataFolder(), "bin");
        this.ffmpegDir = new File(this.binDir, "FFmpeg");
    }

    public void setup() {
        try {
            if (this.ffmpegDir.exists()) {
                ffmpegFile = this.detectExecutable(this.ffmpegDir);
                if (ffmpegFile != null && ffmpegFile.exists()) {
                    this.plugin.getLogger().info("[SETUP] FFmpeg is already installed.");
                    return;
                }
                this.plugin.getLogger().warning("[SETUP] FFmpeg folder exists but executable is missing, re-downloading...");
            }
            this.plugin.getLogger().info("[SETUP] Downloading FFmpeg...");
            String downloadUrl = switch (this.os) {
                case URLCustomDiscs.OS.WINDOWS_X64, URLCustomDiscs.OS.WINDOWS_ARM64 -> "https://github.com/BtbN/FFmpeg-Builds/releases/download/latest/ffmpeg-master-latest-win64-gpl-shared.zip";
                case URLCustomDiscs.OS.LINUX_X64, URLCustomDiscs.OS.LINUX_MUSL_X64 -> "https://johnvansickle.com/ffmpeg/releases/ffmpeg-release-amd64-static.tar.xz";
                case URLCustomDiscs.OS.LINUX_ARM64, URLCustomDiscs.OS.LINUX_MUSL_ARM64 -> "https://johnvansickle.com/ffmpeg/releases/ffmpeg-release-arm64-static.tar.xz";
                case URLCustomDiscs.OS.LINUX_ARMV7 -> "https://johnvansickle.com/ffmpeg/releases/ffmpeg-release-armhf-static.tar.xz";
                default -> throw new IllegalStateException("Unsupported OS: " + String.valueOf((Object)this.os));
            };
            File archive = this.os == URLCustomDiscs.OS.WINDOWS_X64 || this.os == URLCustomDiscs.OS.WINDOWS_ARM64 ? new File(this.binDir, "ffmpeg.zip") : new File(this.binDir, "ffmpeg.tar.xz");
            this.downloadFile(downloadUrl, archive);
            File ffmpegFile = switch (this.os) {
                case URLCustomDiscs.OS.WINDOWS_X64, URLCustomDiscs.OS.WINDOWS_ARM64 -> {
                    this.unzip(archive, this.ffmpegDir);
                    yield this.findFile(this.ffmpegDir, "ffmpeg.exe");
                }
                case URLCustomDiscs.OS.LINUX_X64, URLCustomDiscs.OS.LINUX_MUSL_X64, URLCustomDiscs.OS.LINUX_ARM64, URLCustomDiscs.OS.LINUX_MUSL_ARM64, URLCustomDiscs.OS.LINUX_ARMV7 -> {
                    this.untarXz(archive, this.ffmpegDir);
                    yield this.findFile(this.ffmpegDir, "ffmpeg");
                }
                default -> throw new IllegalStateException("Unsupported OS for extraction: " + String.valueOf((Object)this.os));
            };
            if (archive.exists() && archive.delete()) {
                this.plugin.getLogger().info("[SETUP] Deleted archive: " + archive.getName());
            } else {
                this.plugin.getLogger().warning("[SETUP] Could not delete archive: " + archive.getName());
            }
            if (ffmpegFile == null || !ffmpegFile.exists()) {
                throw new IOException("FFmpeg executable not found after extraction!");
            }
            if (!ffmpegFile.setExecutable(true)) {
                this.plugin.getLogger().warning("[SETUP] Could not set FFmpeg as executable (usually fine on Windows).");
            }
            this.plugin.getLogger().info("[SETUP] FFmpeg is installed");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Exception: " + e.getMessage());
            this.plugin.getLogger().warning("[SETUP] Failed to setup FFmpeg: " + e.getMessage());
        }
    }

    private void downloadFile(String urlString, File destination) throws IOException {
        this.plugin.getLogger().info("[SETUP] Downloading " + urlString);
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(true);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to download file: HTTP " + connection.getResponseCode());
        }
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(destination);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
    }

    private void unzip(File zipFile, File targetDir) throws IOException {
        targetDir.mkdirs();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = entry.getName();
                String[] pathParts = entryName.split("/", 2);
                if (pathParts.length < 2) continue;
                String relativePath = pathParts[1];
                File newFile = new File(targetDir, relativePath);
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    zis.transferTo(fos);
                }
            }
        }
    }

    private void untarXz(File tarXzFile, File targetDir) throws IOException {
        targetDir.mkdirs();
        try (FileInputStream fis = new FileInputStream(tarXzFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             XZInputStream xzis = new XZInputStream(bis);){
            this.extractTar(xzis, targetDir);
        }
    }

    private void extractTar(InputStream tarStream, File targetDir) throws IOException {
        String fileName;
        byte[] header;
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = this.readFully(tarStream, header = new byte[512])) >= 512 && !this.isZeroBlock(header) && !(fileName = this.parseString(header, 0, 100).trim()).isEmpty()) {
            long size;
            String fileMode = this.parseString(header, 100, 8).trim();
            String fileSize = this.parseString(header, 124, 12).trim();
            String fileType = this.parseString(header, 156, 1);
            if (fileName.equals("././@PaxHeader") || fileName.startsWith("PaxHeader/")) {
                size = this.parseOctal(fileSize);
                if (size <= 0L) continue;
                this.skipBytes(tarStream, size);
                long padding = (512L - size % 512L) % 512L;
                this.skipBytes(tarStream, padding);
                continue;
            }
            size = this.parseOctal(fileSize);
            String[] pathParts = fileName.split("/", 2);
            if (pathParts.length < 2) continue;
            String relativePath = pathParts[1];
            File newFile = new File(targetDir, relativePath);
            if (fileType.equals("5") || fileName.endsWith("/")) {
                newFile.mkdirs();
                continue;
            }
            if (fileType.equals("0") || fileType.isEmpty()) {
                File parentDir = newFile.getParentFile();
                if (parentDir != null && !parentDir.exists()) {
                    parentDir.mkdirs();
                }
                try (FileOutputStream fos = new FileOutputStream(newFile);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    int read;
                    for (long remaining = size; remaining > 0L; remaining -= (long)read) {
                        int toRead = (int)Math.min((long)buffer.length, remaining);
                        read = tarStream.read(buffer, 0, toRead);
                        if (read <= 0) {
                            break;
                        }
                        bos.write(buffer, 0, read);
                    }
                }
                if (!fileMode.isEmpty()) {
                    try {
                        int mode = Integer.parseInt(fileMode, 8);
                        newFile.setExecutable((mode & 0x49) != 0);
                        newFile.setReadable((mode & 0x124) != 0);
                        newFile.setWritable((mode & 0x92) != 0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            long padding = (512L - size % 512L) % 512L;
            this.skipBytes(tarStream, padding);
        }
    }

    private int readFully(InputStream is, byte[] buffer) throws IOException {
        int read;
        int totalRead = 0;
        for (int remaining = buffer.length; remaining > 0 && (read = is.read(buffer, totalRead, remaining)) > 0; remaining -= read) {
            totalRead += read;
        }
        return totalRead;
    }

    private boolean isZeroBlock(byte[] block) {
        for (byte b : block) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    private String parseString(byte[] buffer, int offset, int length) {
        int end = offset;
        for (int i = offset; i < offset + length && i < buffer.length && buffer[i] != 0; ++i) {
            end = i + 1;
        }
        return new String(buffer, offset, end - offset);
    }

    private long parseOctal(String octalString) {
        if (octalString == null || octalString.trim().isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(octalString.trim(), 8);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private void skipBytes(InputStream is, long bytesToSkip) throws IOException {
        int toRead;
        int read;
        byte[] skipBuffer = new byte[8192];
        for (long remaining = bytesToSkip; remaining > 0L && (read = is.read(skipBuffer, 0, toRead = (int)Math.min((long)skipBuffer.length, remaining))) > 0; remaining -= (long)read) {
        }
    }

    private File findFile(File dir, String name) throws IOException {
        try (Stream<Path> files = Files.walk(dir.toPath(), new FileVisitOption[0]);){
            File file = files.filter(p -> p.toFile().isFile()).filter(p -> p.getFileName().toString().equalsIgnoreCase(name)).map(Path::toFile).findFirst().orElse(null);
            return file;
        }
    }

    private File detectExecutable(File ffmpegDir) throws IOException {
        return switch (this.os) {
            case URLCustomDiscs.OS.WINDOWS_X64, URLCustomDiscs.OS.WINDOWS_ARM64 -> this.findFile(ffmpegDir, "ffmpeg.exe");
            case URLCustomDiscs.OS.LINUX_X64, URLCustomDiscs.OS.LINUX_MUSL_X64, URLCustomDiscs.OS.LINUX_ARM64, URLCustomDiscs.OS.LINUX_MUSL_ARM64, URLCustomDiscs.OS.LINUX_ARMV7 -> this.findFile(ffmpegDir, "ffmpeg");
            default -> null;
        };
    }
}

