/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.JukeboxMessageInterceptor;
import com.urlcustomdiscs.URLCustomDiscs;
import com.urlcustomdiscs.utils.DiscUtils;
import com.urlcustomdiscs.utils.MinecraftServerVersionUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.json.JSONObject;

public class JukeboxListener
implements Listener {
    private final URLCustomDiscs plugin;
    private final Map<Location, Set<String>> activeJukeboxes = new HashMap<Location, Set<String>>();
    private final Map<Location, ItemStack> customDiscsInJukeboxes = new HashMap<Location, ItemStack>();
    private final JukeboxMessageInterceptor messageInterceptor;
    private final boolean protocolLibEnabled;

    public JukeboxListener(URLCustomDiscs plugin, boolean protocolLibEnabled) {
        this.plugin = plugin;
        this.protocolLibEnabled = protocolLibEnabled;
        this.messageInterceptor = protocolLibEnabled ? new JukeboxMessageInterceptor(plugin) : null;
    }

    @EventHandler
    public void onJukeboxPlay(PlayerInteractEvent event) {
        block17: {
            int customModelData;
            String discName;
            ItemMeta meta;
            if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (event.getClickedBlock() == null || event.getClickedBlock().getType() != Material.JUKEBOX) {
                return;
            }
            if (event.getHand() != EquipmentSlot.HAND) {
                return;
            }
            File discUuidFile = new File(this.plugin.getDataFolder(), "discs.json");
            JSONObject discData = DiscUtils.loadDiscData(discUuidFile);
            Block jukeboxBlock = event.getClickedBlock();
            Jukebox jukebox = (Jukebox)jukeboxBlock.getState();
            Location jukeboxLocation = jukebox.getLocation();
            ItemStack currentRecord = this.getCurrentRecordCompatibility(jukebox);
            Set<String> activeSounds = this.activeJukeboxes.get(jukeboxLocation);
            ItemStack customDisc = this.customDiscsInJukeboxes.get(jukeboxLocation);
            ItemStack itemInHand = event.getItem();
            Player player = event.getPlayer();
            if (currentRecord.getType() != Material.AIR) {
                this.customDiscsInJukeboxes.remove(jukeboxLocation);
                return;
            }
            if (activeSounds != null && !activeSounds.isEmpty()) {
                if (!player.isSneaking() && itemInHand != null && itemInHand.getType().isBlock()) {
                    event.setCancelled(true);
                }
                if (player.isSneaking() && itemInHand != null) {
                    return;
                }
                player.swingMainHand();
                if (itemInHand != null && itemInHand.getType().isRecord()) {
                    event.setCancelled(true);
                }
                for (String currentSoundKey : activeSounds) {
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "execute positioned " + jukeboxLocation.getBlockX() + " " + jukeboxLocation.getBlockY() + " " + jukeboxLocation.getBlockZ() + " run stopsound @a[distance=..80] * minecraft:" + currentSoundKey);
                }
                activeSounds.clear();
                this.dropCustomDisc(jukeboxLocation, customDisc);
                this.customDiscsInJukeboxes.remove(jukeboxLocation);
                return;
            }
            if (itemInHand != null && itemInHand.getType() == Material.MUSIC_DISC_13 && itemInHand.hasItemMeta() && !player.isSneaking() && (meta = itemInHand.getItemMeta()) != null && meta.hasCustomModelData() && (discName = DiscUtils.getDiscNameFromCustomModelData(discData, customModelData = meta.getCustomModelData())) != null) {
                event.setCancelled(true);
                try {
                    String soundKey = "customdisc." + discName;
                    ItemStack discToStore = itemInHand.clone();
                    discToStore.setAmount(1);
                    this.customDiscsInJukeboxes.put(jukeboxLocation, discToStore);
                    if (player.getGameMode() != GameMode.CREATIVE) {
                        if (itemInHand.getAmount() > 1) {
                            itemInHand.setAmount(itemInHand.getAmount() - 1);
                        } else {
                            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                        }
                    }
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                        jukebox.getWorld().playSound(jukeboxLocation, soundKey, SoundCategory.RECORDS, 4.0f, 1.0f);
                        this.activeJukeboxes.computeIfAbsent(jukeboxLocation, k -> new HashSet()).add(soundKey);
                    });
                    JSONObject discInfo = discData.getJSONObject(discName);
                    String displayName = discInfo.getString("displayName");
                    if (this.protocolLibEnabled && this.messageInterceptor != null) {
                        this.messageInterceptor.markCustomDiscInserted(jukeboxLocation, displayName);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error inserting the custom disc in the jukebox: " + e.getMessage());
                    this.plugin.getLogger().severe("Exception: " + e.getMessage());
                    this.customDiscsInJukeboxes.remove(jukeboxLocation);
                    if (player.getGameMode() == GameMode.CREATIVE) break block17;
                    if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
                        player.getInventory().setItemInMainHand(itemInHand);
                    }
                    player.getInventory().addItem(new ItemStack[]{itemInHand});
                }
            }
        }
    }

    private ItemStack getCurrentRecordCompatibility(Jukebox jukebox) {
        try {
            return jukebox.getRecord();
        }
        catch (NoSuchMethodError e) {
            try {
                Material playing = jukebox.getPlaying();
                return playing != Material.AIR ? new ItemStack(playing) : new ItemStack(Material.AIR);
            }
            catch (Throwable t2) {
                this.plugin.getLogger().log(Level.WARNING, "Fallback getPlaying() failed", t2);
                return new ItemStack(Material.AIR);
            }
        }
        catch (Throwable t3) {
            this.plugin.getLogger().log(Level.WARNING, "Unexpected error getting jukebox record", t3);
            return new ItemStack(Material.AIR);
        }
    }

    @EventHandler
    public void onJukeboxBreak(BlockBreakEvent event) {
        Block brokenBlock = event.getBlock();
        if (brokenBlock.getType() != Material.JUKEBOX) {
            return;
        }
        Location jukeboxLocation = brokenBlock.getLocation();
        Set<String> activeSounds = this.activeJukeboxes.get(jukeboxLocation);
        ItemStack customDisc = this.customDiscsInJukeboxes.get(jukeboxLocation);
        if (activeSounds != null && !activeSounds.isEmpty() && customDisc != null) {
            for (String currentSoundKey : activeSounds) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "execute positioned " + jukeboxLocation.getBlockX() + " " + jukeboxLocation.getBlockY() + " " + jukeboxLocation.getBlockZ() + " run stopsound @a[distance=..80] * minecraft:" + currentSoundKey);
            }
            this.dropCustomDisc(jukeboxLocation, customDisc);
        }
        this.cleanupJukebox(jukeboxLocation);
    }

    public void cleanupJukebox(Location location) {
        this.activeJukeboxes.remove(location);
        this.customDiscsInJukeboxes.remove(location);
    }

    private void dropCustomDisc(Location jukeboxLocation, ItemStack customDisc) {
        String minecraftServerVersion = this.plugin.getMinecraftServerVersion();
        MinecraftServerVersionUtils version = MinecraftServerVersionUtils.parse(minecraftServerVersion);
        if (version.isNewDropPosition()) {
            Objects.requireNonNull(jukeboxLocation.getWorld()).dropItemNaturally(jukeboxLocation.clone().add(0.5, 1.05, 0.5), customDisc.clone());
        } else {
            Objects.requireNonNull(jukeboxLocation.getWorld()).dropItemNaturally(jukeboxLocation.clone().add(0.0, 0.55, 0.0), customDisc.clone());
        }
    }
}

