/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.urlcustomdiscs.URLCustomDiscs;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Jukebox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class JukeboxMessageInterceptor {
    private final URLCustomDiscs plugin;
    private final Map<Location, String> recentCustomDiscs = new ConcurrentHashMap<Location, String>();
    private final Map<Player, Long> lastToastTime = new ConcurrentHashMap<Player, Long>();

    public JukeboxMessageInterceptor(URLCustomDiscs plugin) {
        this.plugin = plugin;
        this.registerPacketListener();
    }

    public void markCustomDiscInserted(Location jukeboxLocation, String displayName) {
        this.recentCustomDiscs.put(jukeboxLocation, displayName);
        this.sendToastToNearbyPlayers(jukeboxLocation, displayName);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentCustomDiscs.remove(jukeboxLocation), 200L);
    }

    private void sendToastToNearbyPlayers(Location jukeboxLocation, String displayName) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (!player.getWorld().equals((Object)jukeboxLocation.getWorld()) || !(player.getLocation().distance(jukeboxLocation) <= 80.0)) continue;
                this.sendCustomMusicToast(player, displayName);
            }
        });
    }

    private void registerPacketListener() {
        PacketType[] toastPackets = new PacketType[]{PacketType.Play.Server.ADVANCEMENTS, PacketType.Play.Server.SELECT_ADVANCEMENT_TAB, PacketType.Play.Server.RECIPE_UPDATE};
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.SYSTEM_CHAT}){

            public void onPacketSending(PacketEvent event) {
                JukeboxMessageInterceptor.this.handleSystemChatPacket(event);
            }
        });
        for (PacketType packetType : toastPackets) {
            try {
                ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, ListenerPriority.HIGHEST, new PacketType[]{packetType}){

                    public void onPacketSending(PacketEvent event) {
                        JukeboxMessageInterceptor.this.handlePotentialToastPacket(event);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Unable to intercept " + String.valueOf(packetType) + ": " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Registered Toast Interceptors");
    }

    private void handleSystemChatPacket(PacketEvent event) {
        try {
            String customName;
            String message;
            WrappedChatComponent component = (WrappedChatComponent)event.getPacket().getChatComponents().read(0);
            if (component != null && this.isNowPlayingMessage(message = component.getJson()) && (customName = this.findNearbyCustomDisc(event.getPlayer())) != null) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error intercepting system chat: " + e.getMessage());
        }
    }

    private void handlePotentialToastPacket(PacketEvent event) {
        try {
            Player player = event.getPlayer();
            String customName = this.findNearbyCustomDisc(player);
            if (customName != null) {
                long currentTime = System.currentTimeMillis();
                Long lastTime = this.lastToastTime.get(player);
                if (lastTime == null || currentTime - lastTime > 1000L) {
                    event.setCancelled(true);
                    this.lastToastTime.put(player, currentTime);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error intercepting toast packet: " + e.getMessage());
        }
    }

    private void sendCustomMusicToast(Player player, String customName) {
        try {
            String messageJson = "[{\"text\":\"Now Playing: \",\"color\":\"aqua\"},{\"text\":\"" + customName.replace("\"", "\\\"") + "\",\"color\":\"gold\"}]";
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "title " + player.getName() + " actionbar " + messageJson);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error sending the custom toast: " + e.getMessage());
        }
    }

    private boolean isNowPlayingMessage(String message) {
        return message != null && (message.contains("record.nowPlaying") || message.contains("Now Playing") || message.toLowerCase().contains("playing") || message.contains("C418") || message.contains("13"));
    }

    private String findNearbyCustomDisc(Player player) {
        Location playerLoc = player.getLocation();
        for (Map.Entry<Location, String> entry : this.recentCustomDiscs.entrySet()) {
            Jukebox jukebox;
            ItemStack record;
            Location jukeboxLoc = entry.getKey();
            if (!Objects.equals(playerLoc.getWorld(), jukeboxLoc.getWorld()) || playerLoc.distance(jukeboxLoc) > 80.0 || (record = (jukebox = (Jukebox)jukeboxLoc.getBlock().getState()).getRecord()).getType() != Material.MUSIC_DISC_13 || !record.hasItemMeta() || !Objects.requireNonNull(record.getItemMeta()).hasCustomModelData()) continue;
            return entry.getValue();
        }
        return null;
    }
}

