/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.DiscFactory;
import com.urlcustomdiscs.DiscJsonManager;
import com.urlcustomdiscs.URLCustomDiscs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.JSONObject;

public class RemoteApiClient {
    private final URLCustomDiscs plugin;
    private final String apiBaseURL;

    public RemoteApiClient(URLCustomDiscs plugin, String apiBaseURL) {
        this.plugin = plugin;
        this.apiBaseURL = apiBaseURL;
    }

    public void requestTokenFromRemoteServer(Player player, String minecraftServerVersion, Runnable onSuccess) {
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Registering the server with the remote API...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            block18: {
                try {
                    HttpURLConnection connection = this.createPostConnection("/register-mc-server");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setDoOutput(true);
                    JSONObject payload = new JSONObject();
                    payload.put("minecraftServerVersion", minecraftServerVersion);
                    String jsonInputString = payload.toString();
                    try (OutputStream os = connection.getOutputStream();){
                        byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
                        os.write(input, 0, input.length);
                    }
                    int responseCode = connection.getResponseCode();
                    if (responseCode == 200) {
                        try (InputStream responseStream = connection.getInputStream();){
                            String response = new String(responseStream.readAllBytes(), StandardCharsets.UTF_8);
                            String receivedToken = this.parseValueFromJson(response, "token");
                            String receivedApiDownloadResourcePackURL = this.parseValueFromJson(response, "apiDownloadResourcePackURL");
                            if (receivedToken != null && !receivedToken.isEmpty() && receivedApiDownloadResourcePackURL != null && !receivedApiDownloadResourcePackURL.isEmpty()) {
                                File configFile = new File(this.plugin.getDataFolder(), "config.yml");
                                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                                config.set("token", (Object)receivedToken);
                                config.set("apiDownloadResourcePackURL", (Object)receivedApiDownloadResourcePackURL);
                                config.save(configFile);
                                this.plugin.setToken(receivedToken);
                                this.plugin.setApiDownloadResourcePackURL(receivedApiDownloadResourcePackURL);
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your token has been generated and apiDownloadResourcePackURL is available in the config.yml file of the URLCustomDiscs plugin.");
                                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Don't forget to set the 'resource-pack=' field in your Minecraft server's 'server.properties' file using the apiDownloadResourcePackURL, as explained in the 'config.yml' file of the URLCustomDiscs plugin.");
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, onSuccess);
                            } else {
                                this.plugin.getLogger().warning("No token received from remote API.");
                            }
                            break block18;
                        }
                    }
                    this.plugin.getLogger().warning("Remote API returned status code: " + responseCode);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to register with remote API:");
                    this.plugin.getLogger().severe("Exception: " + e.getMessage());
                }
            }
        });
    }

    private String parseValueFromJson(String json, String key) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            return jsonObject.getString(key);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Exception: " + e.getMessage());
            return null;
        }
    }

    public void createCustomDiscRemotely(Player player, String finalAudioIdentifier, String discName, String audioType, JSONObject discInfo, String token, String minecraftServerVersion) {
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Sending information to the remote API...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean isLocalFile = !finalAudioIdentifier.toLowerCase().startsWith("http");
            try {
                HttpURLConnection connection;
                block21: {
                    if (isLocalFile) {
                        File mp3File = new File(this.plugin.getDataFolder(), "audio_to_send/" + finalAudioIdentifier);
                        if (!mp3File.exists()) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "File not found: " + finalAudioIdentifier));
                            return;
                        }
                        String boundary = Long.toHexString(System.currentTimeMillis());
                        String CRLF = "\r\n";
                        connection = this.createPostConnection("/create-custom-disc-from-mp3");
                        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                        connection.setDoOutput(true);
                        try (OutputStream output = connection.getOutputStream();
                             PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), true);){
                            writer.append("--").append(boundary).append(CRLF);
                            writer.append("Content-Disposition: form-data; name=\"discName\"").append(CRLF).append(CRLF).append(discName).append(CRLF);
                            writer.append("--").append(boundary).append(CRLF);
                            writer.append("Content-Disposition: form-data; name=\"audioType\"").append(CRLF).append(CRLF).append(audioType).append(CRLF);
                            writer.append("--").append(boundary).append(CRLF);
                            writer.append("Content-Disposition: form-data; name=\"customModelData\"").append(CRLF).append(CRLF).append(String.valueOf(discInfo.getInt("customModelData"))).append(CRLF);
                            writer.append("--").append(boundary).append(CRLF);
                            writer.append("Content-Disposition: form-data; name=\"token\"").append(CRLF).append(CRLF).append(token).append(CRLF);
                            writer.append("--").append(boundary).append(CRLF);
                            writer.append("Content-Disposition: form-data; name=\"minecraftServerVersion\"").append(CRLF).append(CRLF).append(minecraftServerVersion).append(CRLF);
                            writer.append("--").append(boundary).append(CRLF);
                            writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(mp3File.getName()).append("\"").append(CRLF);
                            writer.append("Content-Type: audio/mpeg").append(CRLF).append(CRLF);
                            writer.flush();
                            Files.copy(mp3File.toPath(), output);
                            output.flush();
                            writer.append(CRLF).flush();
                            writer.append("--").append(boundary).append("--").append(CRLF).flush();
                            break block21;
                        }
                    }
                    connection = this.createPostConnection("/create-custom-disc");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setDoOutput(true);
                    JSONObject payload = new JSONObject();
                    payload.put("url", finalAudioIdentifier);
                    payload.put("discName", discName);
                    payload.put("audioType", audioType);
                    payload.put("customModelData", discInfo.getInt("customModelData"));
                    payload.put("token", token);
                    payload.put("minecraftServerVersion", minecraftServerVersion);
                    try (OutputStream os = connection.getOutputStream();){
                        byte[] inputBytes = payload.toString().getBytes(StandardCharsets.UTF_8);
                        os.write(inputBytes, 0, inputBytes.length);
                    }
                }
                int responseCode = connection.getResponseCode();
                InputStream responseStream = responseCode >= 200 && responseCode < 300 ? connection.getInputStream() : connection.getErrorStream();
                String response = new String(responseStream.readAllBytes(), StandardCharsets.UTF_8);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.handleApiResponse(player, responseCode, response, discInfo, discName, "create"));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Exception: " + e.getMessage());
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "An error occurred while sending the request."));
            }
        });
    }

    public void deleteCustomDiscRemotely(Player player, String discName, JSONObject discInfo, String token, String minecraftServerVersion) {
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Sending information to the remote API...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String responseBody;
                HttpURLConnection connection = this.createPostConnection("/delete-custom-disc");
                JSONObject payload = new JSONObject();
                payload.put("discName", discName);
                payload.put("token", token);
                payload.put("minecraftServerVersion", minecraftServerVersion);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = payload.toString().getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = connection.getResponseCode();
                try (InputStream responseStream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();){
                    responseBody = new String(responseStream.readAllBytes(), StandardCharsets.UTF_8);
                }
                String finalResponseBody = responseBody;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.handleApiResponse(player, responseCode, finalResponseBody, discInfo, discName, "delete"));
            }
            catch (Exception e) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while contacting the remote API.");
                    this.plugin.getLogger().severe("Exception during remote disc deletion:");
                });
                this.plugin.getLogger().severe("Exception: " + e.getMessage());
            }
        });
    }

    private HttpURLConnection createPostConnection(String endpoint) throws Exception {
        URL url = new URL(this.apiBaseURL + endpoint);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        return connection;
    }

    private void handleApiResponse(Player player, int responseCode, String responseBody, JSONObject discInfo, String discName, String mode) {
        block32: {
            if (responseCode >= 200 && responseCode < 300) {
                try {
                    JSONObject json = new JSONObject(responseBody);
                    if (json.has("success") && json.getBoolean("success")) {
                        String message = json.optString("message", "Operation completed successfully.");
                        String displayName = discInfo.getString("displayName");
                        if (mode.equals("create")) {
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Custom disc " + String.valueOf(ChatColor.GOLD) + displayName + String.valueOf(ChatColor.GREEN) + " created.");
                            this.plugin.getLogger().info("[API SUCCESS] " + message);
                            DiscFactory.giveCustomDiscToPlayer(player, discInfo);
                            String apiDownloadResourcePackURL = this.plugin.getApiDownloadResourcePackURL();
                            if (!apiDownloadResourcePackURL.isEmpty()) {
                                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                                    onlinePlayer.sendMessage(String.valueOf(ChatColor.GRAY) + "A new resource pack will be loaded...");
                                    onlinePlayer.setResourcePack(apiDownloadResourcePackURL);
                                }
                            }
                        } else if (mode.equals("delete")) {
                            this.cleanupDiscEntry(discName);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Custom disc " + String.valueOf(ChatColor.GOLD) + displayName + String.valueOf(ChatColor.GREEN) + " deleted.");
                            this.plugin.getLogger().info("[API SUCCESS] " + message);
                        }
                    } else {
                        String error = json.optString("error", "An unknown error occurred.");
                        player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "API error: " + error);
                        this.plugin.getLogger().warning("[API ERROR] " + error);
                        if (mode.equals("create")) {
                            this.cleanupDiscEntry(discName);
                        }
                    }
                    break block32;
                }
                catch (Exception e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Failed to parse API response.");
                    this.plugin.getLogger().severe("Failed to parse API response: " + responseBody);
                    if (mode.equals("create")) {
                        this.cleanupDiscEntry(discName);
                    }
                    break block32;
                }
            }
            if (responseCode == 419) {
                JSONObject json = new JSONObject(responseBody);
                String error = json.optString("error", "Authentication Timeout (YouTube cookie expired) error.");
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + error);
                this.plugin.getLogger().warning("[API ERROR] " + error);
                if (mode.equals("create")) {
                    this.cleanupDiscEntry(discName);
                }
            } else if (responseCode == 401) {
                JSONObject json = new JSONObject(responseBody);
                String error = json.optString("error", "Unauthorized error.");
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + error);
                this.plugin.getLogger().warning("[API ERROR] " + error);
                try {
                    File configFile = new File(this.plugin.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("token", (Object)"");
                    config.set("apiDownloadResourcePackURL", (Object)"");
                    config.save(configFile);
                    this.plugin.setToken("");
                    this.plugin.setApiDownloadResourcePackURL("");
                }
                catch (IOException ex) {
                    this.plugin.getLogger().warning("Failed to reset token and/or apiDownloadResourcePackURL in config.yml: " + ex.getMessage() + " You must clear these values manually in the config.yml file, then restart your Minecraft server.");
                }
                try {
                    DiscJsonManager discManager = new DiscJsonManager(this.plugin);
                    discManager.deleteDiscFile();
                }
                catch (Exception ex) {
                    this.plugin.getLogger().warning("Failed to delete discs.json: " + ex.getMessage());
                }
                if (mode.equals("create")) {
                    this.cleanupDiscEntry(discName);
                }
            } else if (responseCode == 409) {
                JSONObject json = new JSONObject(responseBody);
                String error = json.optString("error", "Conflict error.");
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + error);
                this.plugin.getLogger().warning("[API ERROR] " + error);
                if (mode.equals("create")) {
                    this.cleanupDiscEntry(discName);
                }
            } else if (responseCode == 429) {
                JSONObject json = new JSONObject(responseBody);
                String error = json.optString("error", "Too many requests error.");
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + error);
                this.plugin.getLogger().warning("[API ERROR] " + error);
                if (mode.equals("create")) {
                    this.cleanupDiscEntry(discName);
                }
            } else if (responseCode == 503) {
                JSONObject json = new JSONObject(responseBody);
                String error = json.optString("error", "Service Unavailable error.");
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + error);
                this.plugin.getLogger().warning("[API ERROR] " + error);
                if (mode.equals("create")) {
                    this.cleanupDiscEntry(discName);
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "HTTP Error " + responseCode + ": Check server logs for details.");
                this.plugin.getLogger().warning("API responded with HTTP error code: " + responseCode + ", response body: " + responseBody);
                if (mode.equals("create")) {
                    this.cleanupDiscEntry(discName);
                }
            }
        }
    }

    private void cleanupDiscEntry(String discName) {
        try {
            DiscJsonManager discManager = new DiscJsonManager(this.plugin);
            discManager.deleteDisc(discName);
        }
        catch (IOException ex) {
            this.plugin.getLogger().warning("Failed to clean up local disc entry: " + ex.getMessage());
        }
    }
}

