/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.URLCustomDiscs;
import com.urlcustomdiscs.utils.MinecraftServerVersionUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class ResourcePackManager {
    private final URLCustomDiscs plugin;

    public ResourcePackManager(URLCustomDiscs plugin) {
        this.plugin = plugin;
    }

    public File downloadResourcePack(File outputDir, String downloadResourcePackUrl) throws IOException {
        this.plugin.getLogger().info("Downloading the resource pack...");
        File destinationFile = new File(outputDir, "URLCustomDiscsPack.zip");
        HttpURLConnection connection = (HttpURLConnection)new URL(downloadResourcePackUrl).openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to download the resource pack: " + connection.getResponseMessage());
        }
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
             FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        this.plugin.getLogger().info("Resource pack downloaded: " + destinationFile.getAbsolutePath());
        return destinationFile;
    }

    public boolean uploadResourcePack(File resourcePackFile, String uploadResourcePackURL) {
        this.plugin.getLogger().info("Uploading the resource pack...");
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(uploadResourcePackURL).openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            String boundary = "----WebKitFormBoundary" + System.currentTimeMillis();
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (OutputStream outputStream = connection.getOutputStream();
                 FileInputStream fileInputStream = new FileInputStream(resourcePackFile);
                 PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);){
                int bytesRead;
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(resourcePackFile.getName()).append("\"\r\n");
                writer.append("Content-Type: application/zip\r\n\r\n");
                writer.flush();
                byte[] buffer = new byte[4096];
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.flush();
                writer.append("\r\n--").append(boundary).append("--\r\n");
                writer.flush();
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                this.plugin.getLogger().info("Resource pack uploaded successfully.");
                return true;
            }
            this.plugin.getLogger().severe("Error uploading the resource pack: " + connection.getResponseMessage());
            return false;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Exception while uploading resource pack: " + e.getMessage());
            return false;
        }
    }

    public void unzipResourcePack(File zipFile, File outputDir) {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                newFile.getParentFile().mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    zis.transferTo(fos);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void rezipResourcePack(File sourceDir, File targetZip) throws IOException {
        Path sourcePath = sourceDir.toPath();
        File tempZip = new File(targetZip.getParent(), targetZip.getName() + ".tmp");
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempZip));){
            Files.walk(sourcePath, new FileVisitOption[0]).forEach(path -> {
                File file = path.toFile();
                String entryName = sourcePath.relativize((Path)path).toString().replace("\\", "/");
                if (file.isDirectory()) {
                    if (!entryName.isEmpty()) {
                        try {
                            zos.putNextEntry(new ZipEntry(entryName + "/"));
                            zos.closeEntry();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                } else {
                    try (FileInputStream fis = new FileInputStream(file);){
                        zos.putNextEntry(new ZipEntry(entryName));
                        fis.transferTo(zos);
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        try {
            if (targetZip.exists() && !targetZip.delete()) {
                throw new IOException("Unable to delete the old ZIP file: " + targetZip.getAbsolutePath());
            }
            if (!tempZip.renameTo(targetZip)) {
                throw new IOException("Unable to rename the temporary file: " + tempZip.getAbsolutePath() + " to " + targetZip.getAbsolutePath());
            }
        }
        catch (IOException e) {
            if (tempZip.exists()) {
                tempZip.delete();
            }
            throw e;
        }
    }

    public void addOggFileToResourcePack(File oggFile, File unpackedDir, String discName) throws IOException {
        File target = new File(unpackedDir, "assets/minecraft/sounds/custom/" + discName + ".ogg");
        Files.copy(oggFile.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void addDiscEntryToSoundsJson(File unpackedDir, String discName) throws IOException {
        String key;
        File soundsJson = new File(unpackedDir, "assets/minecraft/sounds.json");
        JSONObject sounds = new JSONObject();
        if (soundsJson.exists()) {
            String content = Files.readString(soundsJson.toPath());
            sounds = new JSONObject(content);
        }
        if (!sounds.has(key = "customdisc." + discName)) {
            JSONObject soundEntry = new JSONObject();
            soundEntry.put("category", "record");
            JSONArray soundsArray = new JSONArray();
            JSONObject soundObj = new JSONObject();
            soundObj.put("name", "custom/" + discName);
            soundObj.put("stream", true);
            soundsArray.put(soundObj);
            soundEntry.put("sounds", soundsArray);
            sounds.put(key, soundEntry);
            Files.writeString(soundsJson.toPath(), (CharSequence)sounds.toString(2), new OpenOption[0]);
        }
    }

    public void addDiscEntryToMusicDisc13ModelJson(File unpackedDir, String discName, int customModelData, String minecraftServerVersion) throws IOException {
        JSONObject root;
        File modelPath;
        MinecraftServerVersionUtils version = MinecraftServerVersionUtils.parse(minecraftServerVersion);
        File file = modelPath = version.isNewFormat() ? new File(unpackedDir, "assets/minecraft/items/music_disc_13.json") : new File(unpackedDir, "assets/minecraft/models/item/music_disc_13.json");
        if (modelPath.exists()) {
            String content = Files.readString(modelPath.toPath());
            root = new JSONObject(content);
        } else {
            root = new JSONObject();
        }
        if (version.isNewFormat()) {
            JSONObject modelObject = root.optJSONObject("model");
            if (modelObject == null) {
                modelObject = new JSONObject();
                modelObject.put("type", "range_dispatch");
                modelObject.put("property", "custom_model_data");
                JSONObject fallback = new JSONObject();
                fallback.put("type", "model");
                fallback.put("model", "minecraft:item/music_disc_13");
                modelObject.put("fallback", fallback);
                modelObject.put("entries", new JSONArray());
                root.put("model", modelObject);
            }
            JSONArray entries = modelObject.getJSONArray("entries");
            boolean alreadyExists = false;
            for (int i = 0; i < entries.length(); ++i) {
                JSONObject entry = entries.getJSONObject(i);
                if (entry.optInt("threshold") != customModelData) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) {
                JSONObject newEntry = new JSONObject();
                newEntry.put("threshold", customModelData);
                JSONObject entryModel = new JSONObject();
                entryModel.put("type", "model");
                entryModel.put("model", "item/custom_music_disc_" + discName);
                newEntry.put("model", entryModel);
                entries.put(newEntry);
            }
        } else {
            JSONArray overrides;
            if (!modelPath.exists() || !root.has("parent")) {
                root.put("parent", "minecraft:item/generated");
                JSONObject textures = new JSONObject();
                textures.put("layer0", "minecraft:item/music_disc_13");
                root.put("textures", textures);
            }
            if ((overrides = root.optJSONArray("overrides")) == null) {
                overrides = new JSONArray();
                root.put("overrides", overrides);
            }
            boolean alreadyExists = false;
            for (int i = 0; i < overrides.length(); ++i) {
                JSONObject override = overrides.getJSONObject(i);
                JSONObject predicate = override.optJSONObject("predicate");
                if (predicate == null || predicate.optInt("custom_model_data") != customModelData) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) {
                JSONObject newOverride = new JSONObject();
                JSONObject predicate = new JSONObject();
                predicate.put("custom_model_data", customModelData);
                newOverride.put("predicate", predicate);
                newOverride.put("model", "item/custom_music_disc_" + discName);
                overrides.put(newOverride);
            }
        }
        Files.createDirectories(modelPath.toPath().getParent(), new FileAttribute[0]);
        Files.writeString(modelPath.toPath(), (CharSequence)root.toString(2), new OpenOption[0]);
    }

    public void createCustomDiscModelJson(File unpackedDir, String discName, String minecraftServerVersion) throws IOException {
        MinecraftServerVersionUtils version = MinecraftServerVersionUtils.parse(minecraftServerVersion);
        File modelPath = new File(unpackedDir, "assets/minecraft/models/item/custom_music_disc_" + discName + ".json");
        JSONObject model = new JSONObject();
        model.put("parent", "minecraft:item/generated");
        JSONObject textures = new JSONObject();
        textures.put("layer0", version.isNewFormat() ? "item/record_custom" : "minecraft:item/record_custom");
        model.put("textures", textures);
        modelPath.getParentFile().mkdirs();
        Files.writeString(modelPath.toPath(), (CharSequence)model.toString(2), new OpenOption[0]);
    }

    public void removeOggFileFromResourcePack(File unpackedDir, String discName) throws IOException {
        File oggFilePath = new File(unpackedDir, "assets/minecraft/sounds/custom/" + discName + ".ogg");
        if (oggFilePath.exists()) {
            oggFilePath.delete();
        }
    }

    public void removeDiscEntryFromSoundsJson(File unpackedDir, String discName) throws IOException {
        File soundsJson = new File(unpackedDir, "assets/minecraft/sounds.json");
        String key = "customdisc." + discName;
        if (!soundsJson.exists()) {
            return;
        }
        String content = Files.readString(soundsJson.toPath());
        JSONObject sounds = new JSONObject(content);
        if (sounds.has(key)) {
            sounds.remove(key);
            Files.writeString(soundsJson.toPath(), (CharSequence)sounds.toString(2), new OpenOption[0]);
        }
    }

    public void removeDiscEntryToMusicDisc13ModelJson(File unpackedDir, int customModelData, String minecraftServerVersion) throws IOException {
        File modelPath;
        MinecraftServerVersionUtils version = MinecraftServerVersionUtils.parse(minecraftServerVersion);
        File file = modelPath = version.isNewFormat() ? new File(unpackedDir, "assets/minecraft/items/music_disc_13.json") : new File(unpackedDir, "assets/minecraft/models/item/music_disc_13.json");
        if (!modelPath.exists()) {
            return;
        }
        String content = Files.readString(modelPath.toPath());
        JSONObject root = new JSONObject(content);
        if (version.isNewFormat()) {
            JSONArray entries;
            JSONObject modelObject = root.optJSONObject("model");
            if (modelObject != null && (entries = modelObject.optJSONArray("entries")) != null) {
                for (int i = 0; i < entries.length(); ++i) {
                    JSONObject entry = entries.getJSONObject(i);
                    if (entry.optInt("threshold") != customModelData) continue;
                    entries.remove(i);
                    break;
                }
            }
        } else {
            JSONArray overrides = root.optJSONArray("overrides");
            if (overrides != null) {
                for (int i = 0; i < overrides.length(); ++i) {
                    JSONObject override = overrides.getJSONObject(i);
                    JSONObject predicate = override.optJSONObject("predicate");
                    if (predicate == null || predicate.optInt("custom_model_data") != customModelData) continue;
                    overrides.remove(i);
                    break;
                }
            }
        }
        Files.writeString(modelPath.toPath(), (CharSequence)root.toString(2), new OpenOption[0]);
    }

    public void deleteCustomDiscModelJson(File unpackedDir, String discName) throws IOException {
        File modelPath = new File(unpackedDir, "assets/minecraft/models/item/custom_music_disc_" + discName + ".json");
        if (modelPath.exists() && !modelPath.delete()) {
            throw new IOException("Failed to delete the custom disc model JSON: " + modelPath.getAbsolutePath());
        }
    }
}

