/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.ResourcePackManager;
import com.urlcustomdiscs.URLCustomDiscs;
import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.json.JSONObject;

public class ResourcePackService {
    private final URLCustomDiscs plugin;
    private final String pluginUsageMode;

    public ResourcePackService(URLCustomDiscs plugin) {
        this.plugin = plugin;
        this.pluginUsageMode = plugin.getPluginUsageMode();
    }

    public boolean addDiscToResourcePack(Player player, File oggFile, String discName, JSONObject discInfo) {
        String resourcePackAccessMode = this.plugin.getResourcePackAccessMode();
        String displayName = discInfo.getString("displayName");
        int customModelData = discInfo.getInt("customModelData");
        if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode)) {
            if ("local".equals(resourcePackAccessMode)) {
                return this.handleLocalAddDisc(player, oggFile, discName, displayName, customModelData);
            }
            if ("online".equals(resourcePackAccessMode)) {
                return this.handleOnlineAddDisc(player, oggFile, discName, displayName, customModelData);
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Invalid Minecraft server type: " + resourcePackAccessMode + ". Please set the Minecraft server type to 'local' or 'online' in the config.yml file.");
            return false;
        }
        if ("edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            return this.handleLocalAddDisc(player, oggFile, discName, displayName, customModelData);
        }
        return false;
    }

    private boolean handleLocalAddDisc(Player player, File oggFile, String discName, String displayName, int customModelData) {
        File resourcePackZip;
        ResourcePackManager rpm = new ResourcePackManager(this.plugin);
        if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode)) {
            resourcePackZip = new File(this.plugin.getZipFileAbsolutePath());
        } else if ("edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            resourcePackZip = new File(this.plugin.getEditOnlyModeZipFilePath());
        } else {
            throw new IllegalStateException("Unsupported pluginUsageMode: " + this.pluginUsageMode);
        }
        File tempUnpackedFolder = this.plugin.getTempUnpackedFolder();
        String minecraftServerVersion = this.plugin.getMinecraftServerVersion();
        try {
            rpm.unzipResourcePack(resourcePackZip, tempUnpackedFolder);
            rpm.addOggFileToResourcePack(oggFile, tempUnpackedFolder, discName);
            rpm.addDiscEntryToSoundsJson(tempUnpackedFolder, discName);
            rpm.addDiscEntryToMusicDisc13ModelJson(tempUnpackedFolder, discName, customModelData, minecraftServerVersion);
            rpm.createCustomDiscModelJson(tempUnpackedFolder, discName, minecraftServerVersion);
            rpm.rezipResourcePack(tempUnpackedFolder, resourcePackZip);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Custom disc " + String.valueOf(ChatColor.GOLD) + displayName + String.valueOf(ChatColor.GREEN) + " created.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error updating the locally-hosted resource pack with a new custom disc.");
            this.plugin.getLogger().severe("Error updating the locally-hosted resource pack with a new custom disc: " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.deleteFolderContents(tempUnpackedFolder, false);
            oggFile.delete();
        }
    }

    private boolean handleOnlineAddDisc(Player player, File oggFile, String discName, String displayName, int customModelData) {
        ResourcePackManager rpm = new ResourcePackManager(this.plugin);
        File editResourcePackFolder = this.plugin.getEditResourcePackFolder();
        File tempUnpackedFolder = this.plugin.getTempUnpackedFolder();
        String downloadResourcePackUrl = this.plugin.getDownloadResourcePackURL();
        String minecraftServerVersion = this.plugin.getMinecraftServerVersion();
        String uploadResourcePackUrl = this.plugin.getUploadResourcePackURL();
        File downloadedZip = null;
        try {
            downloadedZip = rpm.downloadResourcePack(editResourcePackFolder, downloadResourcePackUrl);
            rpm.unzipResourcePack(downloadedZip, tempUnpackedFolder);
            rpm.addOggFileToResourcePack(oggFile, tempUnpackedFolder, discName);
            rpm.addDiscEntryToSoundsJson(tempUnpackedFolder, discName);
            rpm.addDiscEntryToMusicDisc13ModelJson(tempUnpackedFolder, discName, customModelData, minecraftServerVersion);
            rpm.createCustomDiscModelJson(tempUnpackedFolder, discName, minecraftServerVersion);
            rpm.rezipResourcePack(tempUnpackedFolder, downloadedZip);
            if (!rpm.uploadResourcePack(downloadedZip, uploadResourcePackUrl)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error uploading the resource pack to the HTTP server.");
                boolean bl = false;
                return bl;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Custom disc " + String.valueOf(ChatColor.GOLD) + displayName + String.valueOf(ChatColor.GREEN) + " created.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error updating the online-hosted resource pack with a new custom disc.");
            this.plugin.getLogger().severe("Error updating the online-hosted resource pack with a new custom disc: " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.deleteFolderContents(tempUnpackedFolder, false);
            oggFile.delete();
            downloadedZip.delete();
        }
    }

    public boolean removeDiscFromResourcePack(Player player, String discName, JSONObject discInfo) {
        String resourcePackAccessMode = this.plugin.getResourcePackAccessMode();
        String displayName = discInfo.getString("displayName");
        int customModelData = discInfo.getInt("customModelData");
        if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode)) {
            if ("local".equals(resourcePackAccessMode)) {
                return this.handleLocalRemoveDisc(player, discName, displayName, customModelData);
            }
            if ("online".equals(resourcePackAccessMode)) {
                return this.handleOnlineRemoveDisc(player, discName, displayName, customModelData);
            }
        } else if ("edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            return this.handleLocalRemoveDisc(player, discName, displayName, customModelData);
        }
        return false;
    }

    private boolean handleLocalRemoveDisc(Player player, String discName, String displayName, int customModelData) {
        File resourcePackZip;
        ResourcePackManager rpm = new ResourcePackManager(this.plugin);
        if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode)) {
            resourcePackZip = new File(this.plugin.getZipFileAbsolutePath());
        } else if ("edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            resourcePackZip = new File(this.plugin.getEditOnlyModeZipFilePath());
        } else {
            throw new IllegalStateException("Unsupported pluginUsageMode: " + this.pluginUsageMode);
        }
        File tempUnpackedFolder = this.plugin.getTempUnpackedFolder();
        String minecraftServerVersion = this.plugin.getMinecraftServerVersion();
        try {
            rpm.unzipResourcePack(resourcePackZip, tempUnpackedFolder);
            rpm.removeOggFileFromResourcePack(tempUnpackedFolder, discName);
            rpm.removeDiscEntryFromSoundsJson(tempUnpackedFolder, discName);
            rpm.removeDiscEntryToMusicDisc13ModelJson(tempUnpackedFolder, customModelData, minecraftServerVersion);
            rpm.deleteCustomDiscModelJson(tempUnpackedFolder, discName);
            rpm.rezipResourcePack(tempUnpackedFolder, resourcePackZip);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Custom disc " + String.valueOf(ChatColor.GOLD) + displayName + String.valueOf(ChatColor.GREEN) + " deleted.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error updating the locally-hosted resource pack with a custom disc removal.");
            this.plugin.getLogger().severe("Error updating the locally-hosted resource pack with a custom disc removal: " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.deleteFolderContents(tempUnpackedFolder, false);
        }
    }

    private boolean handleOnlineRemoveDisc(Player player, String discName, String displayName, int customModelData) {
        ResourcePackManager rpm = new ResourcePackManager(this.plugin);
        File editResourcePackFolder = this.plugin.getEditResourcePackFolder();
        File tempUnpackedFolder = this.plugin.getTempUnpackedFolder();
        String downloadResourcePackUrl = this.plugin.getDownloadResourcePackURL();
        String minecraftServerVersion = this.plugin.getMinecraftServerVersion();
        String uploadResourcePackUrl = this.plugin.getUploadResourcePackURL();
        File downloadedZip = null;
        try {
            downloadedZip = rpm.downloadResourcePack(editResourcePackFolder, downloadResourcePackUrl);
            rpm.unzipResourcePack(downloadedZip, tempUnpackedFolder);
            rpm.removeOggFileFromResourcePack(tempUnpackedFolder, discName);
            rpm.removeDiscEntryFromSoundsJson(tempUnpackedFolder, discName);
            rpm.removeDiscEntryToMusicDisc13ModelJson(tempUnpackedFolder, customModelData, minecraftServerVersion);
            rpm.deleteCustomDiscModelJson(tempUnpackedFolder, discName);
            rpm.rezipResourcePack(tempUnpackedFolder, downloadedZip);
            if (!rpm.uploadResourcePack(downloadedZip, uploadResourcePackUrl)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error uploading the resource pack to the HTTP server.");
                boolean bl = false;
                return bl;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Custom disc " + String.valueOf(ChatColor.GOLD) + displayName + String.valueOf(ChatColor.GREEN) + " deleted.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error updating the online-hosted resource pack with a custom disc removal.");
            this.plugin.getLogger().severe("Error updating the online-hosted resource pack with a custom disc removal: " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.deleteFolderContents(tempUnpackedFolder, false);
            downloadedZip.delete();
        }
    }

    private void deleteFolderContents(File folder, boolean deleteFolderItself) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteFolderContents(file, true);
                    continue;
                }
                file.delete();
            }
        }
        if (deleteFolderItself) {
            folder.delete();
        }
    }
}

