/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.DiscFactory;
import com.urlcustomdiscs.DiscJsonManager;
import com.urlcustomdiscs.FFmpegManager;
import com.urlcustomdiscs.ResourcePackService;
import com.urlcustomdiscs.URLCustomDiscs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.JSONObject;

public class SelfHostedManager {
    private final URLCustomDiscs plugin;
    private final URLCustomDiscs.OS os;
    private final String pluginUsageMode;

    public SelfHostedManager(URLCustomDiscs plugin, URLCustomDiscs.OS os) {
        this.plugin = plugin;
        this.os = os;
        this.pluginUsageMode = plugin.getPluginUsageMode();
    }

    public void createCustomDisc(Player player, String mp3FileName, String discName, String audioType, JSONObject discInfo) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            ResourcePackService resourcePackService;
            FFmpegManager ffmpegManager = new FFmpegManager(this.plugin, this.os);
            File oggFile = new File(this.plugin.getTempAudioFolder(), discName + ".ogg");
            boolean converted = ffmpegManager.convertAudioWithFFmpeg(mp3FileName, oggFile, audioType);
            if (!converted || !oggFile.exists()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Failed to convert the MP3 audio to Ogg Vorbis using FFmpeg."));
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(String.valueOf(ChatColor.GREEN) + "Audio downloaded and converted."));
            File mp3File = new File(this.plugin.getTempAudioFolder(), mp3FileName);
            if (mp3File.exists()) {
                mp3File.delete();
            }
            if (!(resourcePackService = new ResourcePackService(this.plugin)).addDiscToResourcePack(player, oggFile, discName, discInfo)) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error adding the custom disc to the resource pack."));
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode)) {
                    DiscFactory.giveCustomDiscToPlayer(player, discInfo);
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        onlinePlayer.setResourcePack(this.plugin.getDownloadResourcePackURL());
                    }
                } else if ("edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.duplicateResourcePack(player));
                }
            });
        });
    }

    public void deleteCustomDisc(Player player, String discName, JSONObject discInfo) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            ResourcePackService resourcePackService = new ResourcePackService(this.plugin);
            if (!resourcePackService.removeDiscFromResourcePack(player, discName, discInfo)) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Error deleting the custom disc from the resource pack."));
                return;
            }
            try {
                DiscJsonManager discManager = new DiscJsonManager(this.plugin);
                discManager.deleteDisc(discName);
                if ("edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
                    this.duplicateResourcePack(player);
                }
            }
            catch (IOException ex) {
                this.plugin.getLogger().warning("Failed to clean up local disc entry: " + ex.getMessage());
            }
        });
    }

    public void duplicateResourcePack(Player player) {
        File sourceZip = new File(this.plugin.getEditOnlyModeReferenceResourcePackFolder(), "URLCustomDiscsPack.zip");
        File targetZip = new File(this.plugin.getDataFolder().getParentFile(), this.plugin.getDuplicatedZipFilePath());
        try {
            if (!targetZip.getParentFile().exists()) {
                targetZip.getParentFile().mkdirs();
            }
            Files.copy(sourceZip.toPath(), targetZip.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Resource pack duplicated successfully to:");
                player.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + targetZip.getPath());
            });
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Exception: " + e.getMessage());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Failed to duplicate the resource pack: " + e.getMessage()));
        }
    }
}

