/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.CommandURLCustomDiscs;
import com.urlcustomdiscs.DenoSetup;
import com.urlcustomdiscs.FFmpegSetup;
import com.urlcustomdiscs.JukeboxListener;
import com.urlcustomdiscs.RemoteApiClient;
import com.urlcustomdiscs.SelfHostedManager;
import com.urlcustomdiscs.YtDlpSetup;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class URLCustomDiscs
extends JavaPlugin {
    private final String os = System.getProperty("os.name").toLowerCase();
    private String minecraftServerVersion;
    private File audioToSendFolder;
    private File binFolder;
    private File editResourcePackFolder;
    private File tempAudioFolder;
    private File tempUnpackedFolder;
    private File editOnlyModeReferenceResourcePackFolder;
    private String pluginUsageMode;
    private String apiBaseURL;
    private String token;
    private String apiDownloadResourcePackURL;
    private Boolean localYtDlp;
    private String downloadResourcePackURL;
    private String resourcePackAccessMode;
    private String zipFileAbsolutePath;
    private String uploadResourcePackURL;
    private String editOnlyModeZipFilePath;
    private String duplicatedZipFilePath;

    public void onEnable() {
        this.getLogger().info("URLCustomDiscs enabled !");
        this.getLogger().info("Running on OS: " + this.getOperatingSystem());
        String fullVersion = this.getServer().getBukkitVersion();
        this.minecraftServerVersion = fullVersion.split("-")[0];
        this.getLogger().info("Detected Minecraft server version: " + this.minecraftServerVersion);
        if (this.minecraftServerVersion == null) {
            this.minecraftServerVersion = "1.21.4";
            this.getLogger().warning("Failed to parse Minecraft version from Bukkit version. Defaulting to: " + this.minecraftServerVersion);
            this.getLogger().warning("If your Minecraft server is under this version, your API-managed resource pack will not be compatible with your version.");
        }
        this.loadConfig();
        this.loadFiles();
        if (!("api".equalsIgnoreCase(this.pluginUsageMode) || "self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode))) {
            this.getLogger().severe("Invalid pluginUsageMode in config.yml: '" + this.pluginUsageMode + "'");
            this.getLogger().severe("Plugin will be disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        OS os = this.getOperatingSystemEnum();
        if ("api".equalsIgnoreCase(this.pluginUsageMode) && this.localYtDlp.booleanValue()) {
            new DenoSetup(this, os).setup();
            new YtDlpSetup(this, os).setup();
        }
        if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            new DenoSetup(this, os).setup();
            new YtDlpSetup(this, os).setup();
            new FFmpegSetup(this, os).setup();
        }
        RemoteApiClient remoteApiClient = new RemoteApiClient(this, this.getApiBaseURL());
        SelfHostedManager selfHostedManager = new SelfHostedManager(this, os);
        Objects.requireNonNull(this.getCommand("customdisc")).setExecutor((CommandExecutor)new CommandURLCustomDiscs(this, os, remoteApiClient, selfHostedManager));
        boolean protocolLibEnabled = this.getServer().getPluginManager().isPluginEnabled("ProtocolLib");
        if (protocolLibEnabled) {
            this.getLogger().info("ProtocolLib detected! Custom Now Playing toasts will be available.");
            this.getServer().getPluginManager().registerEvents((Listener)new JukeboxListener(this, true), (Plugin)this);
        } else {
            this.getLogger().warning("ProtocolLib is not installed! The plugin will work normally, but custom Now Playing toasts will not be available.");
            this.getServer().getPluginManager().registerEvents((Listener)new JukeboxListener(this, false), (Plugin)this);
        }
    }

    public void onDisable() {
        this.getLogger().info("URLCustomDiscs disabled!");
    }

    public OS getOperatingSystemEnum() {
        boolean isMusl;
        String name = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean isArm = arch.contains("aarch64") || arch.contains("arm");
        boolean isArmV7 = arch.contains("armv7");
        boolean bl = isMusl = new File("/lib/ld-musl-x86_64.so.1").exists() || new File("/lib/ld-musl-aarch64.so.1").exists();
        if (name.contains("win")) {
            if (isArm) {
                return OS.WINDOWS_ARM64;
            }
            return OS.WINDOWS_X64;
        }
        if (name.contains("nux") || name.contains("nix")) {
            if (isMusl) {
                if (isArm) {
                    return OS.LINUX_MUSL_ARM64;
                }
                return OS.LINUX_MUSL_X64;
            }
            if (isArmV7) {
                return OS.LINUX_ARMV7;
            }
            if (isArm) {
                return OS.LINUX_ARM64;
            }
            return OS.LINUX_X64;
        }
        return OS.OTHER;
    }

    private void loadConfig() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        this.getDataFolder().mkdirs();
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                String configContent = "# Configuration file for URLCustomDiscs plugin.\n\n\n# ========== PLUGIN USAGE MODE ==========\n\n# If you want to use the preconfigured remote API dedicated to the plugin, fill in the pluginUsageMode field with 'api'.\n# If you want to use a personal installation and configuration, fill in the pluginUsageMode field with 'self-hosted'.\n# If you only want the URLCustomDiscsPack.zip resource pack to be updated locally in your server files and duplicated to a custom path with a custom name, fill in the pluginUsageMode field with 'edit-only'.\n# Note: Edit-Only mode can be useful if you already have an HTTP server serving another resource pack, and if you have a plugin that allows you to merge your current resource pack with the URLCustomDiscsPack.zip resource pack.\npluginUsageMode: \"api\"\n\n\n# ========== REMOTE API MODE CONFIGURATION ==========\n\n# API base URL used to make requests to the remote API.\napiBaseURL: \"http://167.235.148.137:80\"\n\n# Unique token automatically generated for identification to the remote API when creating your first custom disc.\ntoken: \"\"\n\n# Download URL of the resource pack, automatically generated when creating your first custom disc, which uses the token to locate your resource pack.\napiDownloadResourcePackURL: \"\"\n# Once your token and apiDownloadResourcePackURL have been generated, fill in the 'resource-pack=' field in your Minecraft server's 'server.properties' file, following the example below.\n# Example: resource-pack=YOUR_apiDownloadResourcePackURL\n# Then restart your Minecraft server.\n\n# Once you have filled in the 'resource-pack=' field and tested that it works, you can now force players to install the resource pack by setting the 'require-resource-pack=' field to true in your Minecraft server's 'server.properties' file, following the example below.\n# Example: require-resource-pack=true\n# Then restart your Minecraft server.\n\n\n# localYtDlp: If set to true, uses the yt-dlp tool, automatically downloaded according to the operating system of your Minecraft server, to download audio directly from YouTube.\n# This allows you to continue using YouTube URLs even if the remote API is blocked by YouTube or other websites like soundcloud.\n# Not recommended for shared Minecraft hosting providers (such as Shockbyte), as they usually block yt-dlp execution or are already IP-banned.\n# You must restart your server after changing this option for it to take effect.\nlocalYtDlp: false\n\n\n# ========== SELF-HOSTED MODE CONFIGURATION ==========\n\n# Resource pack access mode on the HTTP server that determines how the resource pack is retrieved and updated.\n# Fill in the resourcePackAccessMode field with 'local' or 'online' depending on your setup and preference.\n# - 'local': Access the resource pack on the HTTP server via an absolute path.\n# - 'online': Download and upload the resource pack on the HTTP server via HTTP requests.\n# Available options for the two possible configurations:\n# - If your Minecraft server and HTTP server are on the same machine, you can use either 'local' or 'online'.\n# - If your Minecraft server and HTTP server are on different machines, you must use 'online'.\nresourcePackAccessMode: \"local\"\n\n\n# If you are using the local resource pack access mode, fill in the zipFileAbsolutePath field.\n\n# Absolute path to the URLCustomDiscsPack.zip resource pack, hosted on the HTTP server, for editing.\n# Example for Windows: C:/Apache24/htdocs/URLCustomDiscsPack.zip\n# Example for Linux: /var/www/html/URLCustomDiscsPack.zip\nzipFileAbsolutePath: \"C:/Apache24/htdocs/URLCustomDiscsPack.zip\"\n\n\n# If you are using the online resource pack access mode, fill in both the downloadResourcePackURL and uploadResourcePackURL fields.\n\n# Download URL of the URLCustomDiscsPack.zip resource pack from the HTTP server, used to retrieve and edit the resource pack.\n# Example: http://11.111.11.1:80/URLCustomDiscsPack.zip\ndownloadResourcePackURL: \"http://11.111.11.1:80/URLCustomDiscsPack.zip\"\n\n# Upload URL of the URLCustomDiscsPack.zip resource pack to the HTTP server, used to update the resource pack.\n# Example: http://11.111.11.1:80/upload.php\nuploadResourcePackURL: \"http://11.111.11.1:80/upload.php\"\n\n\n# ========== EDIT-ONLY MODE CONFIGURATION ==========\n\n# Path (including the custom filename) to the duplicated URLCustomDiscsPack.zip resource pack, relative to the plugins folder, for merging or other use.\n# Example: OtherPlugin/merge_folder/PackToMerge.zip\nduplicatedZipFilePath: \"URLCustomDiscs/edit-only_mode_reference_resource_pack/duplicated_resource_pack/DuplicatedURLCustomDiscsPack.zip\"\n";
                try (FileWriter writer = new FileWriter(configFile);){
                    writer.write(configContent);
                }
            }
            catch (IOException e) {
                this.getLogger().severe("Exception: " + e.getMessage());
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        this.pluginUsageMode = config.getString("pluginUsageMode");
        this.apiBaseURL = config.getString("apiBaseURL");
        this.token = config.getString("token");
        this.apiDownloadResourcePackURL = config.getString("apiDownloadResourcePackURL");
        this.localYtDlp = config.getBoolean("localYtDlp");
        this.downloadResourcePackURL = config.getString("downloadResourcePackURL");
        this.resourcePackAccessMode = config.getString("resourcePackAccessMode");
        this.zipFileAbsolutePath = config.getString("zipFileAbsolutePath");
        this.uploadResourcePackURL = config.getString("uploadResourcePackURL");
        this.duplicatedZipFilePath = config.getString("duplicatedZipFilePath");
        if (this.pluginUsageMode == null) {
            this.getLogger().warning("config.yml ERROR : The plugin usage mode is not defined.");
        }
        if (this.downloadResourcePackURL == null) {
            this.getLogger().warning("config.yml ERROR : Download resource pack URL is not configured.");
        }
        if (!Objects.equals(this.resourcePackAccessMode, "local") && !Objects.equals(this.resourcePackAccessMode, "online")) {
            this.getLogger().warning("config.yml ERROR : Minecraft server type is not configured.");
        }
        if (Objects.equals(this.resourcePackAccessMode, "local") && Objects.equals(this.zipFileAbsolutePath, "")) {
            this.getLogger().warning("config.yml ERROR : Absolute resource pack file path is not configured.");
        }
        if (Objects.equals(this.resourcePackAccessMode, "online") && Objects.equals(this.uploadResourcePackURL, "")) {
            this.getLogger().warning("config.yml ERROR : Download resource pack URL is not configured.");
        }
        if ("edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            if (Objects.equals(this.duplicatedZipFilePath, "")) {
                this.getLogger().warning("config.yml ERROR : Duplicated resource pack file path is not configured.");
            } else if (this.duplicatedZipFilePath != null && !this.duplicatedZipFilePath.toLowerCase().endsWith(".zip")) {
                this.getLogger().warning("config.yml ERROR : Duplicated resource pack file path must point to a .zip file.");
            }
        }
    }

    public String getOperatingSystem() {
        return this.os;
    }

    private void loadFiles() {
        File discUuidFile = new File(this.getDataFolder(), "discs.json");
        if (!discUuidFile.exists()) {
            try {
                discUuidFile.createNewFile();
                Files.writeString(discUuidFile.toPath(), (CharSequence)"{}", new OpenOption[0]);
            }
            catch (IOException e) {
                this.getLogger().severe("Exception: " + e.getMessage());
            }
        }
        this.audioToSendFolder = new File(this.getDataFolder(), "audio_to_send");
        if (!this.audioToSendFolder.exists()) {
            this.audioToSendFolder.mkdir();
        }
        this.binFolder = new File(this.getDataFolder(), "bin");
        if (!this.binFolder.exists()) {
            this.binFolder.mkdir();
        }
        if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            this.editResourcePackFolder = new File(this.getDataFolder(), "edit_resource_pack");
            if (!this.editResourcePackFolder.exists()) {
                this.editResourcePackFolder.mkdirs();
            }
            this.tempAudioFolder = new File(this.editResourcePackFolder, "temp_audio");
            if (!this.tempAudioFolder.exists()) {
                this.tempAudioFolder.mkdirs();
            }
            this.tempUnpackedFolder = new File(this.editResourcePackFolder, "temp_unpacked");
            if (!this.tempUnpackedFolder.exists()) {
                this.tempUnpackedFolder.mkdirs();
            }
        }
        if ("edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            this.editOnlyModeReferenceResourcePackFolder = new File(this.getDataFolder(), "edit-only_mode_reference_resource_pack");
            if (!this.editOnlyModeReferenceResourcePackFolder.exists()) {
                this.editOnlyModeReferenceResourcePackFolder.mkdirs();
            }
            this.editOnlyModeZipFilePath = new File(this.editOnlyModeReferenceResourcePackFolder, "URLCustomDiscsPack.zip").getAbsolutePath();
            File editOnlyModeDuplicatedResourcePackFolder = new File(this.editOnlyModeReferenceResourcePackFolder, "duplicated_resource_pack");
            if (!editOnlyModeDuplicatedResourcePackFolder.exists()) {
                editOnlyModeDuplicatedResourcePackFolder.mkdirs();
            }
        }
    }

    public String getMinecraftServerVersion() {
        return this.minecraftServerVersion;
    }

    public String getPluginUsageMode() {
        return this.pluginUsageMode;
    }

    public File getAudioToSendFolder() {
        return this.audioToSendFolder;
    }

    public File getBinFolder() {
        return this.binFolder;
    }

    public File getEditResourcePackFolder() {
        return this.editResourcePackFolder;
    }

    public File getTempAudioFolder() {
        return this.tempAudioFolder;
    }

    public File getTempUnpackedFolder() {
        return this.tempUnpackedFolder;
    }

    public File getAudioFolder() {
        if ("api".equalsIgnoreCase(this.pluginUsageMode) && this.getLocalYtDlp().booleanValue()) {
            return this.audioToSendFolder;
        }
        if ("self-hosted".equalsIgnoreCase(this.pluginUsageMode) || "edit-only".equalsIgnoreCase(this.pluginUsageMode)) {
            return this.tempAudioFolder;
        }
        throw new IllegalStateException("Unknown pluginUsageMode: " + this.pluginUsageMode);
    }

    public String getApiBaseURL() {
        return this.apiBaseURL;
    }

    public String getToken() {
        return this.token != null ? this.token : "";
    }

    public void setToken(String newToken) {
        this.token = newToken;
    }

    public String getApiDownloadResourcePackURL() {
        return this.apiDownloadResourcePackURL != null ? this.apiDownloadResourcePackURL : "";
    }

    public void setApiDownloadResourcePackURL(String newApiDownloadResourcePackURL) {
        this.apiDownloadResourcePackURL = newApiDownloadResourcePackURL;
    }

    public Boolean getLocalYtDlp() {
        return this.localYtDlp != null ? this.localYtDlp : false;
    }

    public String getDownloadResourcePackURL() {
        return this.downloadResourcePackURL;
    }

    public String getUploadResourcePackURL() {
        return this.uploadResourcePackURL;
    }

    public String getResourcePackAccessMode() {
        return this.resourcePackAccessMode;
    }

    public String getZipFileAbsolutePath() {
        return this.zipFileAbsolutePath;
    }

    public File getEditOnlyModeReferenceResourcePackFolder() {
        return this.editOnlyModeReferenceResourcePackFolder;
    }

    public String getEditOnlyModeZipFilePath() {
        return this.editOnlyModeZipFilePath;
    }

    public String getDuplicatedZipFilePath() {
        return this.duplicatedZipFilePath;
    }

    public static enum OS {
        WINDOWS_X64,
        WINDOWS_ARM64,
        LINUX_X64,
        LINUX_ARM64,
        LINUX_ARMV7,
        LINUX_MUSL_X64,
        LINUX_MUSL_ARM64,
        OTHER;

    }
}

