/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.URLCustomDiscs;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class YtDlpManager {
    private final URLCustomDiscs plugin;
    private final File ytDlpFile;
    private final URLCustomDiscs.OS os;

    public YtDlpManager(URLCustomDiscs plugin, URLCustomDiscs.OS os) {
        this.plugin = plugin;
        this.os = os;
        File binDir = plugin.getBinFolder();
        String ytDlpName = switch (os) {
            case URLCustomDiscs.OS.WINDOWS_X64 -> "yt-dlp.exe";
            case URLCustomDiscs.OS.WINDOWS_ARM64 -> "yt-dlp_arm64.exe";
            case URLCustomDiscs.OS.LINUX_X64 -> "yt-dlp_linux";
            case URLCustomDiscs.OS.LINUX_ARM64 -> "yt-dlp_linux_aarch64";
            case URLCustomDiscs.OS.LINUX_ARMV7 -> "yt-dlp_linux_armv7l";
            case URLCustomDiscs.OS.LINUX_MUSL_X64 -> "yt-dlp_musllinux";
            case URLCustomDiscs.OS.LINUX_MUSL_ARM64 -> "yt-dlp_musllinux_aarch64";
            default -> "yt-dlp";
        };
        this.ytDlpFile = new File(binDir, ytDlpName);
    }

    public boolean downloadAudioWithYtDlp(String url, File outputFile) {
        try {
            ProcessBuilder pb = new ProcessBuilder(this.ytDlpFile.getAbsolutePath(), "--no-playlist", "-f", "bestaudio[ext=m4a]/best", "--audio-format", "mp3", "-o", outputFile.getAbsolutePath(), url);
            File denoFile = new File(this.plugin.getBinFolder(), this.os == URLCustomDiscs.OS.WINDOWS_X64 || this.os == URLCustomDiscs.OS.WINDOWS_ARM64 ? "deno.exe" : "deno");
            pb.environment().put("DENO_PATH", denoFile.getAbsolutePath());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.plugin.getLogger().info("[yt-dlp] " + line);
                }
            }
            int exitCode = process.waitFor();
            return exitCode == 0 && outputFile.exists();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("[yt-dlp] Failed to run yt-dlp: " + e.getMessage());
            return false;
        }
    }
}

