/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs;

import com.urlcustomdiscs.URLCustomDiscs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class YtDlpSetup {
    private final JavaPlugin plugin;
    private final URLCustomDiscs.OS os;
    private final File ytDlpFile;

    public YtDlpSetup(JavaPlugin plugin, URLCustomDiscs.OS os) {
        this.plugin = plugin;
        this.os = os;
        File binDir = new File(plugin.getDataFolder(), "bin");
        String ytDlpName = switch (os) {
            case URLCustomDiscs.OS.WINDOWS_X64 -> "yt-dlp.exe";
            case URLCustomDiscs.OS.WINDOWS_ARM64 -> "yt-dlp_arm64.exe";
            case URLCustomDiscs.OS.LINUX_X64 -> "yt-dlp_linux";
            case URLCustomDiscs.OS.LINUX_ARM64 -> "yt-dlp_linux_aarch64";
            case URLCustomDiscs.OS.LINUX_ARMV7 -> "yt-dlp_linux_armv7l";
            case URLCustomDiscs.OS.LINUX_MUSL_X64 -> "yt-dlp_musllinux";
            case URLCustomDiscs.OS.LINUX_MUSL_ARM64 -> "yt-dlp_musllinux_aarch64";
            default -> "yt-dlp";
        };
        this.ytDlpFile = new File(binDir, ytDlpName);
    }

    public void setup() {
        try {
            String localVersion = this.getLocalVersion();
            String latestVersion = this.fetchLatestVersion();
            this.plugin.getLogger().info("[SETUP] Local yt-dlp version: " + (localVersion == null ? "none" : localVersion));
            this.plugin.getLogger().info("[SETUP] Latest yt-dlp version: " + latestVersion);
            if (localVersion == null || !localVersion.equals(latestVersion)) {
                this.plugin.getLogger().info("[SETUP] Updating yt-dlp...");
                if (this.ytDlpFile.exists()) {
                    this.ytDlpFile.delete();
                }
                String downloadUrl = switch (this.os) {
                    case URLCustomDiscs.OS.WINDOWS_X64 -> "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp.exe";
                    case URLCustomDiscs.OS.WINDOWS_ARM64 -> "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_arm64.exe";
                    case URLCustomDiscs.OS.LINUX_X64 -> "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_linux";
                    case URLCustomDiscs.OS.LINUX_ARM64 -> "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_linux_aarch64";
                    case URLCustomDiscs.OS.LINUX_ARMV7 -> "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_linux_armv7l.zip";
                    case URLCustomDiscs.OS.LINUX_MUSL_X64 -> "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_musllinux";
                    case URLCustomDiscs.OS.LINUX_MUSL_ARM64 -> "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_musllinux_aarch64";
                    default -> throw new IllegalStateException("Unsupported OS/architecture combination: " + String.valueOf((Object)this.os));
                };
                if (this.os == URLCustomDiscs.OS.LINUX_ARMV7) {
                    File zipFile = new File(this.ytDlpFile.getParentFile(), "yt-dlp_linux_armv7l.zip");
                    this.downloadFile(downloadUrl, zipFile);
                    this.unzipSingleFile(zipFile, "yt-dlp_linux_armv7l", this.ytDlpFile);
                    if (!zipFile.delete()) {
                        this.plugin.getLogger().warning("[SETUP] Could not delete " + zipFile.getName());
                    }
                } else {
                    this.downloadFile(downloadUrl, this.ytDlpFile);
                }
                if (!this.ytDlpFile.setExecutable(true)) {
                    this.plugin.getLogger().warning("[SETUP] Could not set yt-dlp as executable.");
                }
                this.plugin.getLogger().info("[SETUP] yt-dlp updated.");
            } else {
                this.plugin.getLogger().info("[SETUP] yt-dlp is up-to-date.");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[SETUP] Failed to setup yt-dlp: " + e.getMessage());
        }
    }

    private String getLocalVersion() {
        if (!this.ytDlpFile.exists()) {
            return null;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(this.ytDlpFile.getAbsolutePath(), "--version");
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String version = reader.readLine();
            p.waitFor();
            return version != null ? version.trim() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String fetchLatestVersion() throws IOException {
        HttpURLConnection connection = YtDlpSetup.openHttpConnection("https://api.github.com/repos/yt-dlp/yt-dlp/releases/latest", 5000, 5000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder json = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
            String tagName = this.parseTagNameFromJson(json.toString());
            if (tagName == null) {
                throw new IOException("Invalid GitHub API response: tag_name missing");
            }
            String string = tagName.startsWith("v") ? tagName.substring(1) : tagName;
            return string;
        }
    }

    private String parseTagNameFromJson(String json) {
        int idx = json.indexOf("\"tag_name\"");
        if (idx == -1) {
            return null;
        }
        int start = json.indexOf("\"", idx + 10);
        if (start == -1) {
            return null;
        }
        int end = json.indexOf("\"", start + 1);
        if (end == -1) {
            return null;
        }
        return json.substring(start + 1, end);
    }

    private void downloadFile(String urlString, File destination) throws IOException {
        this.plugin.getLogger().info("[SETUP] Downloading " + urlString);
        HttpURLConnection connection = YtDlpSetup.openHttpConnection(urlString, 10000, 10000);
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(destination);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unzipSingleFile(File zipFile, String fileNameInZip, File targetFile) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().equals(fileNameInZip)) continue;
                targetFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(targetFile);
                try {
                    zis.transferTo(fos);
                    return;
                }
                finally {
                    fos.close();
                    return;
                }
            }
        }
    }

    @NotNull
    private static HttpURLConnection openHttpConnection(String urlString, int connectTimeout, int readTimeout) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", "JavaPlugin");
        connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed request to " + urlString + ", HTTP " + connection.getResponseCode());
        }
        return connection;
    }
}

