/*
 * Decompiled with CFR 0.152.
 */
package com.urlcustomdiscs.utils;

public class MinecraftServerVersionUtils {
    private final int major;
    private final int minor;
    private final int patch;

    private MinecraftServerVersionUtils(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static MinecraftServerVersionUtils parse(String minecraftServerVersion) {
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (minecraftServerVersion != null) {
            String core = minecraftServerVersion.split("[\\-+]")[0];
            String[] parts = core.split("\\.");
            try {
                if (parts.length > 0) {
                    major = Integer.parseInt(parts[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (parts.length > 1) {
                    minor = Integer.parseInt(parts[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (parts.length > 2) {
                    patch = Integer.parseInt(parts[2]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new MinecraftServerVersionUtils(major, minor, patch);
    }

    public boolean isNewFormat() {
        if (this.major > 1) {
            return true;
        }
        if (this.major < 1) {
            return false;
        }
        if (this.minor > 21) {
            return true;
        }
        if (this.minor < 21) {
            return false;
        }
        return this.patch >= 4;
    }

    public boolean isNewDropPosition() {
        if (this.major > 1) {
            return true;
        }
        if (this.major < 1) {
            return false;
        }
        if (this.minor > 21) {
            return true;
        }
        if (this.minor < 21) {
            return false;
        }
        return this.patch >= 3;
    }
}

