/*
 * Decompiled with CFR 0.152.
 */
package limitless.enchantments;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import limitless.enchantments.EnchantmentsPersistentState;
import limitless.enchantments.LimitlessEnchantments;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1887;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import semantic.ver.lib.SemanticVersion;

public class LimitlessCommand {
    public static final void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"limitless").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Limitless Enchantments v" + LimitlessEnchantments.VERSION.toString())), true);
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.thank.you"), true);
            return 0;
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"maxEnchantmentLevel").requires(source -> source.method_9259(2))).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.maxEnchantmentLevel"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.maxEnchantmentLevel.description"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.maxEnchantmentLevel.value", (Object[])new Object[]{LimitlessEnchantments.formatInt(LimitlessEnchantments.MAX_ENCHANTMENT_LEVEL)}), false);
            return 0;
        })).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            LimitlessEnchantments.MAX_ENCHANTMENT_LEVEL = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.maxEnchantmentLevel.set", (Object[])new Object[]{LimitlessEnchantments.formatInt(LimitlessEnchantments.MAX_ENCHANTMENT_LEVEL)}), true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"maxTradeLevel").requires(source -> source.method_9259(2))).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.maxTradeLevel"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.maxTradeLevel.description"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.maxTradeLevel.value", (Object[])new Object[]{LimitlessEnchantments.formatInt(LimitlessEnchantments.MAX_TRADE_LEVEL)}), false);
            return 0;
        })).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            if (level > LimitlessEnchantments.MAX_ENCHANTMENT_LEVEL) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.maxTradeLevel.error").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), true);
                return 1;
            }
            LimitlessEnchantments.MAX_TRADE_LEVEL = level;
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.maxTradeLevel.set", (Object[])new Object[]{LimitlessEnchantments.formatInt(LimitlessEnchantments.MAX_TRADE_LEVEL)}), true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"anvilExperienceCostLimit").requires(source -> source.method_9259(2))).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.anvilExperienceCostLimit"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.anvilExperienceCostLimit.description"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.anvilExperienceCostLimit.value", (Object[])new Object[]{LimitlessEnchantments.formatInt(LimitlessEnchantments.ANVIL_EXPERIENCE_COST_LIMIT)}), false);
            return 0;
        })).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)40, (int)Integer.MAX_VALUE)).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            LimitlessEnchantments.ANVIL_EXPERIENCE_COST_LIMIT = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.anvilExperienceCostLimit.set", (Object[])new Object[]{LimitlessEnchantments.formatInt(LimitlessEnchantments.ANVIL_EXPERIENCE_COST_LIMIT)}), true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"noIncompatibilities").requires(source -> source.method_9259(2))).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.noIncompatibilities"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.noIncompatibilities.description"), false);
            if (LimitlessEnchantments.NO_INCOMPATIBILITIES) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.noIncompatibilities.on"), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.noIncompatibilities.off"), false);
            }
            return 0;
        })).then(class_2170.method_9244((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            LimitlessEnchantments.NO_INCOMPATIBILITIES = BoolArgumentType.getBool((CommandContext)context, (String)"bool");
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            if (LimitlessEnchantments.NO_INCOMPATIBILITIES) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.noIncompatibilities.set"), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.noIncompatibilities.unset"), true);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rebalancedTrades").requires(source -> source.method_9259(2))).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.rebalancedTrades"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.rebalancedTrades.description"), false);
            if (LimitlessEnchantments.REBALANCED_TRADES) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.rebalancedTrades.on"), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.rebalancedTrades.off"), false);
            }
            return 0;
        })).then(class_2170.method_9244((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            LimitlessEnchantments.REBALANCED_TRADES = BoolArgumentType.getBool((CommandContext)context, (String)"bool");
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            if (LimitlessEnchantments.REBALANCED_TRADES) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.rebalancedTrades.set"), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.rebalancedTrades.unset"), true);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"showActualNumbers").requires(source -> source.method_9259(2))).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.showActualNumbers"), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.showActualNumbers.description"), false);
            if (LimitlessEnchantments.SHOW_ACTUAL_NUMBERS) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.showActualNumbers.on"), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.showActualNumbers.off"), false);
            }
            return 0;
        })).then(class_2170.method_9244((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            LimitlessEnchantments.SHOW_ACTUAL_NUMBERS = BoolArgumentType.getBool((CommandContext)context, (String)"bool");
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            if (LimitlessEnchantments.SHOW_ACTUAL_NUMBERS) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.showActualNumbers.set"), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.showActualNumbers.unset"), true);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blacklist").requires(source -> source.method_9259(2))).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            if (!LimitlessEnchantments.blackListedEnchantments.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.blacklist.not_empty", (Object[])new Object[]{LimitlessEnchantments.formattedList(LimitlessEnchantments.blackListedEnchantments)}), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.blacklist.empty"), true);
            }
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            return 0;
        })).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41265)).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            class_6880.class_6883 enchantment = class_7733.method_45612((CommandContext)context, (String)"enchantment");
            if (!LimitlessEnchantments.blackListedEnchantments.contains(enchantment.method_55840())) {
                LimitlessEnchantments.blackListedEnchantments.add(enchantment.method_55840());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.blacklist.blacklisted", (Object[])new Object[]{((class_1887)enchantment.comp_349()).comp_2686().getString()}), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.blacklist.already.blacklisted", (Object[])new Object[]{((class_1887)enchantment.comp_349()).comp_2686().getString()}).method_10862(class_2583.field_24360).method_27692(class_124.field_1061), true);
            }
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41265)).executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            class_6880.class_6883 enchantment = class_7733.method_45612((CommandContext)context, (String)"enchantment");
            if (LimitlessEnchantments.blackListedEnchantments.contains(enchantment.method_55840())) {
                LimitlessEnchantments.blackListedEnchantments.remove(enchantment.method_55840());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.blacklist.removed", (Object[])new Object[]{((class_1887)enchantment.comp_349()).comp_2686().getString()}), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.blacklist.not_in", (Object[])new Object[]{((class_1887)enchantment.comp_349()).comp_2686().getString()}).method_10862(class_2583.field_24360.method_27706(class_124.field_1061)), true);
            }
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        })))).then(class_2170.method_9247((String)"clear").executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            LimitlessEnchantments.blackListedEnchantments.clear();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.blacklist.cleared"), true);
            LimitlessCommand.saveSettings(((class_2168)context.getSource()).method_9225());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            return 0;
        }))).then(class_2170.method_9247((String)"addAll").executes(context -> {
            LimitlessCommand.checkForUpdates((CommandContext<class_2168>)context);
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            ArrayList copy = (ArrayList)LimitlessEnchantments.blackListedEnchantments.clone();
            LimitlessEnchantments.blackListedEnchantments.clear();
            boolean success = true;
            try {
                world.method_30349().method_30530(class_7924.field_41265).forEach(e -> {
                    class_6880 entry = world.method_30349().method_30530(class_7924.field_41265).method_47983(e);
                    if (entry != null) {
                        LimitlessEnchantments.blackListedEnchantments.add(entry.method_55840());
                    }
                });
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.addAll.success"), true);
            }
            catch (Exception e2) {
                LimitlessEnchantments.blackListedEnchantments = copy;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.addAll.fail").method_10862(class_2583.field_24360.method_27706(class_124.field_1061)), true);
                success = false;
            }
            LimitlessCommand.saveSettings(world);
            if (success) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"limitless.warning.setting.change"), false);
            }
            return 0;
        })))));
    }

    private static void checkForUpdates(CommandContext<class_2168> context) {
        SemanticVersion newVersion = LimitlessEnchantments.VERSION.newVersionAvailable();
        if (!newVersion.isInvalid()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.update.available", (Object[])new Object[]{newVersion.toString()}), true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.update.please"), true);
        }
    }

    private static void saveSettings(class_3218 world) {
        JsonObject obj = new JsonObject();
        JsonArray array = new JsonArray();
        for (String e : LimitlessEnchantments.blackListedEnchantments) {
            array.add(e);
        }
        obj.add("blacklist", (JsonElement)array);
        obj.addProperty("maxEnchantmentLevel", (Number)LimitlessEnchantments.MAX_ENCHANTMENT_LEVEL);
        obj.addProperty("maxTradeLevel", (Number)LimitlessEnchantments.MAX_TRADE_LEVEL);
        obj.addProperty("anvilExperienceCostLimit", (Number)LimitlessEnchantments.ANVIL_EXPERIENCE_COST_LIMIT);
        obj.addProperty("noIncompatibilities", Boolean.valueOf(LimitlessEnchantments.NO_INCOMPATIBILITIES));
        obj.addProperty("rebalancedTrades", Boolean.valueOf(LimitlessEnchantments.REBALANCED_TRADES));
        obj.addProperty("showActualNumbers", Boolean.valueOf(LimitlessEnchantments.SHOW_ACTUAL_NUMBERS));
        EnchantmentsPersistentState.save(world, "limitlessenchantments", (JsonElement)obj);
    }
}

