/*
 * Decompiled with CFR 0.152.
 */
package limitless.enchantments;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HexFormat;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import limitless.enchantments.LimitlessEnchantments;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public final class EnchantmentsPersistentState {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final SecureRandom RNG = new SecureRandom();

    private EnchantmentsPersistentState() {
    }

    public static void save(class_3218 world, String name, JsonElement json) {
        try {
            MinecraftServer server = world.method_8503();
            Path dir = EnchantmentsPersistentState.worldDataDir(server);
            Files.createDirectories(dir, new FileAttribute[0]);
            SecretKey key = EnchantmentsPersistentState.loadOrCreateKey(EnchantmentsPersistentState.keyDir(server));
            byte[] plaintext = GSON.toJson(json).getBytes(StandardCharsets.UTF_8);
            byte[] aad = EnchantmentsPersistentState.buildAAD(world, name);
            byte[] enc = Crypto.encryptAesGcm(key, plaintext, aad);
            Path out = dir.resolve(EnchantmentsPersistentState.safeFileName(name) + ".dat");
            Files.write(out, enc, new OpenOption[0]);
        }
        catch (IOException iOException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    public static JsonElement load(class_3218 world, String name) {
        try {
            MinecraftServer server = world.method_8503();
            Path dir = EnchantmentsPersistentState.worldDataDir(server);
            Path in = dir.resolve(EnchantmentsPersistentState.safeFileName(name) + ".dat");
            if (!Files.exists(in, new LinkOption[0])) {
                LimitlessEnchantments.LOGGER.info(String.valueOf(in) + " doesn't exist? Probably initial boot.");
                return null;
            }
            SecretKey key = EnchantmentsPersistentState.loadOrCreateKey(EnchantmentsPersistentState.keyDir(server));
            byte[] aad = EnchantmentsPersistentState.buildAAD(world, name);
            byte[] enc = Files.readAllBytes(in);
            byte[] dec = Crypto.decryptAesGcm(key, enc, aad);
            String jsonStr = new String(dec, StandardCharsets.UTF_8);
            return JsonParser.parseString((String)jsonStr);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean delete(class_3218 world, String name) {
        try {
            Path dir = EnchantmentsPersistentState.worldDataDir(world.method_8503());
            Path in = dir.resolve(EnchantmentsPersistentState.safeFileName(name) + ".json.enc");
            if (Files.exists(in, new LinkOption[0])) {
                Files.delete(in);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static byte[] buildAAD(class_3218 world, String name) {
        String dimId = EnchantmentsPersistentState.safeFileName(world.toString());
        String aadStr = "limitlessenchantments|" + dimId + "|" + name;
        return aadStr.getBytes(StandardCharsets.UTF_8);
    }

    private static Path worldDataDir(MinecraftServer server) {
        Path root = server.method_27050(class_5218.field_24188);
        return root.resolve("data");
    }

    private static Path keyDir(MinecraftServer server) {
        Path root = server.method_27050(class_5218.field_24188);
        return root;
    }

    private static String safeFileName(String s) {
        Object safe = s.replaceAll("[^a-zA-Z0-9-_]", "_");
        if (((String)safe).isBlank()) {
            safe = "entry" + HexFormat.of().formatHex(EnchantmentsPersistentState.random(4));
        }
        return safe;
    }

    private static SecretKey loadOrCreateKey(Path dir) throws IOException, GeneralSecurityException {
        Path keyFile = dir.resolve("key.bin");
        if (Files.exists(keyFile, new LinkOption[0])) {
            byte[] raw = Files.readAllBytes(keyFile);
            if (raw.length != 32) {
                throw new GeneralSecurityException("Invalid key.bin length: " + raw.length);
            }
            return new SecretKeySpec(raw, "AES");
        }
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(256, RNG);
        SecretKey key = kg.generateKey();
        byte[] raw = key.getEncoded();
        Files.createDirectories(dir, new FileAttribute[0]);
        Files.write(keyFile, raw, new OpenOption[0]);
        return key;
    }

    private static byte[] random(int len) {
        byte[] b = new byte[len];
        RNG.nextBytes(b);
        return b;
    }

    private static final class Crypto {
        private static final int GCM_TAG_BITS = 128;

        private Crypto() {
        }

        static byte[] encryptAesGcm(SecretKey key, byte[] plaintext, byte[] aad) throws GeneralSecurityException {
            byte[] iv = EnchantmentsPersistentState.random(12);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)key, new GCMParameterSpec(128, iv));
            if (aad != null && aad.length > 0) {
                cipher.updateAAD(aad);
            }
            byte[] ct = cipher.doFinal(plaintext);
            byte[] out = new byte[1 + iv.length + ct.length];
            out[0] = 1;
            System.arraycopy(iv, 0, out, 1, iv.length);
            System.arraycopy(ct, 0, out, 1 + iv.length, ct.length);
            return out;
        }

        static byte[] decryptAesGcm(SecretKey key, byte[] packed, byte[] aad) throws GeneralSecurityException {
            if (packed.length < 29) {
                throw new GeneralSecurityException("Ciphertext too short");
            }
            byte ver = packed[0];
            if (ver != 1) {
                throw new GeneralSecurityException("Unsupported ciphertext version: " + ver);
            }
            byte[] iv = new byte[12];
            System.arraycopy(packed, 1, iv, 0, 12);
            byte[] ct = new byte[packed.length - 1 - 12];
            System.arraycopy(packed, 13, ct, 0, ct.length);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)key, new GCMParameterSpec(128, iv));
            if (aad != null && aad.length > 0) {
                cipher.updateAAD(aad);
            }
            return cipher.doFinal(ct);
        }
    }
}

