/*
 * Decompiled with CFR 0.152.
 */
package limitless.enchantments;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import limitless.enchantments.EnchantmentsPersistentState;
import limitless.enchantments.LimitlessCommand;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1887;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import semantic.ver.lib.SemanticVerLib;
import semantic.ver.lib.SemanticVersion;

public class LimitlessEnchantments
implements ModInitializer {
    private static final String URL = "https://raw.githubusercontent.com/ThomasDarkson/limitlessenchantments/refs/heads/version/version.txt";
    public static final SemanticVersion VERSION = SemanticVersion.stable((int)1, (int)2, (int)2, (String)"https://raw.githubusercontent.com/ThomasDarkson/limitlessenchantments/refs/heads/version/version.txt");
    public static final String MOD_ID = "limitlessenchantments";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"limitlessenchantments");
    public static int MAX_ENCHANTMENT_LEVEL = 0;
    public static int ANVIL_EXPERIENCE_COST_LIMIT = 40;
    public static boolean NO_INCOMPATIBILITIES = true;
    public static boolean REBALANCED_TRADES = false;
    public static boolean SHOW_ACTUAL_NUMBERS = true;
    public static ArrayList<String> blackListedEnchantments = new ArrayList();
    public static final HashMap<String, class_1887> blackListedEnchantmentsMap = new HashMap();

    public void onInitialize() {
        SemanticVerLib.initialize();
        LimitlessCommand.init();
        VERSION.checkForUpdates(null);
    }

    public static void loadSettings(class_3218 world) {
        blackListedEnchantments.clear();
        blackListedEnchantmentsMap.clear();
        MAX_ENCHANTMENT_LEVEL = 0;
        ANVIL_EXPERIENCE_COST_LIMIT = 40;
        NO_INCOMPATIBILITIES = true;
        REBALANCED_TRADES = false;
        SHOW_ACTUAL_NUMBERS = true;
        try {
            JsonObject obj = EnchantmentsPersistentState.load(world, MOD_ID).getAsJsonObject();
            MAX_ENCHANTMENT_LEVEL = obj.get("maxEnchantmentLevel").getAsInt();
            ANVIL_EXPERIENCE_COST_LIMIT = obj.get("anvilExperienceCostLimit").getAsInt();
            NO_INCOMPATIBILITIES = obj.get("noIncompatibilities").getAsBoolean();
            REBALANCED_TRADES = obj.get("noIncompatibilities").getAsBoolean();
            SHOW_ACTUAL_NUMBERS = obj.get("showActualNumbers").getAsBoolean();
            JsonArray array = obj.get("blacklist").getAsJsonArray();
            for (JsonElement i : array.asList()) {
                String s = i.getAsString();
                blackListedEnchantments.add(s);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }

    public static boolean compareEnchantments(class_1887 e1, class_1887 e2) {
        Field[] fields;
        if (e1 == e2) {
            return true;
        }
        for (Field field : fields = e1.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value1 = field.get(e1);
                Object value2 = field.get(e2);
                ArrayList<String> list = new ArrayList<String>();
                list.add("comp_2688");
                if (Objects.equals(value1, value2) || list.contains(field.getName())) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return true;
    }

    public static String formattedList(ArrayList<String> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String l = list.get(i);
            class_1887 e = blackListedEnchantmentsMap.get(l);
            if (e != null) {
                sb.append(e.comp_2686().getString());
            }
            if (i >= list.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static ArrayList<String> parseStr(String s) {
        if ((s = s.trim()).startsWith("[") && s.endsWith("]")) {
            s = s.substring(1, s.length() - 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!s.isEmpty()) {
            for (String item : s.split(",\\s*")) {
                list.add(item);
            }
        }
        return list;
    }

    public static String convertToRoman(int number) {
        StringBuilder roman = new StringBuilder();
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] numerals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        if (number <= 3999) {
            for (int i = 0; i < values.length; ++i) {
                while (number >= values[i]) {
                    roman.append(numerals[i]);
                    number -= values[i];
                }
            }
            return roman.toString();
        }
        StringBuilder compact = new StringBuilder();
        int thousands = number / 1000;
        int remainder = number % 1000;
        if (thousands > 0) {
            compact.append("\"M\" x ").append(thousands);
        }
        if (remainder > 0) {
            compact.append(" + \"").append(LimitlessEnchantments.convertToRoman(remainder)).append("\"");
        }
        return compact.toString();
    }
}

